/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HistogramEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public HistogramEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public List<Map> evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        List numbers1 = (List)colEval1.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        for (int i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        int bins = 10;
        if (this.subEvaluators.size() == 2) {
            StreamEvaluator binsEval = (StreamEvaluator)this.subEvaluators.get(1);
            Number binsNum = (Number)binsEval.evaluate(tuple);
            bins = binsNum.intValue();
        }
        EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution(bins);
        empiricalDistribution.load(column1);
        ArrayList<Map> binList = new ArrayList<Map>();
        List summaries = empiricalDistribution.getBinStats();
        for (SummaryStatistics statisticalSummary : summaries) {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("max", statisticalSummary.getMax());
            map.put("mean", statisticalSummary.getMean());
            map.put("min", statisticalSummary.getMin());
            map.put("stdev", statisticalSummary.getStandardDeviation());
            map.put("sum", statisticalSummary.getSum());
            map.put("N", statisticalSummary.getN());
            map.put("var", statisticalSummary.getVariance());
            binList.add(map);
        }
        return binList;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

