/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MovingAverageEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public MovingAverageEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        List numbers;
        StreamEvaluator colEval = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator windowEval = (StreamEvaluator)this.subEvaluators.get(1);
        int window = ((Number)windowEval.evaluate(tuple)).intValue();
        if (window > (numbers = (List)colEval.evaluate(tuple)).size()) {
            throw new IOException("The window size cannot be larger then the array");
        }
        ArrayList<Number> moving = new ArrayList<Number>();
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(window);
        for (int i = 0; i < numbers.size(); ++i) {
            descriptiveStatistics.addValue(((Number)numbers.get(i)).doubleValue());
            if (descriptiveStatistics.getN() < (long)window) continue;
            moving.add(descriptiveStatistics.getMean());
        }
        return moving;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

