/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.V2Response;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.Utils;

public class V2Request
extends SolrRequest<V2Response> {
    public static final ThreadLocal<AtomicLong> v2Calls = new ThreadLocal();
    static final Pattern COLL_REQ_PATTERN = Pattern.compile("/(c|collections)/([^/])+/(?!shards)");
    private InputStream payload;
    private SolrParams solrParams;
    public final boolean useBinary;
    private String collection;
    private boolean isPerCollectionRequest = false;

    private V2Request(SolrRequest.METHOD m, String resource, boolean useBinary) {
        super(m, resource);
        Matcher matcher = COLL_REQ_PATTERN.matcher(this.getPath());
        if (matcher.find()) {
            this.collection = matcher.group(2);
            this.isPerCollectionRequest = true;
        }
        this.useBinary = useBinary;
    }

    @Override
    public SolrParams getParams() {
        return this.solrParams;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        if (v2Calls.get() != null) {
            v2Calls.get().incrementAndGet();
        }
        if (this.payload != null) {
            return Collections.singleton(new ContentStreamBase(){

                @Override
                public InputStream getStream() throws IOException {
                    return V2Request.this.payload;
                }

                @Override
                public String getContentType() {
                    return V2Request.this.useBinary ? "application/javabin" : "application/json";
                }
            });
        }
        return null;
    }

    public boolean isPerCollectionRequest() {
        return this.isPerCollectionRequest;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    @Override
    protected V2Response createResponse(SolrClient client) {
        return new V2Response();
    }

    public static class Builder {
        private String resource;
        private SolrRequest.METHOD method = SolrRequest.METHOD.GET;
        private Object payload;
        private SolrParams params;
        private boolean useBinary = false;

        public Builder(String resource) {
            if (!resource.startsWith("/")) {
                resource = "/" + resource;
            }
            this.resource = resource;
        }

        public Builder withMethod(SolrRequest.METHOD m) {
            this.method = m;
            return this;
        }

        public Builder withPayload(String payload) {
            if (payload != null) {
                this.payload = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
            }
            return this;
        }

        public Builder withPayload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Builder withPayload(InputStream payload) {
            this.payload = payload;
            return this;
        }

        public Builder withParams(SolrParams params) {
            this.params = params;
            return this;
        }

        public Builder useBinary(boolean flag) {
            this.useBinary = flag;
            return this;
        }

        public V2Request build() {
            try {
                V2Request v2Request = new V2Request(this.method, this.resource, this.useBinary);
                v2Request.solrParams = this.params;
                InputStream is = null;
                if (this.payload != null) {
                    is = this.payload instanceof InputStream ? (InputStream)this.payload : (this.useBinary ? Utils.toJavabin(this.payload) : new ByteArrayInputStream(Utils.toJSON(this.payload)));
                }
                v2Request.payload = is;
                return v2Request;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }
}

