/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public class Row
implements MapWriter {
    public final String node;
    final Cell[] cells;
    public Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas;
    boolean anyValueMissing = false;
    boolean isLive = true;
    Policy.Session session;

    public Row(String node, List<Pair<String, Suggestion.ConditionType>> params, List<String> perReplicaAttributes, Policy.Session session) {
        this.session = session;
        this.collectionVsShardVsReplicas = session.nodeStateProvider.getReplicaInfo(node, perReplicaAttributes);
        if (this.collectionVsShardVsReplicas == null) {
            this.collectionVsShardVsReplicas = new HashMap<String, Map<String, List<ReplicaInfo>>>();
        }
        this.node = node;
        this.cells = new Cell[params.size()];
        this.isLive = session.cloudManager.getClusterStateProvider().getLiveNodes().contains(node);
        List<String> paramNames = params.stream().map(Pair::first).collect(Collectors.toList());
        Map vals = this.isLive ? session.nodeStateProvider.getNodeValues(node, paramNames) : Collections.emptyMap();
        for (int i = 0; i < params.size(); ++i) {
            Pair<String, Suggestion.ConditionType> pair = params.get(i);
            this.cells[i] = new Cell(i, pair.first(), Clause.validate(pair.first(), vals.get(pair.first()), false), null, pair.second(), this);
            if ("node".equals(pair.first())) {
                this.cells[i].val = node;
            }
            if (this.cells[i].val != null) continue;
            this.anyValueMissing = true;
        }
    }

    public Row(String node, Cell[] cells, boolean anyValueMissing, Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, boolean isLive, Policy.Session session) {
        this.session = session;
        this.node = node;
        this.isLive = isLive;
        this.cells = new Cell[cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = cells[i].copy();
            this.cells[i].row = this;
        }
        this.anyValueMissing = anyValueMissing;
        this.collectionVsShardVsReplicas = collectionVsShardVsReplicas;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put("node", this.node);
        ew.put("replicas", this.collectionVsShardVsReplicas);
        ew.put("isLive", this.isLive);
        ew.put("attributes", Arrays.asList(this.cells));
    }

    Row copy(Policy.Session session) {
        return new Row(this.node, this.cells, this.anyValueMissing, Utils.getDeepCopy(this.collectionVsShardVsReplicas, 3), this.isLive, session);
    }

    Object getVal(String name) {
        for (Cell cell : this.cells) {
            if (!cell.name.equals(name)) continue;
            return cell.val;
        }
        return null;
    }

    Object getVal(String name, Object def) {
        for (Cell cell : this.cells) {
            if (!cell.name.equals(name)) continue;
            return cell.val == null ? def : cell.val;
        }
        return def;
    }

    public String toString() {
        return this.node;
    }

    public Row addReplica(String coll, String shard, Replica.Type type) {
        Row row = this.session.copy().getNode(this.node);
        if (row == null) {
            throw new RuntimeException("couldn't get a row");
        }
        Map c = row.collectionVsShardVsReplicas.computeIfAbsent(coll, k -> new HashMap());
        List replicas = c.computeIfAbsent(shard, k -> new ArrayList());
        String replicaname = "" + new Random().nextInt(1000) + 1000;
        ReplicaInfo ri = new ReplicaInfo(replicaname, replicaname, coll, shard, type, this.node, Utils.makeMap("type", type != null ? type.toString() : Replica.Type.NRT.toString()));
        replicas.add(ri);
        for (Cell cell : row.cells) {
            cell.type.projectAddReplica(cell, ri);
        }
        return row;
    }

    public ReplicaInfo getReplica(String coll, String shard, Replica.Type type) {
        Map<String, List<ReplicaInfo>> c = this.collectionVsShardVsReplicas.get(coll);
        if (c == null) {
            return null;
        }
        List<ReplicaInfo> r = c.get(shard);
        if (r == null) {
            return null;
        }
        int idx = -1;
        for (int i = 0; i < r.size(); ++i) {
            ReplicaInfo info = r.get(i);
            if (type != null && info.getType() != type) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        return r.get(idx);
    }

    public Pair<Row, ReplicaInfo> removeReplica(String coll, String shard, Replica.Type type) {
        Row row = this.session.copy().getNode(this.node);
        Map<String, List<ReplicaInfo>> c = row.collectionVsShardVsReplicas.get(coll);
        if (c == null) {
            return null;
        }
        List<ReplicaInfo> r = c.get(shard);
        if (r == null) {
            return null;
        }
        int idx = -1;
        for (int i = 0; i < r.size(); ++i) {
            ReplicaInfo info = r.get(i);
            if (type != null && info.getType() != type) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return null;
        }
        ReplicaInfo removed = r.remove(idx);
        for (Cell cell : row.cells) {
            cell.type.projectRemoveReplica(cell, removed);
        }
        return new Pair<Row, ReplicaInfo>(row, removed);
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public void forEachReplica(Consumer<ReplicaInfo> consumer) {
        Row.forEachReplica(this.collectionVsShardVsReplicas, consumer);
    }

    public static void forEachReplica(Map<String, Map<String, List<ReplicaInfo>>> collectionVsShardVsReplicas, Consumer<ReplicaInfo> consumer) {
        collectionVsShardVsReplicas.forEach((coll, shardVsReplicas) -> shardVsReplicas.forEach((shard, replicaInfos) -> {
            for (ReplicaInfo r : replicaInfos) {
                consumer.accept(r);
            }
        }));
    }
}

