/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CellStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private String name;
    private Tuple tuple;
    private Tuple EOFTuple;

    public CellStream(String name, TupleStream stream) throws IOException {
        this.init(name, stream);
    }

    public CellStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String name = factory.getValueOperand(expression, 0);
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (streamExpressions.size() != 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting 1 stream but found %d", expression, streamExpressions.size()));
        }
        TupleStream tupleStream = factory.constructStream(streamExpressions.get(0));
        this.init(name, tupleStream);
    }

    public String getName() {
        return this.name;
    }

    private void init(String name, TupleStream tupleStream) {
        this.name = name;
        this.stream = tupleStream;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.name);
        if (includeStreams) {
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        explanation.addChild(this.stream.toExplanation(factory));
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.tuple.EOF) {
            return this.tuple;
        }
        Tuple t = this.tuple;
        this.tuple = this.EOFTuple;
        return t;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        try {
            Tuple tuple;
            this.stream.open();
            ArrayList<Tuple> list = new ArrayList<Tuple>();
            while (true) {
                tuple = this.stream.read();
                if (tuple.EOF) break;
                list.add(tuple);
            }
            this.EOFTuple = tuple;
            HashMap<String, ArrayList<Tuple>> map = new HashMap<String, ArrayList<Tuple>>();
            map.put(this.name, list);
            this.tuple = new Tuple(map);
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

