/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.Suggestion;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class SuggesterResponse {
    private static final String SUGGESTIONS_NODE_NAME = "suggestions";
    private static final String TERM_NODE_NAME = "term";
    private static final String WEIGHT_NODE_NAME = "weight";
    private static final String PAYLOAD_NODE_NAME = "payload";
    private final Map<String, List<Suggestion>> suggestionsPerDictionary = new LinkedHashMap<String, List<Suggestion>>();

    public SuggesterResponse(Map<String, NamedList<Object>> suggestInfo) {
        for (Map.Entry<String, NamedList<Object>> entry : suggestInfo.entrySet()) {
            SimpleOrderedMap suggestionsNode = (SimpleOrderedMap)entry.getValue().getVal(0);
            LinkedList<Suggestion> suggestionList = new LinkedList<Suggestion>();
            if (suggestionsNode == null) continue;
            List suggestionListToParse = (List)suggestionsNode.get(SUGGESTIONS_NODE_NAME);
            for (SimpleOrderedMap suggestion : suggestionListToParse) {
                String term = (String)suggestion.get(TERM_NODE_NAME);
                long weight = (Long)suggestion.get(WEIGHT_NODE_NAME);
                String payload = (String)suggestion.get(PAYLOAD_NODE_NAME);
                Suggestion parsedSuggestion = new Suggestion(term, weight, payload);
                suggestionList.add(parsedSuggestion);
            }
            this.suggestionsPerDictionary.put(entry.getKey(), suggestionList);
        }
    }

    public Map<String, List<Suggestion>> getSuggestions() {
        return this.suggestionsPerDictionary;
    }

    public Map<String, List<String>> getSuggestedTerms() {
        LinkedHashMap<String, List<String>> suggestedTermsPerDictionary = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<Suggestion>> entry : this.suggestionsPerDictionary.entrySet()) {
            List<Suggestion> suggestions = entry.getValue();
            LinkedList<String> suggestionTerms = new LinkedList<String>();
            for (Suggestion s : suggestions) {
                suggestionTerms.add(s.getTerm());
            }
            suggestedTermsPerDictionary.put(entry.getKey(), suggestionTerms);
        }
        return suggestedTermsPerDictionary;
    }
}

