/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2ClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.client.solrj.request.RequestWriter;

public class CloudHttp2SolrClient
extends CloudSolrClient {
    private final ClusterStateProvider stateProvider;
    private final LBHttp2SolrClient lbClient;
    private final Http2SolrClient myClient;
    private final boolean clientIsInternal;

    protected CloudHttp2SolrClient(Builder builder) {
        super(builder.shardLeadersOnly, builder.parallelUpdates, builder.directUpdatesToLeadersOnly);
        if (builder.httpClient == null) {
            this.clientIsInternal = true;
            this.myClient = builder.internalClientBuilder == null ? new Http2SolrClient.Builder().build() : builder.internalClientBuilder.build();
        } else {
            this.clientIsInternal = false;
            this.myClient = builder.httpClient;
        }
        this.retryExpiryTimeNano = builder.retryExpiryTimeNano;
        this.defaultCollection = builder.defaultCollection;
        if (builder.requestWriter != null) {
            this.myClient.requestWriter = builder.requestWriter;
        }
        if (builder.responseParser != null) {
            this.myClient.setParser(builder.responseParser);
        }
        this.stateProvider = builder.stateProvider;
        this.collectionStateCache.timeToLiveMs = TimeUnit.MILLISECONDS.convert(builder.timeToLiveSeconds, TimeUnit.SECONDS);
        this.locks = CloudHttp2SolrClient.objectList(builder.parallelCacheRefreshesLocks);
        this.lbClient = new LBHttp2SolrClient.Builder(this.myClient, new String[0]).build();
    }

    @Override
    public void close() throws IOException {
        this.stateProvider.close();
        this.lbClient.close();
        if (this.clientIsInternal && this.myClient != null) {
            this.myClient.close();
        }
        super.close();
    }

    @Override
    public LBHttp2SolrClient getLbClient() {
        return this.lbClient;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.stateProvider;
    }

    public Http2SolrClient getHttpClient() {
        return this.myClient;
    }

    @Override
    protected boolean wasCommError(Throwable rootCause) {
        return false;
    }

    public static class Builder {
        protected Collection<String> zkHosts = new ArrayList<String>();
        protected List<String> solrUrls = new ArrayList<String>();
        protected String zkChroot;
        protected Http2SolrClient httpClient;
        protected boolean shardLeadersOnly = true;
        protected boolean directUpdatesToLeadersOnly = false;
        protected boolean parallelUpdates = true;
        protected ClusterStateProvider stateProvider;
        protected Http2SolrClient.Builder internalClientBuilder;
        private RequestWriter requestWriter;
        private ResponseParser responseParser;
        private long retryExpiryTimeNano = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
        private String defaultCollection;
        private long timeToLiveSeconds = 60L;
        private int parallelCacheRefreshesLocks = 3;
        private int zkConnectTimeout = SolrZkClientTimeout.DEFAULT_ZK_CONNECT_TIMEOUT;
        private int zkClientTimeout = SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT;
        private boolean canUseZkACLs = true;

        public Builder(List<String> solrUrls) {
            this.solrUrls = solrUrls;
        }

        public Builder(List<String> zkHosts, Optional<String> zkChroot) {
            this.zkHosts = zkHosts;
            if (zkChroot.isPresent()) {
                this.zkChroot = zkChroot.get();
            }
        }

        public Builder canUseZkACLs(boolean canUseZkACLs) {
            this.canUseZkACLs = canUseZkACLs;
            return this;
        }

        public Builder sendUpdatesOnlyToShardLeaders() {
            this.shardLeadersOnly = true;
            return this;
        }

        public Builder sendUpdatesToAnyReplica() {
            this.shardLeadersOnly = false;
            return this;
        }

        public Builder sendDirectUpdatesToShardLeadersOnly() {
            this.directUpdatesToLeadersOnly = true;
            return this;
        }

        public Builder sendDirectUpdatesToAnyShardReplica() {
            this.directUpdatesToLeadersOnly = false;
            return this;
        }

        public Builder withRequestWriter(RequestWriter requestWriter) {
            this.requestWriter = requestWriter;
            return this;
        }

        public Builder withResponseParser(ResponseParser responseParser) {
            this.responseParser = responseParser;
            return this;
        }

        public Builder withParallelUpdates(boolean parallelUpdates) {
            this.parallelUpdates = parallelUpdates;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder setParallelCacheRefreshes(int parallelCacheRefreshesLocks) {
            this.withParallelCacheRefreshes(parallelCacheRefreshesLocks);
            return this;
        }

        public Builder withParallelCacheRefreshes(int parallelCacheRefreshesLocks) {
            this.parallelCacheRefreshesLocks = parallelCacheRefreshesLocks;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder setRetryExpiryTime(int secs) {
            this.withRetryExpiryTime(secs, TimeUnit.SECONDS);
            return this;
        }

        public Builder withRetryExpiryTime(long expiryTime, TimeUnit unit) {
            this.retryExpiryTimeNano = TimeUnit.NANOSECONDS.convert(expiryTime, unit);
            return this;
        }

        public Builder withDefaultCollection(String defaultCollection) {
            this.defaultCollection = defaultCollection;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder withCollectionCacheTtl(int timeToLiveSeconds) {
            this.withCollectionCacheTtl(timeToLiveSeconds, TimeUnit.SECONDS);
            return this;
        }

        public Builder withCollectionCacheTtl(long timeToLive, TimeUnit unit) {
            assert (timeToLive > 0L);
            this.timeToLiveSeconds = TimeUnit.SECONDS.convert(timeToLive, unit);
            return this;
        }

        public Builder withHttpClient(Http2SolrClient httpClient) {
            if (this.internalClientBuilder != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.httpClient = httpClient;
            return this;
        }

        public Builder withInternalClientBuilder(Http2SolrClient.Builder internalClientBuilder) {
            if (this.httpClient != null) {
                throw new IllegalStateException("The builder can't accept an httpClient AND an internalClientBuilder, only one of those can be provided");
            }
            this.internalClientBuilder = internalClientBuilder;
            return this;
        }

        public Builder withZkConnectTimeout(int zkConnectTimeout, TimeUnit unit) {
            this.zkConnectTimeout = Math.toIntExact(unit.toMillis(zkConnectTimeout));
            return this;
        }

        public Builder withZkClientTimeout(int zkClientTimeout, TimeUnit unit) {
            this.zkClientTimeout = Math.toIntExact(unit.toMillis(zkClientTimeout));
            return this;
        }

        public CloudHttp2SolrClient build() {
            if (this.stateProvider == null) {
                if (!this.zkHosts.isEmpty() && !this.solrUrls.isEmpty()) {
                    throw new IllegalArgumentException("Both zkHost(s) & solrUrl(s) have been specified. Only specify one.");
                }
                if (!this.zkHosts.isEmpty()) {
                    this.stateProvider = ClusterStateProvider.newZkClusterStateProvider(this.zkHosts, this.zkChroot, this.canUseZkACLs);
                    if (this.stateProvider instanceof SolrZkClientTimeout.SolrZkClientTimeoutAware) {
                        SolrZkClientTimeout.SolrZkClientTimeoutAware timeoutAware = (SolrZkClientTimeout.SolrZkClientTimeoutAware)((Object)this.stateProvider);
                        timeoutAware.setZkClientTimeout(this.zkClientTimeout);
                        timeoutAware.setZkConnectTimeout(this.zkConnectTimeout);
                    }
                } else if (!this.solrUrls.isEmpty()) {
                    try {
                        this.stateProvider = new Http2ClusterStateProvider(this.solrUrls, this.httpClient);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + this.solrUrls + ", down?)", e);
                    }
                } else {
                    throw new IllegalArgumentException("Both zkHosts and solrUrl cannot be null.");
                }
            }
            return new CloudHttp2SolrClient(this);
        }
    }
}

