/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UploadToFileStoreResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class FileStoreApi {

    public static class UploadFile
    extends SolrRequest<UploadFileResponse> {
        private final Object requestBody;
        private final String filePath;
        private List<String> sig;

        public UploadFile(String filePath, Object requestBody) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/cluster/files{filePath}".replace("{filePath}", filePath));
            this.filePath = filePath;
            this.requestBody = requestBody;
            this.addHeader("Content-type", "application/json");
        }

        public void setSig(List<String> sig) {
            this.sig = sig;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(final String expectedType) {
            if (this.requestBody instanceof String) {
                return new RequestWriter.StringPayloadContentWriter((String)this.requestBody, expectedType);
            }
            if (this.requestBody instanceof InputStream) {
                final InputStream inputStream = (InputStream)this.requestBody;
                return new RequestWriter.ContentWriter(){

                    @Override
                    public void write(OutputStream os) throws IOException {
                        inputStream.transferTo(os);
                    }

                    @Override
                    public String getContentType() {
                        return expectedType;
                    }
                };
            }
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.sig != null) {
                this.sig.stream().forEach(v -> params.add("sig", (String)v));
            }
            return params;
        }

        @Override
        protected UploadFileResponse createResponse(SolrClient client) {
            return new UploadFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UploadFileResponse
    extends JacksonParsingResponse<UploadToFileStoreResponse> {
        public UploadFileResponse() {
            super(UploadToFileStoreResponse.class);
        }
    }

    public static class DeleteFile
    extends SolrRequest<DeleteFileResponse> {
        private final String path;
        private Boolean localDelete;

        public DeleteFile(String path) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/cluster/files{path}".replace("{path}", path));
            this.path = path;
        }

        public void setLocalDelete(Boolean localDelete) {
            this.localDelete = localDelete;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.localDelete != null) {
                params.add("localDelete", this.localDelete.toString());
            }
            return params;
        }

        @Override
        protected DeleteFileResponse createResponse(SolrClient client) {
            return new DeleteFileResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteFileResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteFileResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

