/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.junit.AfterClass;
import org.junit.Before;

public class SolrCloudTestCase
extends SolrTestCaseJ4 {
    protected static MiniSolrCloudCluster cluster;

    protected static Builder configureCluster(int nodeCount) {
        return new Builder(nodeCount, SolrCloudTestCase.createTempDir());
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void checkClusterConfiguration() {
        if (cluster == null) {
            throw new RuntimeException("MiniSolrCloudCluster not configured - have you called configureCluster().configure()?");
        }
    }

    static /* synthetic */ JettyConfig access$000(String x0) {
        return SolrCloudTestCase.buildJettyConfig(x0);
    }

    protected static class Builder {
        private final int nodeCount;
        private final Path baseDir;
        private String solrxml = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">10000</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n  </solrcloud>\n  \n</solr>\n";
        private JettyConfig jettyConfig = SolrCloudTestCase.access$000("/solr");
        private List<Config> configs = new ArrayList<Config>();

        public Builder(int nodeCount, Path baseDir) {
            this.nodeCount = nodeCount;
            this.baseDir = baseDir;
        }

        public Builder withJettyConfig(JettyConfig jettyConfig) {
            this.jettyConfig = jettyConfig;
            return this;
        }

        public Builder withSolrXml(String solrXml) {
            this.solrxml = solrXml;
            return this;
        }

        public Builder withSolrXml(Path solrXml) {
            try {
                this.solrxml = new String(Files.readAllBytes(solrXml), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder addConfig(String configName, Path configPath) {
            this.configs.add(new Config(configName, configPath));
            return this;
        }

        public void configure() throws Exception {
            cluster = new MiniSolrCloudCluster(this.nodeCount, this.baseDir, this.solrxml, this.jettyConfig);
            CloudSolrClient client = cluster.getSolrClient();
            for (Config config : this.configs) {
                client.uploadConfig(config.path, config.name);
            }
        }
    }

    private static class Config {
        final String name;
        final Path path;

        private Config(String name, Path path) {
            this.name = name;
            this.path = path;
        }
    }
}

