/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.tests.analysis.MockTokenizer;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class MockTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "mock";
    final CharacterRunAutomaton pattern;
    final boolean enableChecks;

    public MockTokenizerFactory(Map<String, String> args) {
        super(args);
        String patternArg = this.get(args, "pattern", Arrays.asList("keyword", "simple", "whitespace"));
        this.pattern = "keyword".equalsIgnoreCase(patternArg) ? MockTokenizer.KEYWORD : ("simple".equalsIgnoreCase(patternArg) ? MockTokenizer.SIMPLE : MockTokenizer.WHITESPACE);
        this.enableChecks = this.getBoolean(args, "enableChecks", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public MockTokenizerFactory() {
        throw MockTokenizerFactory.defaultCtorException();
    }

    public MockTokenizer create(AttributeFactory factory) {
        MockTokenizer t = new MockTokenizer(factory, this.pattern, false);
        t.setEnableChecks(this.enableChecks);
        return t;
    }
}

