/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;

public class MockFSDirectoryFactory
extends StandardDirectoryFactory {
    public Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        BaseDirectoryWrapper dir = LuceneTestCase.newFSDirectory((Path)Path.of(path, new String[0]), (LockFactory)lockFactory);
        Directory cdir = this.reduce((Directory)dir);
        cdir = this.reduce(cdir);
        if ((cdir = this.reduce(cdir)) instanceof MockDirectoryWrapper) {
            ((MockDirectoryWrapper)cdir).setAssertNoUnrefencedFilesOnClose(false);
        }
        return dir;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    private Directory reduce(Directory dir) {
        Directory cdir = dir;
        if (dir instanceof NRTCachingDirectory) {
            cdir = ((NRTCachingDirectory)dir).getDelegate();
        } else if (dir instanceof TrackingDirectoryWrapper) {
            cdir = ((TrackingDirectoryWrapper)dir).getDelegate();
        }
        return cdir;
    }
}

