/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.apache.solr.core.backup.repository.DelegatingBackupRepository;

public class TrackingBackupRepository
extends DelegatingBackupRepository {
    private static final List<URI> COPIED_FILES = Collections.synchronizedList(new ArrayList());
    private static final List<URI> DIRECTORIES_CREATED = Collections.synchronizedList(new ArrayList());
    private static final List<URI> OUTPUTS_CREATED = Collections.synchronizedList(new ArrayList());

    public OutputStream createOutput(URI path) throws IOException {
        OUTPUTS_CREATED.add(path);
        return super.createOutput(path);
    }

    public void createDirectory(URI path) throws IOException {
        DIRECTORIES_CREATED.add(path);
        super.createDirectory(path);
    }

    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        COPIED_FILES.add(this.resolve(destDir, new String[]{destFileName}));
        super.copyIndexFileFrom(sourceDir, sourceFileName, destDir, destFileName);
    }

    public static List<URI> copiedFiles() {
        return new ArrayList<URI>(COPIED_FILES);
    }

    public static List<URI> directoriesCreated() {
        return new ArrayList<URI>(DIRECTORIES_CREATED);
    }

    public static List<URI> outputsCreated() {
        return new ArrayList<URI>(OUTPUTS_CREATED);
    }

    public static void clear() {
        COPIED_FILES.clear();
        DIRECTORIES_CREATED.clear();
        OUTPUTS_CREATED.clear();
    }
}

