/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrackingUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REQUEST_COUNT = "TrackingUpdateProcessorRequestCount";
    public static final String REQUEST_NODE = "TrackingUpdateProcessorRequestNode";
    private static final Map<String, List<UpdateCommand>> groupToCommands = new ConcurrentHashMap<String, List<UpdateCommand>>();
    private String group = "default";

    public static void startRecording(String group) {
        List<UpdateCommand> updateCommands = groupToCommands.get(group);
        SolrCloudTestCase.assertTrue((updateCommands == null || updateCommands.isEmpty() ? 1 : 0) != 0);
        List existing = groupToCommands.put(group, Collections.synchronizedList(new ArrayList()));
        SolrCloudTestCase.assertNull((String)"Test cross-talk?", existing);
    }

    public static List<UpdateCommand> stopRecording(String group) {
        List<UpdateCommand> commands = groupToCommands.remove(group);
        return Arrays.asList(commands.toArray(new UpdateCommand[0]));
    }

    public void init(NamedList<?> args) {
        if (args != null && args.indexOf("group", 0) >= 0) {
            this.group = (String)args.get("group");
            log.debug("Init URP, group '{}'", (Object)this.group);
        } else {
            log.warn("TrackingUpdateProcessorFactory initialized without group configuration, using 'default' but this group is sharedacross the entire VM and guaranteed to have unpredictable behavior if used by more than one test");
        }
    }

    public synchronized UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        List<UpdateCommand> commands = groupToCommands.get(this.group);
        return commands == null ? next : new RecordingUpdateRequestProcessor(commands, next);
    }

    private static final class RecordingUpdateRequestProcessor
    extends UpdateRequestProcessor {
        private final List<UpdateCommand> groupCommands;

        RecordingUpdateRequestProcessor(List<UpdateCommand> groupCommands, UpdateRequestProcessor next) {
            super(next);
            this.groupCommands = groupCommands;
        }

        private void record(UpdateCommand cmd) {
            this.groupCommands.add(cmd.clone());
            Map context = cmd.getReq().getContext();
            context.put(TrackingUpdateProcessorFactory.REQUEST_COUNT, this.groupCommands.size());
            context.put(TrackingUpdateProcessorFactory.REQUEST_NODE, cmd.getReq().getCore().getName());
        }

        public void processAdd(AddUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processAdd(cmd);
        }

        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processDelete(cmd);
        }

        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processMergeIndexes(cmd);
        }

        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processCommit(cmd);
        }

        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            this.record((UpdateCommand)cmd);
            super.processRollback(cmd);
        }
    }
}

