/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\n\u0015\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001a\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u001dY\u0007A1A\u0005\n1Daa\u001d\u0001!\u0002\u0013i\u0007b\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007u\u0002\u0001\u000b\u0011\u0002<\t\u000fm\u0004!\u0019!C\u0005y\"1a\u0010\u0001Q\u0001\nu,Qa \u0001\u0005\u0003\u0003A!\"a\u0006\u0001\u0011\u000b\u0007I\u0011BA\r\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002p\u0001!I!!\u001d\u0003\u001d\u00053(o\\*fe&\fG.\u001b>fe*\u0011QCF\u0001\u0005CZ\u0014xN\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014+\u001b\u0005A#BA\u0015\u0019\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0016)\u0005\u001daunZ4j]\u001e\f\u0001C]8pi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0011\u00059\nT\"A\u0018\u000b\u0005A2\u0012!\u0002;za\u0016\u001c\u0018B\u0001\u001a0\u0005!!\u0015\r^1UsB,\u0017\u0001\u0004:p_R\feO]8UsB,\u0007CA\u001b8\u001b\u00051$BA\u000b\u001b\u0013\tAdG\u0001\u0004TG\",W.Y\u0001\t]VdG.\u00192mKB\u0011\u0011eO\u0005\u0003y\t\u0012qAQ8pY\u0016\fg.\u0001\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0007CA U\u001d\t\u0001\u0015K\u0004\u0002B\u001d:\u0011!)\u0014\b\u0003\u00072s!\u0001R&\u000f\u0005\u0015SeB\u0001$J\u001b\u00059%B\u0001%\u001f\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0003/aI!!\u000b\f\n\u0005=\u0003\u0016aB*R\u0019\u000e{gN\u001a\u0006\u0003SYI!AU*\u0002)1+w-Y2z\u0005\u0016D\u0017M^5peB{G.[2z\u0015\ty\u0005+\u0003\u0002V-\n)a+\u00197vK&\u0011qK\t\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u00065rkfl\u0018\t\u00037\u0002i\u0011\u0001\u0006\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006g\u0015\u0001\r\u0001\u000e\u0005\u0006s\u0015\u0001\rA\u000f\u0005\u0006{\u0015\u0001\rA\u0010\u000b\u00055\u0006\u00147\rC\u0003-\r\u0001\u0007Q\u0006C\u00034\r\u0001\u0007A\u0007C\u0003:\r\u0001\u0007!(A\u0005tKJL\u0017\r\\5{KR\u0011a-\u001b\t\u0003C\u001dL!\u0001\u001b\u0012\u0003\u0007\u0005s\u0017\u0010C\u0003k\u000f\u0001\u0007a-\u0001\u0007dCR\fG._:u\t\u0006$\u0018-\u0001\beCR,'+\u001a2bg\u00164UO\\2\u0016\u00035\u0004B!\t8qa&\u0011qN\t\u0002\n\rVt7\r^5p]F\u0002\"!I9\n\u0005I\u0014#aA%oi\u0006yA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001c\u0007%A\nuS6,7\u000f^1naJ+'-Y:f\rVt7-F\u0001w!\u0011\tcn^<\u0011\u0005\u0005B\u0018BA=#\u0005\u0011auN\\4\u0002)QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2!\u0003%\u0019wN\u001c<feR,'/F\u0001~!\u0011\tcN\u001a4\u0002\u0015\r|gN^3si\u0016\u0014\bEA\u0005D_:4XM\u001d;feB9\u0011%a\u0001\u0002\bA4\u0017bAA\u0003E\tIa)\u001e8di&|gN\r\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005Ea#\u0001\u0005dCR\fG._:u\u0013\u0011\t)\"a\u0003\u0003%M\u0003XmY5bY&TX\rZ$fiR,'o]\u0001\u0013I\u0016\u001c\u0017.\\1m\u0007>tg/\u001a:tS>t7/\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001d\u0011\ty\"a\t\u000f\u0007\u0011\u000b\t#\u0003\u0002\u00165%\u0019\u0011Q\u0005\u001c\u0002\u0017\r{gN^3sg&|gn]\u0005\u0005\u0003S\tYCA\tEK\u000eLW.\u00197D_:4XM]:j_:T1!!\n7\u00031qWm^\"p]Z,'\u000f^3s)\u0019\t\t$!\u000e\u0002:A\u0019\u00111\u0007\b\u000e\u0003\u0001Aa!a\u000e\u0011\u0001\u0004i\u0013\u0001D2bi\u0006d\u0017p\u001d;UsB,\u0007BBA\u001e!\u0001\u0007A'\u0001\u0005bmJ|G+\u001f9f\u0003IqWm^*ueV\u001cGoQ8om\u0016\u0014H/\u001a:\u0015\r\u0005\u0005\u0013\u0011MA6!\u0019\tc.a\u0011\u0002LA!\u0011QIA$\u001b\t\ty!\u0003\u0003\u0002J\u0005=!aC%oi\u0016\u0014h.\u00197S_^\u0004B!!\u0014\u0002\\9!\u0011qJA+\u001d\u0011\ty\"!\u0015\n\u0007\u0005Mc'A\u0004hK:,'/[2\n\t\u0005]\u0013\u0011L\u0001\f\u000f\u0016tWM]5d\t\u0006$\u0018MC\u0002\u0002TYJA!!\u0018\u0002`\t1!+Z2pe\u0012TA!a\u0016\u0002Z!9\u00111M\tA\u0002\u0005\u0015\u0014AD2bi\u0006d\u0017p\u001d;TiJ,8\r\u001e\t\u0004]\u0005\u001d\u0014bAA5_\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u00055\u0014\u00031\u00015\u0003)\tgO]8TiJ,8\r^\u0001\u0014e\u0016\u001cx\u000e\u001c<f\u001dVdG.\u00192mKRK\b/\u001a\u000b\u0006i\u0005M\u0014Q\u000f\u0005\u0007\u0003w\u0011\u0002\u0019\u0001\u001b\t\u000be\u0012\u0002\u0019\u0001\u001e")
public class AvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType) {
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)AvroSerializer.$anonfun$newConverter$15(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable & scala.Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                boolean bl = logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis;
                if (bl) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toMillis(this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)))));
                    return intersect;
                } else {
                    if (!(logicalType instanceof LogicalTypes.TimestampMicros)) throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot convert Catalyst Timestamp type to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$17(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$18(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$19(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType = (DataType)tuple2._1();
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        MapType mapType = (MapType)dataType;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        boolean valueContainsNull = mapType.valueContainsNull();
        if (!Schema.Type.MAP.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType2 = kt;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ != null) {
                throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else if (!dataType2.equals(stringType$)) throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull));
        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct) {
        int[] nArray;
        Function2[] fieldConverters;
        block5: {
            Tuple2 tuple2;
            block4: {
                Schema.Type type = avroStruct.getType();
                Schema.Type type2 = Schema.Type.RECORD;
                if ((type != null ? !type.equals(type2) : type2 != null) || avroStruct.getFields().size() != catalystStruct.length()) {
                    throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append("Avro type ").append(avroStruct).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                }
                tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)catalystStruct.map((Function1 & Serializable & scala.Serializable)catalystField -> {
                    Schema.Field avroField = avroStruct.getField(catalystField.name());
                    if (avroField == null) {
                        throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to Avro type ").append(avroStruct).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    Function2<SpecializedGetters, Object, Object> converter = this.newConverter(catalystField.dataType(), this.resolveNullableType(avroField.schema(), catalystField.nullable()));
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), converter);
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
                if (tuple2 == null) break block4;
                int[] avroIndices = (int[])tuple2._1();
                fieldConverters = (Function2[])tuple2._2();
                if (avroIndices == null) break block4;
                nArray = avroIndices;
                if (fieldConverters != null) break block5;
            }
            throw new MatchError((Object)tuple2);
        }
        Function2[] function2Array = fieldConverters;
        Tuple2 tuple2 = new Tuple2((Object)nArray, (Object)function2Array);
        Tuple2 tuple22 = tuple2;
        int[] avroIndices = (int[])tuple22._1();
        Function2[] fieldConverters2 = (Function2[])tuple22._2();
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(avroIndices[i], null);
                    continue;
                }
                result.put(avroIndices[i], fieldConverters2[i].apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Schema schema;
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null) && nullable) {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
            Predef$.MODULE$.assert(fields.length() == 2);
            Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveNullableType$1(x$2)));
            Predef$.MODULE$.assert(actualType.length() == 1);
            schema = (Schema)actualType.head();
        } else {
            if (nullable) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing avro files with non-nullable avro schema with nullable catalyst schema will throw runtime exception if there is a record with null value.");
            }
            schema = avroType;
        }
        return schema;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x55$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x55$1.precision(), x55$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x55$1.precision(), (int)x55$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x57$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x57$1.precision(), x57$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x57$1.precision(), (int)x57$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(49).append("Cannot write \"").append(data).append("\" since it's not defined in enum \"").append(enumSymbols$1.mkString("\", \"")).append("\"").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot write ").append(data.length).append(" ").append((Object)(data.length > 1 ? "bytes" : "byte")).append(" of ").append("binary data into FIXED Type with size of ").append(size$1).append(" ").append((Object)(size$1 > 1 ? "bytes" : "byte")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ int $anonfun$newConverter$15(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.dateRebaseFunc().apply$mcII$sp(getter.getInt(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$17(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(ordinal));
    }

    public static final /* synthetic */ List $anonfun$newConverter$18(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$19(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$20(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$1(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable, Enumeration.Value datetimeRebaseMode) {
        Function1 & Serializable & scala.Serializable intersect;
        Logging.$init$((Logging)this);
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        DataType dataType = rootCatalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            intersect = this.newStructConverter(structType, actualAvroType);
        } else {
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{rootCatalystType})));
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(rootCatalystType, actualAvroType);
            intersect = (Function1 & Serializable & scala.Serializable)data -> {
                tmpRow.update(0, data);
                return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
            };
        }
        Function1 & Serializable & scala.Serializable baseConverter = intersect;
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        this(rootCatalystType, rootAvroType, nullable, SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_WRITE())));
    }
}

