/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Locale;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.CustomDecimal;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class SchemaConverters$ {
    public static SchemaConverters$ MODULE$;
    private Schema nullSchema;
    private final String CATALYST_TYPE_PROP_NAME;
    private volatile boolean bitmap$0;

    static {
        new SchemaConverters$();
    }

    private Schema nullSchema$lzycompute() {
        SchemaConverters$ schemaConverters$ = this;
        synchronized (schemaConverters$) {
            if (!this.bitmap$0) {
                this.nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                this.bitmap$0 = true;
            }
        }
        return this.nullSchema;
    }

    private Schema nullSchema() {
        if (!this.bitmap$0) {
            return this.nullSchema$lzycompute();
        }
        return this.nullSchema;
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, boolean useStableIdForUnionType) {
        return this.toSqlTypeHelper(avroSchema, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), useStableIdForUnionType);
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema) {
        return this.toSqlType(avroSchema, false);
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, Map<String, String> options) {
        return this.toSqlTypeHelper(avroSchema, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), AvroOptions$.MODULE$.apply(options).useStableIdForUnionType());
    }

    private String CATALYST_TYPE_PROP_NAME() {
        return this.CATALYST_TYPE_PROP_NAME;
    }

    private SchemaConverters.SchemaType toSqlTypeHelper(Schema avroSchema, scala.collection.immutable.Set<String> existingRecordNames, boolean useStableIdForUnionType) {
        Schema.Type type;
        block25: {
            Some some;
            Seq seq;
            while (true) {
                if (Schema.Type.INT.equals(type = avroSchema.getType())) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new SchemaConverters.SchemaType((DataType)DateType$.MODULE$, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    IntegerType$ catalystType = catalystTypeAttrValue == null ? IntegerType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.STRING.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.BOOLEAN.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)BooleanType$.MODULE$, false);
                }
                if (Schema.Type.BYTES.equals(type) ? true : Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new SchemaConverters.SchemaType((DataType)BinaryType$.MODULE$, false);
                }
                if (Schema.Type.DOUBLE.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
                if (Schema.Type.FLOAT.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)FloatType$.MODULE$, false);
                }
                if (Schema.Type.LONG.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof CustomDecimal) {
                        CustomDecimal customDecimal = (CustomDecimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(customDecimal.precision(), customDecimal.scale()), false);
                    }
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampType$.MODULE$, false);
                    }
                    if (logicalType instanceof LogicalTypes.LocalTimestampMillis ? true : logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampNTZType$.MODULE$, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    LongType$ catalystType = catalystTypeAttrValue == null ? LongType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.ENUM.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.NULL.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)NullType$.MODULE$, true);
                }
                if (Schema.Type.RECORD.equals(type)) {
                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                        throw new IncompatibleSchemaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("\n            |Found recursive reference in Avro schema, which can not be processed by Spark:\n            |").append(avroSchema.toString(true)).append("\n          ").toString())).stripMargin(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    scala.collection.immutable.Set newRecordNames = (scala.collection.immutable.Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                    Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> {
                        SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(f.schema(), (scala.collection.immutable.Set<String>)newRecordNames, useStableIdForUnionType);
                        return new StructField(f.name(), schemaType.dataType(), schemaType.nullable(), StructField$.MODULE$.apply$default$4());
                    }, Buffer$.MODULE$.canBuildFrom());
                    return new SchemaConverters.SchemaType((DataType)new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class))), false);
                }
                if (Schema.Type.ARRAY.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getElementType(), existingRecordNames, useStableIdForUnionType);
                    return new SchemaConverters.SchemaType((DataType)new ArrayType(schemaType.dataType(), schemaType.nullable()), false);
                }
                if (Schema.Type.MAP.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getValueType(), existingRecordNames, useStableIdForUnionType);
                    return new SchemaConverters.SchemaType((DataType)new MapType((DataType)StringType$.MODULE$, schemaType.dataType(), schemaType.nullable()), false);
                }
                if (!Schema.Type.UNION.equals(type)) break block25;
                if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$2(x$1)))) {
                    Seq<Schema> remainingUnionTypes = AvroUtils$.MODULE$.nonNullUnionBranches(avroSchema);
                    if (remainingUnionTypes.size() == 1) {
                        SchemaConverters.SchemaType qual$1 = this.toSqlTypeHelper((Schema)remainingUnionTypes.head(), existingRecordNames, useStableIdForUnionType);
                        boolean x$12 = true;
                        DataType x$22 = qual$1.copy$default$1();
                        return qual$1.copy(x$22, x$12);
                    }
                    SchemaConverters.SchemaType qual$2 = this.toSqlTypeHelper(Schema.createUnion((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(remainingUnionTypes).asJava())), existingRecordNames, useStableIdForUnionType);
                    boolean x$3 = true;
                    DataType x$4 = qual$2.copy$default$1();
                    return qual$2.copy(x$4, x$3);
                }
                seq = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) break;
                avroSchema = (Schema)avroSchema.getTypes().get(0);
            }
            Some some3 = Seq$.MODULE$.unapplySeq(seq);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((SeqLike)some3.get()).apply(0);
                Schema.Type t2 = (Schema.Type)((SeqLike)some3.get()).apply(1);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable2) : genTraversable2 != null)) {
                    return new SchemaConverters.SchemaType((DataType)LongType$.MODULE$, false);
                }
            }
            if (!(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((SeqLike)some.get()).apply(0);
                Schema.Type t2 = (Schema.Type)((SeqLike)some.get()).apply(1);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable3 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable3) : genTraversable3 != null)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
            }
            Set fieldNameSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String string;
                    Schema s = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(s, existingRecordNames, useStableIdForUnionType);
                    if (useStableIdForUnionType) {
                        String temp_name = new StringBuilder(7).append("member_").append(s.getName().toLowerCase(Locale.ROOT)).toString();
                        if (fieldNameSet.contains((Object)temp_name)) {
                            throw new IncompatibleSchemaException(new StringBuilder(89).append("Cannot generate stable indentifier for Avro union type due to name ").append("conflict of type name ").append(s.getName()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                        }
                        fieldNameSet.add((Object)temp_name);
                        string = temp_name;
                    } else {
                        string = new StringBuilder(6).append("member").append(i).toString();
                    }
                    String fieldName = string;
                    return new StructField(fieldName, schemaType.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            }, Buffer$.MODULE$.canBuildFrom());
            return new SchemaConverters.SchemaType((DataType)new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class))), false);
        }
        throw new IncompatibleSchemaException(new StringBuilder(17).append("Unsupported type ").append(type).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    /*
     * Unable to fully structure code
     */
    public Schema toAvroType(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block11: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block10: {
                                                                builder = SchemaBuilder.builder();
                                                                var10_6 = catalystType;
                                                                if (!BooleanType$.MODULE$.equals(var10_6)) break block10;
                                                                v0 = (Schema)builder.booleanType();
                                                                break block11;
                                                            }
                                                            if (!(ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false))) break block12;
                                                            v0 = (Schema)builder.intType();
                                                            break block11;
                                                        }
                                                        if (!LongType$.MODULE$.equals(var10_6)) break block13;
                                                        v0 = (Schema)builder.longType();
                                                        break block11;
                                                    }
                                                    if (!DateType$.MODULE$.equals(var10_6)) break block14;
                                                    v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                                    break block11;
                                                }
                                                if (!TimestampType$.MODULE$.equals(var10_6)) break block15;
                                                v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                                break block11;
                                            }
                                            if (!TimestampNTZType$.MODULE$.equals(var10_6)) break block16;
                                            v0 = LogicalTypes.localTimestampMicros().addToSchema((Schema)builder.longType());
                                            break block11;
                                        }
                                        if (!FloatType$.MODULE$.equals(var10_6)) break block17;
                                        v0 = (Schema)builder.floatType();
                                        break block11;
                                    }
                                    if (!DoubleType$.MODULE$.equals(var10_6)) break block18;
                                    v0 = (Schema)builder.doubleType();
                                    break block11;
                                }
                                if (!StringType$.MODULE$.equals(var10_6)) break block19;
                                v0 = (Schema)builder.stringType();
                                break block11;
                            }
                            if (!NullType$.MODULE$.equals(var10_6)) break block20;
                            v0 = (Schema)builder.nullType();
                            break block11;
                        }
                        if (!(var10_6 instanceof DecimalType)) break block21;
                        var11_7 = (DecimalType)var10_6;
                        avroType = LogicalTypes.decimal((int)var11_7.precision(), (int)var11_7.scale());
                        fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var11_7.precision()];
                        var15_10 = nameSpace;
                        name = "".equals(var15_10) != false ? new StringBuilder(6).append(recordName).append(".fixed").toString() : new StringBuilder(7).append(nameSpace).append(".").append(recordName).append(".fixed").toString();
                        v0 = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block11;
                    }
                    if (!BinaryType$.MODULE$.equals(var10_6)) break block22;
                    v0 = (Schema)builder.bytesType();
                    break block11;
                }
                if (!(var10_6 instanceof ArrayType)) break block23;
                var16_12 = (ArrayType)var10_6;
                et = var16_12.elementType();
                containsNull = var16_12.containsNull();
                v0 = (Schema)builder.array().items(this.toAvroType(et, containsNull, recordName, nameSpace));
                break block11;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var19_15 = (MapType)var10_6;
            var20_16 = var19_15.keyType();
            vt = var19_15.valueType();
            valueContainsNull = var19_15.valueContainsNull();
            if (StringType$.MODULE$.equals(var20_16)) {
                v0 = (Schema)builder.map().values(this.toAvroType(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var23_19 = (StructType)var10_6;
                v1 = nameSpace;
                var25_20 = "";
                childNameSpace = (v1 == null ? var25_20 != null : v1.equals(var25_20) == false) ? new StringBuilder(1).append(nameSpace).append(".").append(recordName).toString() : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var23_19.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$1(java.lang.String org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, (SchemaBuilder.FieldAssembler)fieldsAssembler));
                v0 = (Schema)fieldsAssembler.endRecord();
            } else if (var10_6 instanceof YearMonthIntervalType) {
                var27_23 = (YearMonthIntervalType)var10_6;
                ymIntervalType = (Schema)builder.intType();
                ymIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var27_23.typeName());
                v0 = ymIntervalType;
            } else if (var10_6 instanceof DayTimeIntervalType) {
                var29_25 = (DayTimeIntervalType)var10_6;
                dtIntervalType = (Schema)builder.longType();
                dtIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var29_25.typeName());
                v0 = dtIntervalType;
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(var10_6).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            v2 = catalystType;
            var31_28 = NullType$.MODULE$;
            if (v2 == null ? var31_28 != null : v2.equals(var31_28) == false) {
                return Schema.createUnion((Schema[])new Schema[]{schema, this.nullSchema()});
            }
        }
        return schema;
    }

    public boolean toAvroType$default$2() {
        return false;
    }

    public String toAvroType$default$3() {
        return "topLevelRecord";
    }

    public String toAvroType$default$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$2(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$toAvroType$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.toAvroType(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    private SchemaConverters$() {
        MODULE$ = this;
        this.CATALYST_TYPE_PROP_NAME = "spark.sql.catalyst.type";
    }
}

