/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.bagel;

import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Logging;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.bagel.Aggregator;
import org.apache.spark.bagel.Combiner;
import org.apache.spark.bagel.DefaultCombiner;
import org.apache.spark.bagel.Message;
import org.apache.spark.bagel.Vertex;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest;
import scala.reflect.Manifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bagel$
implements Logging {
    public static final Bagel$ MODULE$;
    private final StorageLevel DEFAULT_STORAGE_LEVEL;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Bagel$();
    }

    public final Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public final void org$apache$spark$Logging$$log__$eq(Logger logger) {
        this.org$apache$spark$Logging$$log_ = logger;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initLogging() {
        Logging.class.initLogging((Logging)this);
    }

    public StorageLevel DEFAULT_STORAGE_LEVEL() {
        return this.DEFAULT_STORAGE_LEVEL;
    }

    public <K, V extends Vertex, M extends Message<K>, C, A> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner$1, Option<Aggregator<V, A>> aggregator, Partitioner partitioner, int numPartitions, StorageLevel storageLevel, Function4<V, Option<C>, Option<A>, Object, Tuple2<V, M[]>> compute$1, Manifest<K> evidence$1, Manifest<V> evidence$2, Manifest<M> evidence$3, Manifest<C> evidence$4, Manifest<A> evidence$5) {
        Tuple3<RDD<Tuple2<K, Tuple2<V, M[]>>>, Object, Object> tuple3;
        block1: {
            int numActiveVerts;
            int numMsgs;
            int splits = numPartitions != 0 ? numPartitions : sc.defaultParallelism();
            IntRef superstep$1 = new IntRef(0);
            RDD verts = vertices;
            RDD msgs = messages;
            boolean noActivity = false;
            do {
                this.logInfo((Function0)new Serializable(superstep$1){
                    public static final long serialVersionUID;
                    private final IntRef superstep$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Starting superstep ").append((Object)BoxesRunTime.boxToInteger((int)this.superstep$1.elem)).append((Object)".").toString();
                    }
                    {
                        this.superstep$1 = intRef;
                    }
                });
                long startTime = System.currentTimeMillis();
                Option<A> aggregated$1 = this.agg(verts, aggregator, evidence$5);
                PairRDDFunctions qual$1 = SparkContext$.MODULE$.rddToPairRDDFunctions(msgs, evidence$1, evidence$3);
                Serializable x$7 = new Serializable(combiner$1){
                    public static final long serialVersionUID;
                    private final Combiner combiner$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final C apply(M m) {
                        return this.combiner$1.createCombiner(m);
                    }
                    {
                        this.combiner$1 = combiner;
                    }
                };
                Serializable x$8 = new Serializable(combiner$1){
                    public static final long serialVersionUID;
                    private final Combiner combiner$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final C apply(C c, M m) {
                        return this.combiner$1.mergeMsg(c, m);
                    }
                    {
                        this.combiner$1 = combiner;
                    }
                };
                Serializable x$9 = new Serializable(combiner$1){
                    public static final long serialVersionUID;
                    private final Combiner combiner$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final C apply(C c, C c2) {
                        return this.combiner$1.mergeCombiners(c, c2);
                    }
                    {
                        this.combiner$1 = combiner;
                    }
                };
                Partitioner x$10 = partitioner;
                boolean x$11 = qual$1.combineByKey$default$5();
                String x$12 = qual$1.combineByKey$default$6();
                RDD combinedMsgs = qual$1.combineByKey((Function1)x$7, (Function2)x$8, (Function2)x$9, x$10, x$11, x$12);
                RDD grouped = SparkContext$.MODULE$.rddToPairRDDFunctions(combinedMsgs, evidence$1, evidence$4).groupWith(verts);
                int superstep_$1 = superstep$1.elem++;
                tuple3 = this.comp(sc, (RDD<Tuple2<K, Tuple2<Seq<C>, Seq<V>>>>)grouped, (Function2<V, Option<C>, Tuple2<V, M[]>>)new Serializable(compute$1, aggregated$1, superstep_$1){
                    public static final long serialVersionUID;
                    private final Function4 compute$1;
                    private final Option aggregated$1;
                    private final int superstep_$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<V, M[]> apply(V v, Option<C> option) {
                        return (Tuple2)this.compute$1.apply(v, option, (Object)this.aggregated$1, (Object)BoxesRunTime.boxToInteger((int)this.superstep_$1));
                    }
                    {
                        this.compute$1 = function4;
                        this.aggregated$1 = option;
                        this.superstep_$1 = n;
                    }
                }, storageLevel, evidence$1);
                if (tuple3 == null) break block1;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                RDD processed = (RDD)tuple32._1();
                numMsgs = BoxesRunTime.unboxToInt((Object)tuple32._2());
                numActiveVerts = BoxesRunTime.unboxToInt((Object)tuple32._3());
                long timeTaken$1 = System.currentTimeMillis() - startTime;
                this.logInfo((Function0)new Serializable(superstep$1, timeTaken$1){
                    public static final long serialVersionUID;
                    private final IntRef superstep$1;
                    private final long timeTaken$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Superstep %d took %d s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.superstep$1.elem), BoxesRunTime.boxToLong((long)(this.timeTaken$1 / 1000L))}));
                    }
                    {
                        this.superstep$1 = intRef;
                        this.timeTaken$1 = l;
                    }
                });
                verts = SparkContext$.MODULE$.rddToPairRDDFunctions(processed, evidence$1, ClassManifest$.MODULE$.classType(Tuple2.class, evidence$2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.arrayType(evidence$3)}))).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final V apply(Tuple2<V, M[]> tuple2) {
                        Tuple2<V, M[]> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return (V)((Vertex)tuple22._1());
                        }
                        throw new MatchError(tuple22);
                    }
                });
                msgs = processed.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TraversableOnce<Tuple2<K, M>> apply(Tuple2<K, Tuple2<V, M[]>> tuple2) {
                        Tuple2<K, Tuple2<V, M[]>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23 = (Tuple2)tuple22._2();
                            if (tuple23 != null) {
                                return (TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])tuple23._2()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final Tuple2<K, M> apply(M m) {
                                        return new Tuple2(m.targetId(), m);
                                    }
                                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple22);
                    }
                }, ClassManifest$.MODULE$.classType(Tuple2.class, evidence$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{evidence$3})));
            } while (!(noActivity = numMsgs == 0 && numActiveVerts == 0));
            return verts;
        }
        throw new MatchError(tuple3);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, Partitioner partitioner, int numPartitions, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$6, Manifest<V> evidence$7, Manifest<M> evidence$8, Manifest<C> evidence$9) {
        return this.run(sc, vertices, messages, combiner, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$6, evidence$7, evidence$8, evidence$9);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, Partitioner partitioner, int numPartitions, StorageLevel storageLevel, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$10, Manifest<V> evidence$11, Manifest<M> evidence$12, Manifest<C> evidence$13) {
        return this.run(sc, vertices, messages, combiner, (Option)None$.MODULE$, partitioner, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$10, evidence$11, evidence$12), evidence$10, evidence$11, evidence$12, evidence$13, (Manifest)Manifest$.MODULE$.Nothing());
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, int numPartitions, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$14, Manifest<V> evidence$15, Manifest<M> evidence$16, Manifest<C> evidence$17) {
        return this.run(sc, vertices, messages, combiner, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$14, evidence$15, evidence$16, evidence$17);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, int numPartitions, StorageLevel storageLevel, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$18, Manifest<V> evidence$19, Manifest<M> evidence$20, Manifest<C> evidence$21) {
        HashPartitioner part = new HashPartitioner(numPartitions);
        return this.run(sc, vertices, messages, combiner, (Option)None$.MODULE$, (Partitioner)part, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$18, evidence$19, evidence$20), evidence$18, evidence$19, evidence$20, evidence$21, (Manifest)Manifest$.MODULE$.Nothing());
    }

    public <K, V extends Vertex, M extends Message<K>> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, int numPartitions, Function3<V, Option<M[]>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$22, Manifest<V> evidence$23, Manifest<M> evidence$24) {
        return this.run(sc, vertices, messages, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$22, evidence$23, evidence$24);
    }

    public <K, V extends Vertex, M extends Message<K>> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, int numPartitions, StorageLevel storageLevel, Function3<V, Option<M[]>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$25, Manifest<V> evidence$26, Manifest<M> evidence$27) {
        HashPartitioner part = new HashPartitioner(numPartitions);
        return this.run(sc, vertices, messages, (Combiner)new DefaultCombiner<M>(evidence$27), (Option)None$.MODULE$, (Partitioner)part, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$25, evidence$26, evidence$27), evidence$25, evidence$26, evidence$27, (Manifest)Manifest$.MODULE$.arrayType(evidence$27), (Manifest)Manifest$.MODULE$.Nothing());
    }

    public StorageLevel run$default$8() {
        return this.DEFAULT_STORAGE_LEVEL();
    }

    private <K, V extends Vertex, A> Option<A> agg(RDD<Tuple2<K, V>> verts, Option<Aggregator<V, A>> aggregator, Manifest<A> evidence$28) {
        Option<Aggregator<V, A>> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    Aggregator aggregator2;
                    option = aggregator;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Aggregator a$1 = aggregator2 = (Aggregator)some.x();
                    none$ = new Some(verts.map((Function1)new Serializable(a$1){
                        public static final long serialVersionUID;
                        private final Aggregator a$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final A apply(Tuple2<K, V> tuple2) {
                            Tuple2<K, V> tuple22 = tuple2;
                            if (tuple22 != null) {
                                return this.a$1.createAggregator(tuple22._2());
                            }
                            throw new MatchError(tuple22);
                        }
                        {
                            this.a$1 = aggregator;
                        }
                    }, evidence$28).reduce((Function2)new Serializable(a$1){
                        public static final long serialVersionUID;
                        private final Aggregator a$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final A apply(A a, A a2) {
                            return this.a$1.mergeAggregators(a, a2);
                        }
                        {
                            this.a$1 = aggregator;
                        }
                    }));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Aggregator<V, A>> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    private <K, V extends Vertex, M extends Message<K>, C> Tuple3<RDD<Tuple2<K, Tuple2<V, M[]>>>, Object, Object> comp(SparkContext sc, RDD<Tuple2<K, Tuple2<Seq<C>, Seq<V>>>> grouped, Function2<V, Option<C>, Tuple2<V, M[]>> compute$2, StorageLevel storageLevel, Manifest<K> evidence$29) {
        ObjectRef numMsgs$1 = new ObjectRef((Object)sc.accumulator((Object)BoxesRunTime.boxToInteger((int)0), (AccumulatorParam)SparkContext.IntAccumulatorParam$.MODULE$));
        ObjectRef numActiveVerts$1 = new ObjectRef((Object)sc.accumulator((Object)BoxesRunTime.boxToInteger((int)0), (AccumulatorParam)SparkContext.IntAccumulatorParam$.MODULE$));
        RDD processed = SparkContext$.MODULE$.rddToPairRDDFunctions(grouped, evidence$29, ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(Seq.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(Seq.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))}))).flatMapValues((Function1)new Serializable(compute$2, numMsgs$1, numActiveVerts$1){
            public static final long serialVersionUID;
            private final Function2 compute$2;
            private final ObjectRef numMsgs$1;
            private final ObjectRef numActiveVerts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<Tuple2<V, M[]>> apply(Tuple2<Seq<C>, Seq<V>> tuple2) {
                Tuple2<Seq<C>, Seq<V>> tuple22;
                block4: {
                    Seq seq;
                    block7: {
                        block10: {
                            Tuple2 tuple23;
                            block11: {
                                Iterable iterable;
                                block6: {
                                    Some some;
                                    Object object;
                                    block9: {
                                        Seq seq2;
                                        block8: {
                                            Seq seq3;
                                            Seq seq4;
                                            block5: {
                                                tuple22 = tuple2;
                                                if (tuple22 == null) break block4;
                                                seq4 = (Seq)tuple22._1();
                                                seq3 = (Seq)tuple22._2();
                                                Seq vs = seq3;
                                                if (!this.gd1$1(vs)) break block5;
                                                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                                break block6;
                                            }
                                            Seq c = seq4;
                                            Seq vs = seq3;
                                            object = vs.apply(0);
                                            seq = c;
                                            Some some2 = Seq$.MODULE$.unapplySeq((GenSeq)seq);
                                            if (!true) break block7;
                                            seq2 = (Seq)some2.get();
                                            if (!(seq2 == null ? false : seq2.lengthCompare(1) == 0)) break block8;
                                            some = new Some(seq2.apply(0));
                                            break block9;
                                        }
                                        if (!(seq2 == null ? false : seq2.lengthCompare(0) == 0)) break block10;
                                        some = None$.MODULE$;
                                    }
                                    tuple23 = (Tuple2)this.compute$2.apply(object, (Object)some);
                                    if (tuple23 == null) break block11;
                                    Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                                    Vertex newVert = (Vertex)tuple24._1();
                                    Message[] newMsgs = (Message[])tuple24._2();
                                    ((Accumulator)this.numMsgs$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newMsgs).size()));
                                    if (newVert.active()) {
                                        ((Accumulator)this.numActiveVerts$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
                                    }
                                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)newVert, (Object)newMsgs)));
                                }
                                return iterable;
                            }
                            throw new MatchError((Object)tuple23);
                        }
                        throw new MatchError((Object)seq);
                    }
                    throw new MatchError((Object)seq);
                }
                throw new MatchError(tuple22);
            }

            private final boolean gd1$1(Seq seq) {
                return seq.size() == 0;
            }
            {
                this.compute$2 = function2;
                this.numMsgs$1 = objectRef;
                this.numActiveVerts$1 = objectRef2;
            }
        }).persist(storageLevel);
        processed.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<K, Tuple2<V, M[]>> x) {
            }
        });
        return new Tuple3((Object)processed, ((Accumulator)numMsgs$1.elem).value(), ((Accumulator)numActiveVerts$1.elem).value());
    }

    private <K, V extends Vertex, M extends Message<K>, C> Function4<V, Option<C>, Option<Nothing$>, Object, Tuple2<V, M[]>> addAggregatorArg(Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute$3, Manifest<K> evidence$30, Manifest<V> evidence$31, Manifest<M> evidence$32) {
        return new Serializable(compute$3){
            public static final long serialVersionUID;
            private final Function3 compute$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<V, M[]> apply(V vert, Option<C> msgs, Option<Nothing$> aggregated, int superstep) {
                return (Tuple2)this.compute$3.apply(vert, msgs, (Object)BoxesRunTime.boxToInteger((int)superstep));
            }
            {
                this.compute$3 = function3;
            }
        };
    }

    private Bagel$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DEFAULT_STORAGE_LEVEL = StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }
}

