/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.util.HashSet;
import java.util.List;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;

public class DataTypes {
    public static final DataType StringType = StringType$.MODULE$;
    public static final DataType BinaryType = BinaryType$.MODULE$;
    public static final DataType BooleanType = BooleanType$.MODULE$;
    public static final DataType DateType = DateType$.MODULE$;
    public static final DataType TimestampType = TimestampType$.MODULE$;
    public static final DataType DoubleType = DoubleType$.MODULE$;
    public static final DataType FloatType = FloatType$.MODULE$;
    public static final DataType ByteType = ByteType$.MODULE$;
    public static final DataType IntegerType = IntegerType$.MODULE$;
    public static final DataType LongType = LongType$.MODULE$;
    public static final DataType ShortType = ShortType$.MODULE$;
    public static final DataType NullType = NullType$.MODULE$;

    public static ArrayType createArrayType(DataType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, true);
    }

    public static ArrayType createArrayType(DataType elementType, boolean containsNull) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, containsNull);
    }

    public static DecimalType createDecimalType(int precision2, int scale2) {
        return DecimalType$.MODULE$.apply(precision2, scale2);
    }

    public static DecimalType createDecimalType() {
        return DecimalType$.MODULE$.Unlimited();
    }

    public static MapType createMapType(DataType keyType, DataType valueType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, true);
    }

    public static MapType createMapType(DataType keyType, DataType valueType, boolean valueContainsNull) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, valueContainsNull);
    }

    public static StructField createStructField(String name, DataType dataType2, boolean nullable2, Metadata metadata) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null.");
        }
        if (dataType2 == null) {
            throw new IllegalArgumentException("dataType should not be null.");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("metadata should not be null.");
        }
        return new StructField(name, dataType2, nullable2, metadata);
    }

    public static StructField createStructField(String name, DataType dataType2, boolean nullable2) {
        return DataTypes.createStructField(name, dataType2, nullable2, new MetadataBuilder().build());
    }

    public static StructType createStructType(List<StructField> fields) {
        return DataTypes.createStructType(fields.toArray(new StructField[0]));
    }

    public static StructType createStructType(StructField[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields should not be null.");
        }
        HashSet<String> distinctNames = new HashSet<String>();
        for (StructField field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("fields should not contain any null.");
            }
            distinctNames.add(field.name());
        }
        if (distinctNames.size() != fields.length) {
            throw new IllegalArgumentException("fields should have distinct names.");
        }
        return StructType$.MODULE$.apply(fields);
    }
}

