/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeRowWriter {
    private BufferHolder holder;
    private int startingOffset;
    private int nullBitsSize;
    private UnsafeRow row;

    public void initialize(BufferHolder holder, int numFields) {
        this.holder = holder;
        this.startingOffset = holder.cursor;
        this.nullBitsSize = UnsafeRow.calculateBitSetWidthInBytes(numFields);
        int fixedSize = this.nullBitsSize + 8 * numFields;
        holder.grow(fixedSize, this.row);
        holder.cursor += fixedSize;
        for (int i = 0; i < this.nullBitsSize; i += 8) {
            Platform.putLong((Object)holder.buffer, (long)(this.startingOffset + i), (long)0L);
        }
    }

    public void initialize(UnsafeRow row, BufferHolder holder, int numFields) {
        this.initialize(holder, numFields);
        this.row = row;
    }

    private void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + (numBytes >> 3 << 3)), (long)0L);
        }
    }

    public BufferHolder holder() {
        return this.holder;
    }

    public boolean isNullAt(int ordinal) {
        return BitSetMethods.isSet((Object)this.holder.buffer, (long)this.startingOffset, (int)ordinal);
    }

    public void setNullAt(int ordinal) {
        BitSetMethods.set((Object)this.holder.buffer, (long)this.startingOffset, (int)ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)this.getFieldOffset(ordinal), (long)0L);
    }

    public long getFieldOffset(int ordinal) {
        return this.startingOffset + this.nullBitsSize + 8 * ordinal;
    }

    public void setOffsetAndSize(int ordinal, long size) {
        this.setOffsetAndSize(ordinal, this.holder.cursor, size);
    }

    public void setOffsetAndSize(int ordinal, long currentCursor, long size) {
        long relativeOffset = currentCursor - (long)this.startingOffset;
        long fieldOffset = this.getFieldOffset(ordinal);
        long offsetAndSize = relativeOffset << 32 | size;
        Platform.putLong((Object)this.holder.buffer, (long)fieldOffset, (long)offsetAndSize);
    }

    public void alignToWords(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder > 0) {
            int paddingBytes = 8 - remainder;
            this.holder.grow(paddingBytes, this.row);
            for (int i = 0; i < paddingBytes; ++i) {
                Platform.putByte((Object)this.holder.buffer, (long)this.holder.cursor, (byte)0);
                ++this.holder.cursor;
            }
        }
    }

    public void write(int ordinal, boolean value) {
        long offset = this.getFieldOffset(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)offset, (long)0L);
        Platform.putBoolean((Object)this.holder.buffer, (long)offset, (boolean)value);
    }

    public void write(int ordinal, byte value) {
        long offset = this.getFieldOffset(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)offset, (long)0L);
        Platform.putByte((Object)this.holder.buffer, (long)offset, (byte)value);
    }

    public void write(int ordinal, short value) {
        long offset = this.getFieldOffset(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)offset, (long)0L);
        Platform.putShort((Object)this.holder.buffer, (long)offset, (short)value);
    }

    public void write(int ordinal, int value) {
        long offset = this.getFieldOffset(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)offset, (long)0L);
        Platform.putInt((Object)this.holder.buffer, (long)offset, (int)value);
    }

    public void write(int ordinal, long value) {
        Platform.putLong((Object)this.holder.buffer, (long)this.getFieldOffset(ordinal), (long)value);
    }

    public void write(int ordinal, float value) {
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        long offset = this.getFieldOffset(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)offset, (long)0L);
        Platform.putFloat((Object)this.holder.buffer, (long)offset, (float)value);
    }

    public void write(int ordinal, double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        Platform.putDouble((Object)this.holder.buffer, (long)this.getFieldOffset(ordinal), (double)value);
    }

    public void write(int ordinal, Decimal input, int precision, int scale) {
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            if (input.changePrecision(precision, scale)) {
                Platform.putLong((Object)this.holder.buffer, (long)this.getFieldOffset(ordinal), (long)input.toUnscaledLong());
            } else {
                this.setNullAt(ordinal);
            }
        } else {
            this.holder.grow(16, this.row);
            Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)0L);
            Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + 8), (long)0L);
            if (input == null || !input.changePrecision(precision, scale)) {
                BitSetMethods.set((Object)this.holder.buffer, (long)this.startingOffset, (int)ordinal);
                this.setOffsetAndSize(ordinal, 0L);
            } else {
                byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
                assert (bytes.length <= 16);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.holder.buffer, (long)this.holder.cursor, (long)bytes.length);
                this.setOffsetAndSize(ordinal, bytes.length);
            }
            this.holder.cursor += 16;
        }
    }

    public void write(int ordinal, UTF8String input) {
        int numBytes = input.numBytes();
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        this.holder.grow(roundedSize, this.row);
        this.zeroOutPaddingBytes(numBytes);
        input.writeToMemory((Object)this.holder.buffer, (long)this.holder.cursor);
        this.setOffsetAndSize(ordinal, numBytes);
        this.holder.cursor += roundedSize;
    }

    public void write(int ordinal, byte[] input) {
        this.write(ordinal, input, 0, input.length);
    }

    public void write(int ordinal, byte[] input, int offset, int numBytes) {
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        this.holder.grow(roundedSize, this.row);
        this.zeroOutPaddingBytes(numBytes);
        Platform.copyMemory((Object)input, (long)(Platform.BYTE_ARRAY_OFFSET + offset), (Object)this.holder.buffer, (long)this.holder.cursor, (long)numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.holder.cursor += roundedSize;
    }

    public void write(int ordinal, CalendarInterval input) {
        this.holder.grow(16, this.row);
        Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)input.months);
        Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + 8), (long)input.microseconds);
        this.setOffsetAndSize(ordinal, 16L);
        this.holder.cursor += 16;
    }
}

