/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp[, idx]) - Extracts a group that matches `regexp`.", extended="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\d+)-(\\d+)', 1);\n       100\n  ")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0001\u0003\u0001>\u0011QBU3h\u000bb\u0004X\t\u001f;sC\u000e$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004tk\nTWm\u0019;\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005tk\nTWm\u0019;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u0002:fO\u0016D\b\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d\u0011XmZ3ya\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\u0004S\u0012D\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\t%$\u0007\u0010\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003#\u0001AQ!\t\u0019A\u0002\rBQ!\u000b\u0019A\u0002\rBQ!\f\u0019A\u0002\rBQ!\r\u0001\u0005\u0002a\"2aM\u001d<\u0011\u0015Qt\u00071\u0001$\u0003\u0005\u0019\b\"\u0002\u001f8\u0001\u0004\u0019\u0013!\u0001:\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0013y\u0014!\u00037bgR\u0014VmZ3y+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0015!\u0018\u0010]3t\u0015\t)\u0005\"\u0001\u0004v]N\fg-Z\u0005\u0003\u000f\n\u0013!\"\u0016+GqM#(/\u001b8h\u0011%I\u0005\u00011AA\u0002\u0013%!*A\u0007mCN$(+Z4fq~#S-\u001d\u000b\u0003\u0017:\u0003\"\u0001\u0007'\n\u00055K\"\u0001B+oSRDqa\u0014%\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBa!\u0015\u0001!B\u0013\u0001\u0015A\u00037bgR\u0014VmZ3yA!\u0012\u0001k\u0015\t\u00031QK!!V\r\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0003Y\u0003\u001d\u0001\u0018\r\u001e;fe:,\u0012!\u0017\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000bQA]3hKbT!AX0\u0002\tU$\u0018\u000e\u001c\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u00117LA\u0004QCR$XM\u001d8\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0017a\u00039biR,'O\\0%KF$\"a\u00134\t\u000f=\u001b\u0017\u0011!a\u00013\"1\u0001\u000e\u0001Q!\ne\u000b\u0001\u0002]1ui\u0016\u0014h\u000e\t\u0015\u0003ONCQa\u001b\u0001\u0005B1\fAB\\;mYN\u000bg-Z#wC2$B!\u001c9rgB\u0011\u0001D\\\u0005\u0003_f\u00111!\u00118z\u0011\u0015Q$\u000e1\u0001n\u0011\u0015\u0011(\u000e1\u0001n\u0003\u0005\u0001\b\"\u0002\u001fk\u0001\u0004i\u0007\"B;\u0001\t\u00032\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003]\u0004\"\u0001\u001f>\u000e\u0003eT!a\u0011\u0004\n\u0005mL(\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bu\u0004A\u0011\t@\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001\u0000!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u001d\u00051AH]8pizJ\u0011AG\u0005\u0004\u0003\u001fI\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004\u001a!\rA\u0018\u0011D\u0005\u0004\u00037I(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u001d\ty\u0002\u0001C!\u0003C\t\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003G\u0001R!!\u0001\u0002\u0012\rBq!a\n\u0001\t\u0003\nI#\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u000b\u0011\t\u00055\u00121\u0007\b\u00041\u0005=\u0012bAA\u00193\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r\u001a\u0011\u001d\tY\u0004\u0001C)\u0003{\t\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005}\u00121JA+!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\u0005\u000591m\u001c3fO\u0016t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\t\u0003\u001b\nI\u00041\u0001\u0002P\u0005\u00191\r\u001e=\u0011\t\u0005\u0005\u0013\u0011K\u0005\u0005\u0003'\n\u0019E\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u0011\u0005]\u0013\u0011\ba\u0001\u0003\u007f\t!!\u001a<\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0013\u0001B2paf$raMA0\u0003C\n\u0019\u0007\u0003\u0005\"\u00033\u0002\n\u00111\u0001$\u0011!I\u0013\u0011\fI\u0001\u0002\u0004\u0019\u0003\u0002C\u0017\u0002ZA\u0005\t\u0019A\u0012\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005%\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003WR3aIA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAA\u0001E\u0005I\u0011AA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\"\u0001#\u0003%\t!!\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131R\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005Mu,\u0001\u0003mC:<\u0017\u0002BA\u001b\u0003#C\u0011\"!'\u0001\u0003\u0003%\t!a'\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0005c\u0001\r\u0002 &\u0019\u0011\u0011U\r\u0003\u0007%sG\u000fC\u0005\u0002&\u0002\t\t\u0011\"\u0001\u0002(\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA7\u0002*\"Iq*a)\u0002\u0002\u0003\u0007\u0011Q\u0014\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0003R!a-\u0002:6l!!!.\u000b\u0007\u0005]\u0016$\u0001\u0006d_2dWm\u0019;j_:LA!a/\u00026\nA\u0011\n^3sCR|'\u000fC\u0005\u0002@\u0002\t\t\u0011\"\u0001\u0002B\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002D\u0006%\u0007c\u0001\r\u0002F&\u0019\u0011qY\r\u0003\u000f\t{w\u000e\\3b]\"Aq*!0\u0002\u0002\u0003\u0007Q\u000eC\u0005\u0002N\u0002\t\t\u0011\"\u0011\u0002P\u00061Q-];bYN$B!a1\u0002R\"Aq*a3\u0002\u0002\u0003\u0007Q\u000eK\u0006\u0001\u0003+\fY.!8\u0002b\u0006\r\bcA\t\u0002X&\u0019\u0011\u0011\u001c\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q\\\u0001E?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\bo\u0017\u0017!S\u0012DX,\u000b\u0011.A\u0015CHO]1diN\u0004\u0013\rI4s_V\u0004\b\u0005\u001e5bi\u0002j\u0017\r^2iKN\u0004\u0003M]3hKb\u0004\bML\u0001\tKb$XM\u001c3fI\u0006\u0012\u0011Q]\u0001Q\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013\u0007\r\u0019.eA\u0002t\u0005\f\u0011(Qq#7&K\u0017)9\u0012\\\u0013f\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00191\u0015\u0001\u0002s!CAu\u0005\u0005\u0005\t\u0012AAv\u00035\u0011VmZ#ya\u0016CHO]1diB\u0019\u0011#!<\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003_\u001cR!!<\u0002rv\u0001\u0002\"a=\u0002z\u000e\u001a3eM\u0007\u0003\u0003kT1!a>\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!a?\u0002v\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fE\ni\u000f\"\u0001\u0002\u0000R\u0011\u00111\u001e\u0005\u000b\u0005\u0007\ti/!A\u0005F\t\u0015\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0005B\u0003B\u0005\u0003[\f\t\u0011\"!\u0003\f\u0005)\u0011\r\u001d9msR91G!\u0004\u0003\u0010\tE\u0001BB\u0011\u0003\b\u0001\u00071\u0005\u0003\u0004*\u0005\u000f\u0001\ra\t\u0005\u0007[\t\u001d\u0001\u0019A\u0012\t\u0015\tU\u0011Q^A\u0001\n\u0003\u00139\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\te!Q\u0005\t\u00061\tm!qD\u0005\u0004\u0005;I\"AB(qi&|g\u000e\u0005\u0004\u0019\u0005C\u00193eI\u0005\u0004\u0005GI\"A\u0002+va2,7\u0007C\u0005\u0003(\tM\u0011\u0011!a\u0001g\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t-\u0012Q^A\u0001\n\u0013\u0011i#A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0018!\u0011\tyI!\r\n\t\tM\u0012\u0011\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpExtract
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression idx() {
        return this.idx;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        MatchResult mr;
        String group;
        Matcher m;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        return (m = this.pattern().matcher(s.toString())).find() ? ((group = (mr = m.toMatchResult()).group(BoxesRunTime.unboxToInt((Object)r))) == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group)) : UTF8String.EMPTY_UTF8;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.idx();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termLastRegex = ctx.freshName("lastRegex");
        String termPattern = ctx.freshName("pattern");
        String classNamePattern = Pattern.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        ctx.addMutableState("UTF8String", termLastRegex, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{termLastRegex})));
        ctx.addMutableState(classNamePattern, termPattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{termPattern})));
        String setEvNotNull = this.nullable() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull()})) : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, ev, termLastRegex, termPattern, classNamePattern, matcher, matchResult, setEvNotNull){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$5;
            private final String termLastRegex$2;
            private final String termPattern$2;
            private final String classNamePattern$2;
            private final String matcher$2;
            private final String matchResult$1;
            private final String setEvNotNull$2;

            public final String apply(String subject, String regexp, String idx) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      if (!", ".equals(", ")) {\n        // regex value changed\n        ", " = ", ".clone();\n        ", " = ", ".compile(", ".toString());\n      }\n      java.util.regex.Matcher ", " =\n        ", ".matcher(", ".toString());\n      if (", ".find()) {\n        java.util.regex.MatchResult ", " = ", ".toMatchResult();\n        if (", ".group(", ") == null) {\n          ", " = UTF8String.EMPTY_UTF8;\n        } else {\n          ", " = UTF8String.fromString(", ".group(", "));\n        }\n        ", "\n      } else {\n        ", " = UTF8String.EMPTY_UTF8;\n        ", "\n      }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regexp, this.termLastRegex$2, this.termLastRegex$2, regexp, this.termPattern$2, this.classNamePattern$2, this.termLastRegex$2, this.matcher$2, this.termPattern$2, subject, this.matcher$2, this.matchResult$1, this.matcher$2, this.matchResult$1, idx, this.ev$5.value(), this.ev$5.value(), this.matchResult$1, idx, this.setEvNotNull$2, this.ev$5.value(), this.setEvNotNull$2}));
            }
            {
                this.ev$5 = ev$5;
                this.termLastRegex$2 = termLastRegex$2;
                this.termPattern$2 = termPattern$2;
                this.classNamePattern$2 = classNamePattern$2;
                this.matcher$2 = matcher$2;
                this.matchResult$1 = matchResult$1;
                this.setEvNotNull$2 = setEvNotNull$2;
            }
        });
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.idx();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 0: {
                expression = this.subject();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
        ExpectsInputTypes$class.$init$(this);
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

