/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathInt$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns an integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", extended="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001F\u0011\u0001\u0002\u0017)bi\"Le\u000e\u001e\u0006\u0003\u0007\u0011\t1\u0001_7m\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0013-q\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u0019a\u0003\u0016\r\u001e5FqR\u0014\u0018m\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u000fA\u0013x\u000eZ;diB\u0011q#H\u0005\u0003=a\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u0001\u0001\u0003\u0016\u0004%\t\u0001I\u000b\u0002CA\u0011!eI\u0007\u0002\t%\u0011A\u0005\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0014\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\talG\u000e\t\u0005\tQ\u0001\u0011)\u001a!C\u0001A\u0005!\u0001/\u0019;i\u0011!Q\u0003A!E!\u0002\u0013\t\u0013!\u00029bi\"\u0004\u0003\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0005\u0001\t\u000b\rY\u0003\u0019A\u0011\t\u000b!Z\u0003\u0019A\u0011\t\u000bI\u0002A\u0011I\u001a\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u00015!\t)\u0004H\u0004\u0002\u0018m%\u0011q\u0007G\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u000281!)A\b\u0001C!{\u0005AA-\u0019;b)f\u0004X-F\u0001?!\ty$)D\u0001A\u0015\t\t\u0005\"A\u0003usB,7/\u0003\u0002D\u0001\nAA)\u0019;b)f\u0004X\rC\u0003F\u0001\u0011\u0005c)\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002H\u0015.\u0003\"a\u0006%\n\u0005%C\"aA!os\")1\u0001\u0012a\u0001\u000f\")\u0001\u0006\u0012a\u0001\u000f\"9Q\nAA\u0001\n\u0003q\u0015\u0001B2paf$2AL(Q\u0011\u001d\u0019A\n%AA\u0002\u0005Bq\u0001\u000b'\u0011\u0002\u0003\u0007\u0011\u0005C\u0004S\u0001E\u0005I\u0011A*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAK\u000b\u0002\"+.\na\u000b\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00037b\t!\"\u00198o_R\fG/[8o\u0013\ti\u0006LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u0018\u0001\u0012\u0002\u0013\u00051+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000f\u0005\u0004\u0011\u0011!C!E\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017BA\u001df\u0011\u001dY\u0007!!A\u0005\u00021\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!\u001c\t\u0003/9L!a\u001c\r\u0003\u0007%sG\u000fC\u0004r\u0001\u0005\u0005I\u0011\u0001:\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011qi\u001d\u0005\biB\f\t\u00111\u0001n\u0003\rAH%\r\u0005\bm\u0002\t\t\u0011\"\u0011x\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001=\u0011\u0007edx)D\u0001{\u0015\tY\b$\u0001\u0006d_2dWm\u0019;j_:L!! >\u0003\u0011%#XM]1u_JD\u0001b \u0001\u0002\u0002\u0013\u0005\u0011\u0011A\u0001\tG\u0006tW)];bYR!\u00111AA\u0005!\r9\u0012QA\u0005\u0004\u0003\u000fA\"a\u0002\"p_2,\u0017M\u001c\u0005\biz\f\t\u00111\u0001H\u0011%\ti\u0001AA\u0001\n\u0003\ny!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0007\t\t\u0002\u0003\u0005u\u0003\u0017\t\t\u00111\u0001HQ-\u0001\u0011QCA\u000e\u0003;\t\t#a\t\u0011\u0007\t\n9\"C\u0002\u0002\u001a\u0011\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002 \u0005\t\tb\u0018$V\u001d\u000e{\u0006\u0006_7mY\u0001B\b/\u0019;iS\u0001j\u0003EU3ukJt7\u000fI1oA%tG/Z4fe\u00022\u0018\r\\;fY\u0001z'\u000f\t;iK\u00022\u0018\r\\;fAi,'o\u001c\u0011jM\u0002rw\u000eI7bi\u000eD\u0007%[:!M>,h\u000e\u001a\u0017!_J\u0004\u0013\rI7bi\u000eD\u0007%[:!M>,h\u000e\u001a\u0011ckR\u0004C\u000f[3!m\u0006dW/\u001a\u0011jg\u0002rwN\\\u0017ok6,'/[2/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAA\u0013\u0003aS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001fb}q\u0012g(\r\u001f0Ezb$M\u0010\u001a=_\ttDhL1?O1\u0002se];nQ\u0005|#-K\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\b\u0013\u0005%\"!!A\t\u0002\u0005-\u0012\u0001\u0003-QCRD\u0017J\u001c;\u0011\u0007M\tiC\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u0018'\u0015\ti#!\r\u001d!\u001d\t\u0019$!\u000f\"C9j!!!\u000e\u000b\u0007\u0005]\u0002$A\u0004sk:$\u0018.\\3\n\t\u0005m\u0012Q\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002\u0017\u0002.\u0011\u0005\u0011q\b\u000b\u0003\u0003WA!\"a\u0011\u0002.\u0005\u0005IQIA#\u0003!!xn\u0015;sS:<G#A2\t\u0015\u0005%\u0013QFA\u0001\n\u0003\u000bY%A\u0003baBd\u0017\u0010F\u0003/\u0003\u001b\ny\u0005\u0003\u0004\u0004\u0003\u000f\u0002\r!\t\u0005\u0007Q\u0005\u001d\u0003\u0019A\u0011\t\u0015\u0005M\u0013QFA\u0001\n\u0003\u000b)&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u00131\r\t\u0006/\u0005e\u0013QL\u0005\u0004\u00037B\"AB(qi&|g\u000eE\u0003\u0018\u0003?\n\u0013%C\u0002\u0002ba\u0011a\u0001V;qY\u0016\u0014\u0004\"CA3\u0003#\n\t\u00111\u0001/\u0003\rAH\u0005\r\u0005\u000b\u0003S\ni#!A\u0005\n\u0005-\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001c\u0011\u0007\u0011\fy'C\u0002\u0002r\u0015\u0014aa\u00142kK\u000e$\b")
public class XPathInt
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Function1<Tuple2<Expression, Expression>, XPathInt> tupled() {
        return XPathInt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathInt>> curried() {
        return XPathInt$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_int";
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToInteger((int)ret.intValue());
    }

    public XPathInt copy(Expression xml, Expression path) {
        return new XPathInt(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathInt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.xml();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathInt)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathInt xPathInt = (XPathInt)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathInt.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathInt.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathInt.canEqual(this)) return false;
        return true;
    }

    public XPathInt(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

