/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UTF8String;
import org.apache.spark.unsafe.PlatformDependent;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArraySeq;

public final class UnsafeRow
implements MutableRow {
    private Object baseObject;
    private long baseOffset;
    private int numFields;
    private int bitSetWidthInBytes;
    @Nullable
    private StructType schema;
    public static final Set<DataType> settableFieldTypes = Collections.unmodifiableSet(new HashSet<DataType>(Arrays.asList(DataTypes.NullType, DataTypes.BooleanType, DataTypes.ByteType, DataTypes.ShortType, DataTypes.IntegerType, DataTypes.LongType, DataTypes.FloatType, DataTypes.DoubleType)));
    public static final Set<DataType> readableFieldTypes;

    Object getBaseObject() {
        return this.baseObject;
    }

    long getBaseOffset() {
        return this.baseOffset;
    }

    private long getFieldOffset(int ordinal) {
        return this.baseOffset + (long)this.bitSetWidthInBytes + (long)ordinal * 8L;
    }

    public static int calculateBitSetWidthInBytes(int numFields) {
        return (numFields / 64 + (numFields % 64 == 0 ? 0 : 1)) * 8;
    }

    public void pointTo(Object baseObject, long baseOffset, int numFields, @Nullable StructType schema) {
        assert (numFields >= 0) : "numFields should >= 0";
        assert (schema == null || schema.fields().length == numFields);
        this.bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(numFields);
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.numFields = numFields;
        this.schema = schema;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numFields) : "index (" + index + ") should < " + this.numFields;
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.set((Object)this.baseObject, (long)this.baseOffset, (int)i);
        PlatformDependent.UNSAFE.putLong((Object)this.baseObject, (long)this.getFieldOffset(i), (long)0L);
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.unset((Object)this.baseObject, (long)this.baseOffset, (int)i);
    }

    @Override
    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putInt((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (int)value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putDouble((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (double)value);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putBoolean((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (boolean)value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putShort((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (short)value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putByte((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (byte)value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        PlatformDependent.UNSAFE.putFloat((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (float)value);
    }

    @Override
    public void setString(int ordinal, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.numFields;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    @Override
    public Object apply(int i) {
        return this.get(i);
    }

    @Override
    public Object get(int i) {
        this.assertIndexIsValid(i);
        assert (this.schema != null) : "Schema must be defined when calling generic get() method";
        DataType dataType2 = this.schema.fields()[i].dataType();
        if (this.isNullAt(i)) {
            return null;
        }
        if (dataType2 == DataTypes.StringType) {
            return this.getUTF8String(i);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNullAt(int i) {
        this.assertIndexIsValid(i);
        return BitSetMethods.isSet((Object)this.baseObject, (long)this.baseOffset, (int)i);
    }

    @Override
    public boolean getBoolean(int i) {
        this.assertIndexIsValid(i);
        return PlatformDependent.UNSAFE.getBoolean((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public byte getByte(int i) {
        this.assertIndexIsValid(i);
        return PlatformDependent.UNSAFE.getByte((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public short getShort(int i) {
        this.assertIndexIsValid(i);
        return PlatformDependent.UNSAFE.getShort((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public int getInt(int i) {
        this.assertIndexIsValid(i);
        return PlatformDependent.UNSAFE.getInt((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public long getLong(int i) {
        this.assertIndexIsValid(i);
        return PlatformDependent.UNSAFE.getLong((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public float getFloat(int i) {
        this.assertIndexIsValid(i);
        if (this.isNullAt(i)) {
            return Float.NaN;
        }
        return PlatformDependent.UNSAFE.getFloat((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    @Override
    public double getDouble(int i) {
        this.assertIndexIsValid(i);
        if (this.isNullAt(i)) {
            return Double.NaN;
        }
        return PlatformDependent.UNSAFE.getDouble((Object)this.baseObject, (long)this.getFieldOffset(i));
    }

    public UTF8String getUTF8String(int i) {
        this.assertIndexIsValid(i);
        UTF8String str = new UTF8String();
        long offsetToStringSize = this.getLong(i);
        int stringSizeInBytes = (int)PlatformDependent.UNSAFE.getLong((Object)this.baseObject, (long)(this.baseOffset + offsetToStringSize));
        byte[] strBytes = new byte[stringSizeInBytes];
        PlatformDependent.copyMemory((Object)this.baseObject, (long)(this.baseOffset + offsetToStringSize + 8L), (Object)strBytes, (long)PlatformDependent.BYTE_ARRAY_OFFSET, (long)stringSizeInBytes);
        str.set(strBytes);
        return str;
    }

    @Override
    public String getString(int i) {
        return this.getUTF8String(i).toString();
    }

    @Override
    public BigDecimal getDecimal(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Seq<T> getSeq(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> getList(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> Map<K, V> getMap(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> scala.collection.immutable.Map<String, T> getValuesMap(Seq<String> fieldNames2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> java.util.Map<K, V> getJavaMap(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row getStruct(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAs(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getAs(String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int fieldIndex(String name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean anyNull() {
        return BitSetMethods.anySet((Object)this.baseObject, (long)this.baseOffset, (long)this.bitSetWidthInBytes);
    }

    @Override
    public Seq<Object> toSeq() {
        ArraySeq values = new ArraySeq(this.numFields);
        for (int fieldNumber = 0; fieldNumber < this.numFields; ++fieldNumber) {
            values.update(fieldNumber, this.get(fieldNumber));
        }
        return values;
    }

    @Override
    public String toString() {
        return this.mkString("[", ",", "]");
    }

    @Override
    public String mkString() {
        return this.toSeq().mkString();
    }

    @Override
    public String mkString(String sep) {
        return this.toSeq().mkString(sep);
    }

    @Override
    public String mkString(String start2, String sep, String end) {
        return this.toSeq().mkString(start2, sep, end);
    }

    static {
        HashSet<DataType> _readableFieldTypes = new HashSet<DataType>(Arrays.asList(DataTypes.StringType));
        _readableFieldTypes.addAll(settableFieldTypes);
        readableFieldTypes = Collections.unmodifiableSet(_readableFieldTypes);
    }
}

