/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.unsafe.Platform;

public class BufferHolder {
    public byte[] buffer;
    public int cursor = Platform.BYTE_ARRAY_OFFSET;

    public BufferHolder() {
        this(64);
    }

    public BufferHolder(int size) {
        this.buffer = new byte[size];
    }

    public void grow(int neededSize, UnsafeRow row) {
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            byte[] tmp = new byte[length * 2];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
            if (row != null) {
                row.pointTo(this.buffer, length * 2);
            }
        }
    }

    public void grow(int neededSize) {
        this.grow(neededSize, null);
    }

    public void reset() {
        this.cursor = Platform.BYTE_ARRAY_OFFSET;
    }

    public void resetTo(int offset) {
        assert (offset <= this.buffer.length);
        this.cursor = Platform.BYTE_ARRAY_OFFSET + offset;
    }

    public int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }
}

