/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.JsonPathParser$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Key$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Subscript$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Wildcard$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$FlattenStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$QuotedStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$RawStyle$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", extended="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u0001\u0003\u0001>\u0011QbR3u\u0015N|gn\u00142kK\u000e$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001BcF\u000f$!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\tQ\"!A\u0004d_\u0012,w-\u001a8\n\u0005qI\"aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0004J\u0005\u0003K}\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\n\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u0005UN|g.F\u0001*!\t\t\"&\u0003\u0002,\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u00115\u0002!\u0011#Q\u0001\n%\nQA[:p]\u0002B\u0001b\f\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u0005a\u0006$\b\u000e\u0003\u00052\u0001\tE\t\u0015!\u0003*\u0003\u0015\u0001\u0018\r\u001e5!\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0019QGN\u001c\u0011\u0005E\u0001\u0001\"B\u00143\u0001\u0004I\u0003\"B\u00183\u0001\u0004I\u0003\"B\u001d\u0001\t\u0003B\u0013\u0001\u00027fMRDQa\u000f\u0001\u0005B!\nQA]5hQRDQ!\u0010\u0001\u0005By\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005y\u0004c\u0001!I\u0017:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005\u001d{\u0012a\u00029bG.\fw-Z\u0005\u0003\u0013*\u00131aU3r\u0015\t9u\u0004\u0005\u0002M\u001f6\tQJ\u0003\u0002O\r\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\t\t\u0006$\u0018\rV=qK\")!\u000b\u0001C!'\u0006AA-\u0019;b)f\u0004X-F\u0001L\u0011\u0015)\u0006\u0001\"\u0011W\u0003!qW\u000f\u001c7bE2,W#A,\u0011\u0005yA\u0016BA- \u0005\u001d\u0011un\u001c7fC:DQa\u0017\u0001\u0005Bq\u000b!\u0002\u001d:fiRLh*Y7f+\u0005i\u0006C\u00010b\u001d\tqr,\u0003\u0002a?\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001w\u0004\u0003\u0005f\u0001!\u0015\r\u0011\"\u0003g\u0003)\u0001\u0018M]:fIB\u000bG\u000f[\u000b\u0002OB\u0019a\u0004\u001b6\n\u0005%|\"AB(qi&|g\u000eE\u0002AW6L!\u0001\u001c&\u0003\t1K7\u000f\u001e\t\u0003#9L!a\u001c\u0002\u0003\u001fA\u000bG\u000f[%ogR\u0014Xo\u0019;j_:D\u0001\"\u001d\u0001\t\u0002\u0003\u0006KaZ\u0001\fa\u0006\u00148/\u001a3QCRD\u0007\u0005\u000b\u0002qgB\u0011a\u0004^\u0005\u0003k~\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b]\u0004A\u0011\t=\u0002\t\u00154\u0018\r\u001c\u000b\u0003sr\u0004\"A\b>\n\u0005m|\"aA!os\"9QP\u001eI\u0001\u0002\u0004q\u0018!B5oaV$\bcA@\u0002\u00025\tA!C\u0002\u0002\u0004\u0011\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0011!\u00039beN,\u0007+\u0019;i)\r9\u00171\u0002\u0005\b_\u0005\u0015\u0001\u0019AA\u0007!\u0011\ty!a\u0006\u000e\u0005\u0005E!b\u0001(\u0002\u0014)\u0019\u0011Q\u0003\u0005\u0002\rUt7/\u00194f\u0013\u0011\tI\"!\u0005\u0003\u0015U#f\tO*ue&tw\rC\u0004\u0002\u001e\u0001!I!a\b\u0002\u0015\u0005\u0014(/Y=J]\u0012,\u0007\u0010\u0006\u0004\u0002\"\u00055\u0012\u0011\n\t\u0007=\u0005\r\u0012qE,\n\u0007\u0005\u0015rDA\u0005Gk:\u001cG/[8ocA\u0019a$!\u000b\n\u0007\u0005-rD\u0001\u0003M_:<\u0007\u0002CA\u0018\u00037\u0001\r!!\r\u0002\u0003A\u0004B!a\r\u0002F5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0003d_J,'\u0002BA\u001e\u0003{\tqA[1dWN|gN\u0003\u0003\u0002@\u0005\u0005\u0013!\u00034bgR,'\u000f_7m\u0015\t\t\u0019%A\u0002d_6LA!a\u0012\u00026\tQ!j]8o!\u0006\u00148/\u001a:\t\u0011\u0005-\u00131\u0004a\u0001\u0003\u001b\n\u0011A\u001a\t\u0005=\u0005=s+C\u0002\u0002R}\u0011\u0011BR;oGRLwN\u001c\u0019\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005aQM^1mk\u0006$X\rU1uQRIq+!\u0017\u0002\\\u0005\u0015\u0014q\u000e\u0005\t\u0003_\t\u0019\u00061\u0001\u00022!A\u0011QLA*\u0001\u0004\ty&A\u0001h!\u0011\t\u0019$!\u0019\n\t\u0005\r\u0014Q\u0007\u0002\u000e\u0015N|gnR3oKJ\fGo\u001c:\t\u0011\u0005\u001d\u00141\u000ba\u0001\u0003S\nQa\u001d;zY\u0016\u00042!EA6\u0013\r\tiG\u0001\u0002\u000b/JLG/Z*us2,\u0007BB\u0018\u0002T\u0001\u0007!\u000eC\u0005\u0002t\u0001\t\t\u0011\"\u0001\u0002v\u0005!1m\u001c9z)\u0015)\u0014qOA=\u0011!9\u0013\u0011\u000fI\u0001\u0002\u0004I\u0003\u0002C\u0018\u0002rA\u0005\t\u0019A\u0015\t\u0013\u0005u\u0004!%A\u0005\u0002\u0005}\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003S3!KABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAH?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAL\u0001E\u0005I\u0011AA@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a'\u0001\u0003\u0003%\t%!(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\t1\fgn\u001a\u0006\u0003\u0003S\u000bAA[1wC&\u0019!-a)\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAZ!\rq\u0012QW\u0005\u0004\u0003o{\"aA%oi\"I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0011QX\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI\u0018q\u0018\u0005\u000b\u0003\u0003\fI,!AA\u0002\u0005M\u0016a\u0001=%c!I\u0011Q\u0019\u0001\u0002\u0002\u0013\u0005\u0013qY\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001a\t\u0006\u0003\u0017\f\t._\u0007\u0003\u0003\u001bT1!a4 \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\fiM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t9\u000eAA\u0001\n\u0003\tI.\u0001\u0005dC:,\u0015/^1m)\r9\u00161\u001c\u0005\n\u0003\u0003\f).!AA\u0002eD\u0011\"a8\u0001\u0003\u0003%\t%!9\u0002\r\u0015\fX/\u00197t)\r9\u00161\u001d\u0005\n\u0003\u0003\fi.!AA\u0002eD3\u0002AAt\u0003[\fy/a=\u0002vB\u0019\u0011#!;\n\u0007\u0005-(AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005E\u0018\u0001P0G+:\u001bu\f\u000b6t_:|F\u000f\u001f;-AA\fG\u000f[\u0015![\u0001*\u0005\u0010\u001e:bGR\u001c\b%\u0019\u0011kg>t\u0007e\u001c2kK\u000e$\bE\u001a:p[\u0002\u0002\u0007/\u0019;iA:\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0003o\fQI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\n'E\u000f\u0012cEu<C\u0006I\u0014%]\u0005<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011c\u0015\u0001\u0002s!CA~\u0005\u0005\u0005\t\u0012AA\u007f\u000359U\r\u001e&t_:|%M[3diB\u0019\u0011#a@\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u0003\u0019R!a@\u0003\u0004\r\u0002rA!\u0002\u0003\f%JS'\u0004\u0002\u0003\b)\u0019!\u0011B\u0010\u0002\u000fI,h\u000e^5nK&!!Q\u0002B\u0004\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bg\u0005}H\u0011\u0001B\t)\t\ti\u0010\u0003\u0006\u0003\u0016\u0005}\u0018\u0011!C#\u0005/\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?C!Ba\u0007\u0002\u0000\u0006\u0005I\u0011\u0011B\u000f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)$q\u0004B\u0011\u0011\u00199#\u0011\u0004a\u0001S!1qF!\u0007A\u0002%B!B!\n\u0002\u0000\u0006\u0005I\u0011\u0011B\u0014\u0003\u001d)h.\u00199qYf$BA!\u000b\u00032A!a\u0004\u001bB\u0016!\u0015q\"QF\u0015*\u0013\r\u0011yc\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tM\"1EA\u0001\u0002\u0004)\u0014a\u0001=%a!Q!qGA\u0000\u0003\u0003%IA!\u000f\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005w\u0001B!!)\u0003>%!!qHAR\u0005\u0019y%M[3di\u0002")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
Serializable {
    private final Expression json;
    private final Expression path;
    private transient Option<List<PathInstruction>> parsedPath;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject getJsonObject) {
        return GetJsonObject$.MODULE$.unapply(getJsonObject);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    private Option parsedPath$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.parsedPath = this.parsePath((UTF8String)this.path().eval(this.path().eval$default$1()));
                this.bitmap$trans$0 = true;
            }
            return this.parsedPath;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private Option<List<PathInstruction>> parsedPath() {
        return this.bitmap$trans$0 ? this.parsedPath : this.parsedPath$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object eval(InternalRow input) {
        UTF8String jsonStr = (UTF8String)this.json().eval(input);
        if (jsonStr == null) {
            return null;
        }
        Option<List<PathInstruction>> parsed = this.path().foldable() ? this.parsedPath() : this.parsePath((UTF8String)this.path().eval(input));
        if (!parsed.isDefined()) return null;
        try {
            Object object = Utils$.MODULE$.tryWithResource((Function0)new Serializable(this, jsonStr){
                public static final long serialVersionUID = 0L;
                private final UTF8String jsonStr$1;

                public final JsonParser apply() {
                    return SharedFactory$.MODULE$.jsonFactory().createParser(this.jsonStr$1.getBytes());
                }
                {
                    this.jsonStr$1 = jsonStr$1;
                }
            }, (Function1)new Serializable(this, parsed){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GetJsonObject $outer;
                public final Option parsed$1;

                public final Object apply(JsonParser parser) {
                    ByteArrayOutputStream output2 = new ByteArrayOutputStream();
                    boolean matched = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((Function0)new Serializable(this, output2){
                        public static final long serialVersionUID = 0L;
                        private final ByteArrayOutputStream output$1;

                        public final JsonGenerator apply() {
                            return SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)this.output$1, JsonEncoding.UTF8);
                        }
                        {
                            this.output$1 = output$1;
                        }
                    }, (Function1)new Serializable(this, parser){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$eval$2 $outer;
                        private final JsonParser parser$2;

                        public final boolean apply(JsonGenerator generator) {
                            this.parser$2.nextToken();
                            return this.$outer.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(this.parser$2, generator, WriteStyle$RawStyle$.MODULE$, (List<PathInstruction>)((List)this.$outer.parsed$1.get()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.parser$2 = parser$2;
                        }
                    }));
                    return matched ? UTF8String.fromBytes((byte[])output2.toByteArray()) : null;
                }

                public /* synthetic */ GetJsonObject org$apache$spark$sql$catalyst$expressions$GetJsonObject$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parsed$1 = parsed$1;
                }
            });
            return object;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    private Option<List<PathInstruction>> parsePath(UTF8String path) {
        return path == null ? None$.MODULE$ : JsonPathParser$.MODULE$.parse(path.toString());
    }

    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$GetJsonObject$$arrayIndex(JsonParser p, Function0<Object> f) {
        return new Serializable(this, p, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GetJsonObject $outer;
            private final JsonParser p$2;
            private final Function0 f$1;

            public final boolean apply(long x0$1) {
                return this.apply$mcZJ$sp(x0$1);
            }

            public boolean apply$mcZJ$sp(long x0$1) {
                long l;
                block8: {
                    boolean bl;
                    block6: {
                        block7: {
                            l = x0$1;
                            JsonToken jsonToken = this.p$2.getCurrentToken();
                            JsonToken jsonToken2 = JsonToken.END_ARRAY;
                            if (jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null) break block7;
                            bl = false;
                            break block6;
                        }
                        if (0L == l) {
                            boolean dirty = this.f$1.apply$mcZ$sp();
                            while (true) {
                                JsonToken jsonToken = this.p$2.nextToken();
                                JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                if (!(jsonToken != null ? !jsonToken.equals(jsonToken3) : jsonToken3 != null)) {
                                    bl = dirty;
                                    break block6;
                                }
                                this.p$2.skipChildren();
                            }
                        }
                        if (l <= 0L) break block8;
                        this.p$2.skipChildren();
                        this.p$2.nextToken();
                        bl = this.$outer.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$arrayIndex(this.p$2, (Function0<Object>)this.f$1).apply$mcZJ$sp(l - 1L);
                    }
                    return bl;
                }
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$2 = p$2;
                this.f$1 = f$1;
            }
        };
    }

    public boolean org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(JsonParser p, JsonGenerator g, WriteStyle style, List<PathInstruction> path) {
        boolean bl;
        block53: {
            while (true) {
                Tuple2 tuple2;
                block54: {
                    WriteStyle writeStyle;
                    block57: {
                        WriteStyle writeStyle2;
                        List xs;
                        block56: {
                            block55: {
                                List list;
                                if ((tuple2 = new Tuple2((Object)p.getCurrentToken(), path)) != null) {
                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                    List list2 = (List)tuple2._2();
                                    if (JsonToken.VALUE_STRING.equals(jsonToken) && Nil$.MODULE$.equals(list2)) {
                                        WriteStyle writeStyle3 = style;
                                        WriteStyle$RawStyle$ writeStyle$RawStyle$ = WriteStyle$RawStyle$.MODULE$;
                                        if (!(writeStyle3 != null ? !writeStyle3.equals(writeStyle$RawStyle$) : writeStyle$RawStyle$ != null)) {
                                            if (p.hasTextCharacters()) {
                                                g.writeRaw(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                                            } else {
                                                g.writeRaw(p.getText());
                                            }
                                            bl = true;
                                            break block53;
                                        }
                                    }
                                }
                                if (tuple2 != null) {
                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                    List list3 = (List)tuple2._2();
                                    if (JsonToken.START_ARRAY.equals(jsonToken) && Nil$.MODULE$.equals(list3)) {
                                        WriteStyle writeStyle4 = style;
                                        WriteStyle$FlattenStyle$ writeStyle$FlattenStyle$ = WriteStyle$FlattenStyle$.MODULE$;
                                        if (!(writeStyle4 != null ? !writeStyle4.equals(writeStyle$FlattenStyle$) : writeStyle$FlattenStyle$ != null)) {
                                            boolean dirty = false;
                                            while (true) {
                                                JsonToken jsonToken2 = p.nextToken();
                                                JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                                if (!(jsonToken2 != null ? !jsonToken2.equals(jsonToken3) : jsonToken3 != null)) {
                                                    bl = dirty;
                                                    break block53;
                                                }
                                                var13_87 |= this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(p, g, style, (List<PathInstruction>)Nil$.MODULE$);
                                            }
                                        }
                                    }
                                }
                                if (tuple2 != null && Nil$.MODULE$.equals(list = (List)tuple2._2())) {
                                    g.copyCurrentStructure(p);
                                    bl = true;
                                    break block53;
                                }
                                if (tuple2 != null) {
                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                    List list4 = (List)tuple2._2();
                                    if (JsonToken.START_OBJECT.equals(jsonToken) && list4 instanceof .colon.colon) {
                                        .colon.colon colon2 = (.colon.colon)list4;
                                        PathInstruction pathInstruction = (PathInstruction)colon2.head();
                                        List xs2 = colon2.tl$1();
                                        if (PathInstruction$Key$.MODULE$.equals(pathInstruction)) {
                                            boolean dirty = false;
                                            while (true) {
                                                JsonParser jsonParser;
                                                boolean bl2;
                                                JsonToken jsonToken4 = p.nextToken();
                                                JsonToken jsonToken5 = JsonToken.END_OBJECT;
                                                if (!(jsonToken4 != null ? !jsonToken4.equals(jsonToken5) : jsonToken5 != null)) {
                                                    bl = dirty;
                                                    break block53;
                                                }
                                                if (bl2) {
                                                    jsonParser = p.skipChildren();
                                                    continue;
                                                }
                                                bl2 = this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(p, g, style, (List<PathInstruction>)xs2);
                                                jsonParser = BoxedUnit.UNIT;
                                            }
                                        }
                                    }
                                }
                                if (tuple2 != null) {
                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                    List list5 = (List)tuple2._2();
                                    if (JsonToken.START_ARRAY.equals(jsonToken) && list5 instanceof .colon.colon) {
                                        .colon.colon colon3 = (.colon.colon)list5;
                                        PathInstruction pathInstruction = (PathInstruction)colon3.head();
                                        List list6 = colon3.tl$1();
                                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list6 instanceof .colon.colon) {
                                            .colon.colon colon4 = (.colon.colon)list6;
                                            PathInstruction pathInstruction2 = (PathInstruction)colon4.head();
                                            List list7 = colon4.tl$1();
                                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction2) && list7 instanceof .colon.colon) {
                                                .colon.colon colon5 = (.colon.colon)list7;
                                                PathInstruction pathInstruction3 = (PathInstruction)colon5.head();
                                                List list8 = colon5.tl$1();
                                                if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction3) && list8 instanceof .colon.colon) {
                                                    .colon.colon colon6 = (.colon.colon)list8;
                                                    PathInstruction pathInstruction4 = (PathInstruction)colon6.head();
                                                    List xs3 = colon6.tl$1();
                                                    if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction4)) {
                                                        boolean dirty = false;
                                                        g.writeStartArray();
                                                        while (true) {
                                                            JsonToken jsonToken6 = p.nextToken();
                                                            JsonToken jsonToken7 = JsonToken.END_ARRAY;
                                                            if (!(jsonToken6 != null ? !jsonToken6.equals(jsonToken7) : jsonToken7 != null)) {
                                                                g.writeEndArray();
                                                                bl = dirty;
                                                                break block53;
                                                            }
                                                            var37_91 |= this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(p, g, WriteStyle$FlattenStyle$.MODULE$, (List<PathInstruction>)xs3);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if (tuple2 == null) break block54;
                                JsonToken jsonToken = (JsonToken)tuple2._1();
                                List list9 = (List)tuple2._2();
                                if (!JsonToken.START_ARRAY.equals(jsonToken) || !(list9 instanceof .colon.colon)) break block54;
                                .colon.colon colon7 = (.colon.colon)list9;
                                PathInstruction pathInstruction = (PathInstruction)colon7.head();
                                List list10 = colon7.tl$1();
                                if (!PathInstruction$Subscript$.MODULE$.equals(pathInstruction) || !(list10 instanceof .colon.colon)) break block54;
                                .colon.colon colon8 = (.colon.colon)list10;
                                PathInstruction pathInstruction5 = (PathInstruction)colon8.head();
                                xs = colon8.tl$1();
                                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction5)) break block54;
                                WriteStyle writeStyle5 = style;
                                WriteStyle$QuotedStyle$ writeStyle$QuotedStyle$ = WriteStyle$QuotedStyle$.MODULE$;
                                if (!(writeStyle5 == null ? writeStyle$QuotedStyle$ != null : !writeStyle5.equals(writeStyle$QuotedStyle$))) break block54;
                                writeStyle = style;
                                if (!WriteStyle$RawStyle$.MODULE$.equals(writeStyle)) break block55;
                                writeStyle2 = WriteStyle$QuotedStyle$.MODULE$;
                                break block56;
                            }
                            if (!WriteStyle$FlattenStyle$.MODULE$.equals(writeStyle)) break block57;
                            writeStyle2 = WriteStyle$FlattenStyle$.MODULE$;
                        }
                        WriteStyle$QuotedStyle$ nextStyle = writeStyle2;
                        StringWriter buffer = new StringWriter();
                        IntRef dirty = IntRef.create((int)0);
                        Utils$.MODULE$.tryWithResource((Function0)new Serializable(this, buffer){
                            public static final long serialVersionUID = 0L;
                            private final StringWriter buffer$1;

                            public final JsonGenerator apply() {
                                return SharedFactory$.MODULE$.jsonFactory().createGenerator((Writer)this.buffer$1);
                            }
                            {
                                this.buffer$1 = buffer$1;
                            }
                        }, (Function1)new Serializable(this, p, xs, nextStyle, dirty){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ GetJsonObject $outer;
                            private final JsonParser p$1;
                            private final List xs$1;
                            private final Product nextStyle$1;
                            private final IntRef dirty$1;

                            public final void apply(JsonGenerator flattenGenerator) {
                                flattenGenerator.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken = this.p$1.nextToken();
                                    JsonToken jsonToken2 = JsonToken.END_ARRAY;
                                    if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                                        flattenGenerator.writeEndArray();
                                        return;
                                    }
                                    this.dirty$1.elem = this.dirty$1.elem + (this.$outer.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(this.p$1, flattenGenerator, (WriteStyle)this.nextStyle$1, (List<PathInstruction>)this.xs$1) ? 1 : 0);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.p$1 = p$1;
                                this.xs$1 = xs$1;
                                this.nextStyle$1 = nextStyle$1;
                                this.dirty$1 = dirty$1;
                            }
                        });
                        StringBuffer buf = buffer.getBuffer();
                        if (dirty.elem > 1) {
                            g.writeRawValue(buf.toString());
                        } else if (dirty.elem == 1) {
                            g.writeRawValue(buf.substring(1, buf.length() - 1));
                        }
                        bl = dirty.elem > 0;
                        break block53;
                    }
                    if (WriteStyle$QuotedStyle$.MODULE$.equals(writeStyle)) {
                        throw new IllegalStateException();
                    }
                    throw new MatchError((Object)writeStyle);
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon9.head();
                        List list11 = colon9.tl$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list11 instanceof .colon.colon) {
                            .colon.colon colon10 = (.colon.colon)list11;
                            PathInstruction pathInstruction6 = (PathInstruction)colon10.head();
                            List xs = colon10.tl$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction6)) {
                                boolean dirty = false;
                                g.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken8 = p.nextToken();
                                    JsonToken jsonToken9 = JsonToken.END_ARRAY;
                                    if (!(jsonToken8 != null ? !jsonToken8.equals(jsonToken9) : jsonToken9 != null)) {
                                        g.writeEndArray();
                                        bl = dirty;
                                        break block53;
                                    }
                                    var62_99 |= this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)xs);
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon11.head();
                        List list12 = colon11.tl$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list12 instanceof .colon.colon) {
                            .colon.colon colon12 = (.colon.colon)list12;
                            PathInstruction pathInstruction7 = (PathInstruction)colon12.head();
                            List xs = colon12.tl$1();
                            if (pathInstruction7 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction7;
                                long idx = index.index();
                                if (xs instanceof .colon.colon) {
                                    .colon.colon colon13;
                                    PathInstruction pathInstruction8;
                                    .colon.colon colon14 = (.colon.colon)xs;
                                    PathInstruction pathInstruction9 = (PathInstruction)colon14.head();
                                    List list13 = colon14.tl$1();
                                    if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction9) && list13 instanceof .colon.colon && PathInstruction$Wildcard$.MODULE$.equals(pathInstruction8 = (PathInstruction)(colon13 = (.colon.colon)list13).head())) {
                                        p.nextToken();
                                        bl = this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$arrayIndex(p, (Function0<Object>)new Serializable(this, p, g, colon14){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ GetJsonObject $outer;
                                            private final JsonParser p$1;
                                            private final JsonGenerator g$1;
                                            private final .colon.colon x47$1;

                                            public final boolean apply() {
                                                return this.apply$mcZ$sp();
                                            }

                                            public boolean apply$mcZ$sp() {
                                                return this.$outer.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(this.p$1, this.g$1, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)this.x47$1);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.p$1 = p$1;
                                                this.g$1 = g$1;
                                                this.x47$1 = x47$1;
                                            }
                                        }).apply$mcZJ$sp(idx);
                                        break block53;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon15 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon15.head();
                        List list14 = colon15.tl$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list14 instanceof .colon.colon) {
                            .colon.colon colon16 = (.colon.colon)list14;
                            PathInstruction pathInstruction10 = (PathInstruction)colon16.head();
                            List xs = colon16.tl$1();
                            if (pathInstruction10 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction10;
                                long idx = index.index();
                                p.nextToken();
                                bl = this.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$arrayIndex(p, (Function0<Object>)new Serializable(this, p, g, style, xs){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ GetJsonObject $outer;
                                    private final JsonParser p$1;
                                    private final JsonGenerator g$1;
                                    private final WriteStyle style$1;
                                    private final List xs$2;

                                    public final boolean apply() {
                                        return this.apply$mcZ$sp();
                                    }

                                    public boolean apply$mcZ$sp() {
                                        return this.$outer.org$apache$spark$sql$catalyst$expressions$GetJsonObject$$evaluatePath(this.p$1, this.g$1, this.style$1, (List<PathInstruction>)this.xs$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.p$1 = p$1;
                                        this.g$1 = g$1;
                                        this.style$1 = style$1;
                                        this.xs$2 = xs$2;
                                    }
                                }).apply$mcZJ$sp(idx);
                                break block53;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list = (List)tuple2._2();
                    if (JsonToken.FIELD_NAME.equals(jsonToken) && list instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list;
                        PathInstruction pathInstruction = (PathInstruction)colon17.head();
                        List xs = colon17.tl$1();
                        if (pathInstruction instanceof PathInstruction.Named) {
                            PathInstruction.Named named2 = (PathInstruction.Named)pathInstruction;
                            String name2 = named2.name();
                            String string = p.getCurrentName();
                            String string2 = name2;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JsonToken jsonToken10 = p.nextToken();
                                JsonToken jsonToken11 = JsonToken.VALUE_NULL;
                                if (!(jsonToken10 != null ? !jsonToken10.equals(jsonToken11) : jsonToken11 != null)) {
                                    bl = false;
                                    break block53;
                                }
                                path = xs;
                                continue;
                            }
                        }
                    }
                }
                if (tuple2 == null) break;
                JsonToken jsonToken = (JsonToken)tuple2._1();
                List list = (List)tuple2._2();
                if (!JsonToken.FIELD_NAME.equals(jsonToken) || !(list instanceof .colon.colon)) break;
                .colon.colon colon18 = (.colon.colon)list;
                PathInstruction pathInstruction = (PathInstruction)colon18.head();
                List xs = colon18.tl$1();
                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction)) break;
                p.nextToken();
                path = xs;
            }
            p.skipChildren();
            bl = false;
        }
        return bl;
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.path();
                break;
            }
            case 0: {
                expression = this.json();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes$class.$init$(this);
        CodegenFallback$class.$init$(this);
    }
}

