/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, relativeSD]) - Returns the estimated cardinality by HyperLogLog++.\n      `relativeSD` defines the maximum estimation error allowed.\n  ")
@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDA\u0002\u0019\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%a\"1!\r\u0001Q\u0001\nM\n\u0001\"\u001b3y'\"Lg\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B3\u0002\u0011]\u0004\u0016\r\u001a3j]\u001e\u0004\"a\u00064\n\u0005\u001dD\"\u0001\u0002'p]\u001eDA\"\u001b\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%[\"11\u000e\u0001Q\u0001\n-\nq!\u00197qQ\u0006l%\u0007\u0003\u0004n\u0001\u0001\u0006IaM\u0001\t]Vlwk\u001c:eg\")q\u000e\u0001C!a\u0006A1\r[5mIJ,g.F\u0001r!\r\u0011(P\t\b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA=\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0007M+\u0017O\u0003\u0002z1!)a\u0010\u0001C!\u007f\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015\u0001DA\u0004C_>dW-\u00198\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014!\tQ\u0001^=qKNLA!a\u0006\u0002\u0012\tAA)\u0019;b)f\u0004X\rC\u0004\u0002\u001c\u0001!\t%!\b\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002 A!!O_A\u0011!\u0011\ty!a\t\n\t\u0005\u0015\u0012\u0011\u0003\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016Dq!!\u000b\u0001\t\u0003\nY#A\bbO\u001e\u0014UO\u001a4feN\u001b\u0007.Z7b+\t\ti\u0003\u0005\u0003\u0002\u0010\u0005=\u0012\u0002BA\u0019\u0003#\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011%\t)\u0004\u0001b\u0001\n\u0003\n9$A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002:A!!O_A\u001e!\r\u0019\u0013QH\u0005\u0004\u0003\u007f!!AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016D\u0001\"a\u0011\u0001A\u0003%\u0011\u0011H\u0001\u0015C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm\u001d\u0011\t\u0013\u0005\u001d\u0003A1A\u0005B\u0005]\u0012\u0001G5oaV$\u0018iZ4Ck\u001a4WM]!uiJL'-\u001e;fg\"A\u00111\n\u0001!\u0002\u0013\tI$A\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0003bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u000bS:LG/[1mSj,G\u0003BA*\u00033\u00022aFA+\u0013\r\t9\u0006\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003\u0019\u0011WO\u001a4feB!\u0011qLA1\u001b\u00051\u0011bAA2\r\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t9\u0007\u0001C!\u0003S\na!\u001e9eCR,GCBA*\u0003W\ni\u0007\u0003\u0005\u0002\\\u0005\u0015\u0004\u0019AA/\u0011!\ty'!\u001aA\u0002\u0005u\u0013!B5oaV$\bbBA:\u0001\u0011\u0005\u0013QO\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0007\u0003'\n9(a\u001f\t\u0011\u0005e\u0014\u0011\u000fa\u0001\u0003;\nqAY;gM\u0016\u0014\u0018\u0007\u0003\u0005\u0002~\u0005E\u0004\u0019AA/\u0003\u001d\u0011WO\u001a4feJBq!!!\u0001\t\u0003\t\u0019)\u0001\u0007fgRLW.\u0019;f\u0005&\f7\u000fF\u0002,\u0003\u000bCq!a\"\u0002\u0000\u0001\u00071&A\u0001f\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bA!\u001a<bYR!\u0011qRAK!\r9\u0012\u0011S\u0005\u0004\u0003'C\"aA!os\"Q\u00111LAE!\u0003\u0005\r!!\u0018\t\r\u0005e\u0005\u0001\"\u0001+\u0003\u001d!(/^3Sg\u0012D\u0011\"!(\u0001\u0003\u0003%\t!a(\u0002\t\r|\u0007/\u001f\u000b\n\u007f\u0005\u0005\u00161UAS\u0003OC\u0001\u0002IAN!\u0003\u0005\rA\t\u0005\tS\u0005m\u0005\u0013!a\u0001W!A\u0011'a'\u0011\u0002\u0003\u00071\u0007\u0003\u0005:\u00037\u0003\n\u00111\u00014\u0011%\tY\u000bAI\u0001\n\u0003\ti+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=&f\u0001\u0012\u00022.\u0012\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%)hn\u00195fG.,GMC\u0002\u0002>b\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t-a.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002F\u0002\t\n\u0011\"\u0001\u0002H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAeU\rY\u0013\u0011\u0017\u0005\n\u0003\u001b\u0004\u0011\u0013!C\u0001\u0003\u001f\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002R*\u001a1'!-\t\u0013\u0005U\u0007!%A\u0005\u0002\u0005=\u0017AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\n\u00033\u0004\u0011\u0011!C!\u00037\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\fA\u0001\\1oO*\u0011\u0011q]\u0001\u0005U\u00064\u0018-C\u0002T\u0003CD\u0001\"!<\u0001\u0003\u0003%\tAM\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003c\u0004\u0011\u0011!C\u0001\u0003g\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0010\u0006U\b\"CA|\u0003_\f\t\u00111\u00014\u0003\rAH%\r\u0005\n\u0003w\u0004\u0011\u0011!C!\u0003{\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0004bA!\u0001\u0003\b\u0005=UB\u0001B\u0002\u0015\r\u0011)\u0001G\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0005\u0005\u0007\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005\u001b\u0001\u0011\u0011!C\u0001\u0005\u001f\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u0011\t\u0002\u0003\u0006\u0002x\n-\u0011\u0011!a\u0001\u0003\u001fC\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\u0002\r\u0015\fX/\u00197t)\u0011\t\tA!\u0007\t\u0015\u0005](1CA\u0001\u0002\u0004\ty\tK\u0004\u0001\u0005;\u0011\u0019C!\n\u0011\u0007\r\u0012y\"C\u0002\u0003\"\u0011\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003(\u0005\t\u0019D\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:\\Y\u0001\u0012X\r\\1uSZ,7\u000bR/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015\u001cH/[7bi\u0016$\u0007eY1sI&t\u0017\r\\5us\u0002\u0012\u0017\u0010\t%za\u0016\u0014Hj\\4M_\u001e\\3F\f\u0006!A\u0001\u0002\u0003\u0005\t1sK2\fG/\u001b<f'\u0012\u0003\u0007\u0005Z3gS:,7\u000f\t;iK\u0002j\u0017\r_5nk6\u0004Sm\u001d;j[\u0006$\u0018n\u001c8!KJ\u0014xN\u001d\u0011bY2|w/\u001a3/\u0015\u0001\u0002sa\u0002B\u0016\u0005!\u0005!QF\u0001\u0014\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\t\u0004'\t=bAB\u0001\u0003\u0011\u0003\u0011\tdE\u0003\u00030\tMB\u0004E\u0002\u0018\u0005kI1Aa\u000e\u0019\u0005\u0019\te.\u001f*fM\"9QHa\f\u0005\u0002\tmBC\u0001B\u0017\u0011%\u0011yDa\fC\u0002\u0013\u0005!'A\u0005X\u001fJ#ulU%[\u000b\"A!1\tB\u0018A\u0003%1'\u0001\u0006X\u001fJ#ulU%[\u000b\u0002B\u0011Ba\u0012\u00030\t\u0007I\u0011\u0001\u001a\u0002\u001bI+u)S*U\u000bJ{6+\u0013.F\u0011!\u0011YEa\f!\u0002\u0013\u0019\u0014A\u0004*F\u000f&\u001bF+\u0012*`'&SV\t\t\u0005\u000b\u0005\u001f\u0012yC1A\u0005\u0002\tE\u0013A\u0005*F\u000f&\u001bF+\u0012*`/>\u0013FiX'B'.+\u0012!\u001a\u0005\t\u0005+\u0012y\u0003)A\u0005K\u0006\u0019\"+R$J'R+%kX,P%\u0012{V*Q*LA!I!\u0011\fB\u0018\u0005\u0004%\tAM\u0001\u0013%\u0016;\u0015j\u0015+F%N{\u0006+\u0012*`/>\u0013F\t\u0003\u0005\u0003^\t=\u0002\u0015!\u00034\u0003M\u0011ViR%T)\u0016\u00136k\u0018)F%~;vJ\u0015#!\u0011%\u0011\tGa\fC\u0002\u0013\u0005!'A\u0001L\u0011!\u0011)Ga\f!\u0002\u0013\u0019\u0014AA&!\u0011)\u0011IGa\fC\u0002\u0013\u0005!1N\u0001\u000b)\"\u0013Vi\u0015%P\u0019\u0012\u001bVC\u0001B7!\u00119\"qN\u0016\n\u0007\tE\u0004DA\u0003BeJ\f\u0017\u0010C\u0005\u0003v\t=\u0002\u0015!\u0003\u0003n\u0005YA\u000b\u0013*F'\"{E\nR*!\u0011)\u0011IHa\fC\u0002\u0013\u0005!1P\u0001\u0012%\u0006;v,R*U\u00136\u000bE+R0E\u0003R\u000bUC\u0001B?!\u00159\"q\u000eB7\u0011%\u0011\tIa\f!\u0002\u0013\u0011i(\u0001\nS\u0003^{Vi\u0015+J\u001b\u0006#Vi\u0018#B)\u0006\u0003\u0003B\u0003BC\u0005_\u0011\r\u0011\"\u0001\u0003|\u0005I!)S!T?\u0012\u000bE+\u0011\u0005\n\u0005\u0013\u0013y\u0003)A\u0005\u0005{\n!BQ%B'~#\u0015\tV!!\u0011!\u0011iIa\f\u0005\n\t=\u0015!\u0006<bY&$\u0017\r^3E_V\u0014G.\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0004W\tE\u0005b\u0002BJ\u0005\u0017\u0003\rAI\u0001\u0004Kb\u0004\bB\u0003BL\u0005_\t\t\u0011\"!\u0003\u001a\u0006)\u0011\r\u001d9msRIqHa'\u0003\u001e\n}%\u0011\u0015\u0005\u0007A\tU\u0005\u0019\u0001\u0012\t\u0011%\u0012)\n%AA\u0002-B\u0001\"\rBK!\u0003\u0005\ra\r\u0005\ts\tU\u0005\u0013!a\u0001g!Q!Q\u0015B\u0018\u0003\u0003%\tIa*\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0016B[!\u00159\"1\u0016BX\u0013\r\u0011i\u000b\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f]\u0011\tLI\u00164g%\u0019!1\u0017\r\u0003\rQ+\b\u000f\\35\u0011%\u00119La)\u0002\u0002\u0003\u0007q(A\u0002yIAB!Ba/\u00030E\u0005I\u0011AAd\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B`\u0005_\t\n\u0011\"\u0001\u0002P\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003D\n=\u0012\u0013!C\u0001\u0003\u001f\fq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005\u000f\u0014y#%A\u0005\u0002\u0005\u001d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003L\n=\u0012\u0013!C\u0001\u0003\u001f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bh\u0005_\t\n\u0011\"\u0001\u0002P\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB!Ba5\u00030\u0005\u0005I\u0011\u0002Bk\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t]\u0007\u0003BAp\u00053LAAa7\u0002b\n1qJ\u00196fGR\u0004")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    private final double alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(HyperLogLogPlusPlus hyperLogLogPlusPlus) {
        return HyperLogLogPlusPlus$.MODULE$.unapply(hyperLogLogPlusPlus);
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyDataType$[]{AnyDataType$.MODULE$}));
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double d;
        double zInverse = 0.0;
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double E = this.alphaM2 / zInverse;
        if (V > 0.0) {
            double H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V);
            d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && H <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] || E <= 2.5 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? H : this.EBiasCorrected$1(E);
        } else {
            d = this.EBiasCorrected$1(E);
        }
        double estimate = d;
        return BoxesRunTime.boxToLong((long)Math.round(estimate));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(double E$1) {
        double d = E$1;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(int i) {
                String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MS[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                LongType$ x$11 = LongType$.MODULE$;
                boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$14 = AttributeReference$.MODULE$.apply$default$5(x$10, x$11, x$12, x$13);
                Option<String> x$15 = AttributeReference$.MODULE$.apply$default$6(x$10, x$11, x$12, x$13);
                Boolean x$16 = AttributeReference$.MODULE$.apply$default$7(x$10, x$11, x$12, x$13);
                return new AttributeReference(x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            }
        });
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(AttributeReference x$1) {
                return x$1.newInstance();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

