/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.ResolveInlineTables$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class ResolveInlineTables$
extends Rule<LogicalPlan> {
    public static final ResolveInlineTables$ MODULE$;

    static {
        new ResolveInlineTables$();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transformUp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                UnresolvedInlineTable unresolvedInlineTable;
                A1 A1 = x1;
                if (A1 instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)A1).expressionsResolved()) {
                    ResolveInlineTables$.MODULE$.validateInputDimension(unresolvedInlineTable);
                    ResolveInlineTables$.MODULE$.validateInputEvaluable(unresolvedInlineTable);
                    object = ResolveInlineTables$.MODULE$.convert(unresolvedInlineTable);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                UnresolvedInlineTable unresolvedInlineTable;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof UnresolvedInlineTable && (unresolvedInlineTable = (UnresolvedInlineTable)logicalPlan).expressionsResolved();
                return bl;
            }
        });
    }

    public void validateInputDimension(UnresolvedInlineTable table) {
        if (table.rows().nonEmpty()) {
            int numCols = table.names().size();
            ((IterableLike)table.rows().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(table, numCols){
                public static final long serialVersionUID = 0L;
                private final UnresolvedInlineTable table$1;
                private final int numCols$1;

                public final void apply(Tuple2<Seq<Expression>, Object> x0$1) {
                    Tuple2<Seq<Expression>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Seq row = (Seq)tuple2._1();
                        int ri = tuple2._2$mcI$sp();
                        if (row.size() != this.numCols$1) {
                            throw package$.MODULE$.AnalysisErrorAt(this.table$1).failAnalysis(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected ", " columns but found ", " columns in row ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numCols$1), BoxesRunTime.boxToInteger((int)row.size()), BoxesRunTime.boxToInteger((int)ri)})));
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.table$1 = table$1;
                    this.numCols$1 = numCols$1;
                }
            });
        }
    }

    public void validateInputEvaluable(UnresolvedInlineTable table) {
        table.rows().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Expression> row) {
                row.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Expression e) {
                        if (e.resolved() && e.foldable()) {
                            return;
                        }
                        throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot evaluate expression ", " in inline table definition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.sql()})));
                    }
                });
            }
        });
    }

    public LocalRelation convert(UnresolvedInlineTable table) {
        Seq fields = (Seq)((TraversableLike)((IterableLike)table.rows().transpose((Function1)Predef$.MODULE$.$conforms())).zip(table.names(), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(table){
            public static final long serialVersionUID = 0L;
            public final UnresolvedInlineTable table$2;

            public final StructField apply(Tuple2<Seq<Expression>, String> x0$2) {
                Tuple2<Seq<Expression>, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq column = (Seq)tuple2._1();
                    String name2 = (String)tuple2._2();
                    Seq inputTypes2 = (Seq)column.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(Expression x$1) {
                            return x$1.dataType();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    DataType tpe = (DataType)TypeCoercion$.MODULE$.findWiderTypeWithoutStringPromotion((Seq<DataType>)inputTypes2).getOrElse((Function0)new Serializable(this, name2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;
                        private final String name$1;

                        public final Nothing$ apply() {
                            return package$.MODULE$.AnalysisErrorAt(this.$outer.table$2).failAnalysis(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incompatible types found in column ", " for inline table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$1 = name$1;
                        }
                    });
                    StructField structField2 = new StructField(name2, tpe, column.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Expression x$2) {
                            return x$2.nullable();
                        }
                    }), StructField$.MODULE$.apply$default$4());
                    return structField2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.table$2 = table$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<AttributeReference> attributes = StructType$.MODULE$.apply((Seq<StructField>)fields).toAttributes();
        Predef$.MODULE$.assert(fields.size() == table.names().size());
        Seq newRows = (Seq)table.rows().map((Function1)new Serializable(table, fields){
            public static final long serialVersionUID = 0L;
            public final UnresolvedInlineTable table$2;
            public final Seq fields$1;

            public final InternalRow apply(Seq<Expression> row) {
                return InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)((TraversableLike)row.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object apply(Tuple2<Expression, Object> x0$3) {
                        Object object;
                        Tuple2<Expression, Object> tuple2 = x0$3;
                        if (tuple2 == null) throw new MatchError(tuple2);
                        Expression e = (Expression)tuple2._1();
                        int ci = tuple2._2$mcI$sp();
                        DataType targetType = ((StructField)this.$outer.fields$1.apply(ci)).dataType();
                        try {
                            if (e.dataType().sameType(targetType)) {
                                object = e.eval(e.eval$default$1());
                                return object;
                            }
                            Cast qual$1 = new Cast(e, targetType);
                            InternalRow x$3 = qual$1.eval$default$1();
                            object = qual$1.eval(x$3);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable ex = (Throwable)option.get();
                            throw package$.MODULE$.AnalysisErrorAt(this.$outer.table$2).failAnalysis(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to evaluate expression ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.sql(), ex.getMessage()})));
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())));
            }
            {
                this.table$2 = table$2;
                this.fields$1 = fields$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new LocalRelation(attributes, (Seq<InternalRow>)newRows);
    }

    private ResolveInlineTables$() {
        MODULE$ = this;
    }
}

