/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", extended="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u0001>\u0011abU;cgR\u0014\u0018N\\4J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\bgR\u0014X\t\u001f9s+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\tgR\u0014X\t\u001f9sA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0005eK2LW.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0006eK2LW.\u0012=qe\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\nG>,h\u000e^#yaJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IaI\u0001\u000bG>,h\u000e^#yaJ\u0004\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\t\u0001\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001$\u0011\u0015i\u0003\u00071\u0001$\u0011\u0015A\u0004\u0001\"\u0011:\u0003!!\u0017\r^1UsB,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011!\u0002;za\u0016\u001c\u0018BA =\u0005!!\u0015\r^1UsB,\u0007\"B!\u0001\t\u0003\u0012\u0015AC5oaV$H+\u001f9fgV\t1\tE\u0002E\u0019jr!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111*\u0007\u0005\u0006!\u0002!\t%U\u0001\tG\"LG\u000e\u001a:f]V\t!\u000bE\u0002E\u0019\u000eBQ\u0001\u0016\u0001\u0005BU\u000b!\u0002\u001d:fiRLh*Y7f+\u00051\u0006CA,[\u001d\tA\u0002,\u0003\u0002Z3\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI\u0016\u0004C\u0003_\u0001\u0011\u0005s,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003aG\u0016<\u0007C\u0001\rb\u0013\t\u0011\u0017DA\u0002B]fDQ\u0001Z/A\u0002\u0001\f1a\u001d;s\u0011\u00151W\f1\u0001a\u0003\u0015!W\r\\5n\u0011\u0015AW\f1\u0001a\u0003\u0015\u0019w.\u001e8u\u0011\u0015Q\u0007\u0001\"\u0011l\u0003%!wnR3o\u0007>$W\rF\u0002me^\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0002\u0002\u000f\r|G-Z4f]&\u0011\u0011O\u001c\u0002\t\u000bb\u0004(oQ8eK\")1/\u001ba\u0001i\u0006\u00191\r\u001e=\u0011\u00055,\u0018B\u0001<o\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001_5A\u00021\f!!\u001a<\t\u000fi\u0004\u0011\u0011!C\u0001w\u0006!1m\u001c9z)\u0011\u0019D0 @\t\u000f\u0005J\b\u0013!a\u0001G!9\u0011&\u001fI\u0001\u0002\u0004\u0019\u0003bB\u0017z!\u0003\u0005\ra\t\u0005\n\u0003\u0003\u0001\u0011\u0013!C\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0006)\u001a1%a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0005\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0007\u0001#\u0003%\t!a\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u0004\u0001\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0003mC:<'BAA\u0019\u0003\u0011Q\u0017M^1\n\u0007m\u000bY\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\b\t\u00041\u0005u\u0012bAA 3\t\u0019\u0011J\u001c;\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004A\u0006\u001d\u0003BCA%\u0003\u0003\n\t\u00111\u0001\u0002<\u0005\u0019\u0001\u0010J\u0019\t\u0013\u00055\u0003!!A\u0005B\u0005=\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0003#BA*\u00033\u0002WBAA+\u0015\r\t9&G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA.\u0003+\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003C\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\nI\u0007E\u0002\u0019\u0003KJ1!a\u001a\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0013\u0002^\u0005\u0005\t\u0019\u00011\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0005E\u0004\"CA%\u0003W\n\t\u00111\u0001aQ-\u0001\u0011QOA>\u0003{\n\t)a!\u0011\u0007E\t9(C\u0002\u0002z\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0000\u0005\u0019II\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!I\u0016d\u0017.\u001c\u0017!G>,h\u000e^\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!gV\u00147\u000f\u001e:j]\u001e\u0004cM]8nA\u0001\u001cHO\u001d1!E\u00164wN]3!A\u000e|WO\u001c;aA=\u001c7-\u001e:sK:\u001cWm\u001d\u0011pM\u0002\"\b.\u001a\u0011eK2LW.\u001b;fe\u0002\u0002G-\u001a7j[\u0002t#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011aG>,h\u000e\u001e1!SN\u0004\u0003o\\:ji&4X\r\f\u0011fm\u0016\u0014\u0018\u0010\u001e5j]\u001e\u0004Co\u001c\u0011uQ\u0016\u0004C.\u001a4uA=4\u0007\u0005\u001e5fA\u0019Lg.\u00197!I\u0016d\u0017.\\5uKJ\u0004\u0003fY8v]RLgn\u001a\u0011ge>l\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!Y\u00164G/\u000b\u0011jg\u0002\u0012X\r^;s]\u0016$g\u0006I%gA\u0001\u001cw.\u001e8uA\u0002J7\u000f\t8fO\u0006$\u0018N^3-A\u00154XM]=uQ&tw\r\t;pAQDW\r\t:jO\"$\be\u001c4!i\",\u0007EZ5oC2\u0004C-\u001a7j[&$XM\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0015d_VtG/\u001b8hA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004#/[4ii&\u0002\u0013n\u001d\u0011sKR,(O\\3e]\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oAM,(m\u001d;sS:<w,\u001b8eKb\u0004\u0003/\u001a:g_Jl7\u000fI1!G\u0006\u001cX-L:f]NLG/\u001b<fA5\fGo\u00195\u000bA\u0001\u0002\u0003\u0005\t\u0011xQ\u0016t\u0007e]3be\u000eD\u0017N\\4!M>\u0014\b\u0005\u00193fY&l\u0007M\f\u0006!A\u0005AQ\r\u001f;f]\u0012,G-\t\u0002\u0002\u0006\u0006!&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014xo^t\u0013\r]1dQ\u0016tsN]4(Y\u0001:cf\n\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003e^<x]\u0005\u0004\u0018m\u00195f\u0015\u0001\u0002s!CAE\u0005\u0005\u0005\t\u0012AAF\u00039\u0019VOY:ue&tw-\u00138eKb\u00042!EAG\r!\t!!!A\t\u0002\u0005=5#BAG\u0003#k\u0002\u0003CAJ\u00033\u001b3eI\u001a\u000e\u0005\u0005U%bAAL3\u00059!/\u001e8uS6,\u0017\u0002BAN\u0003+\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d\t\u0014Q\u0012C\u0001\u0003?#\"!a#\t\u0015\u0005\r\u0016QRA\u0001\n\u000b\n)+\u0001\u0005u_N#(/\u001b8h)\t\t9\u0003\u0003\u0006\u0002*\u00065\u0015\u0011!CA\u0003W\u000bQ!\u00199qYf$raMAW\u0003_\u000b\t\f\u0003\u0004\"\u0003O\u0003\ra\t\u0005\u0007S\u0005\u001d\u0006\u0019A\u0012\t\r5\n9\u000b1\u0001$\u0011)\t),!$\u0002\u0002\u0013\u0005\u0015qW\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI,!2\u0011\u000ba\tY,a0\n\u0007\u0005u\u0016D\u0001\u0004PaRLwN\u001c\t\u00071\u0005\u00057eI\u0012\n\u0007\u0005\r\u0017D\u0001\u0004UkBdWm\r\u0005\n\u0003\u000f\f\u0019,!AA\u0002M\n1\u0001\u001f\u00131\u0011)\tY-!$\u0002\u0002\u0013%\u0011QZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002PB!\u0011\u0011FAi\u0013\u0011\t\u0019.a\u000b\u0003\r=\u0013'.Z2u\u0001")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.strExpr(), this.delimExpr(), this.countExpr()}));
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String str, String delim, String count) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".subStringIndex(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str, delim, count}));
            }
        });
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.countExpr();
                break;
            }
            case 1: {
                expression = this.delimExpr();
                break;
            }
            case 0: {
                expression = this.strExpr();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes$class.$init$(this);
    }
}

