/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AddMonths$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u00113e\u001b>tG\u000f[:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u0013M$\u0018M\u001d;ECR,W#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005Q1\u000f^1si\u0012\u000bG/\u001a\u0011\t\u0011%\u0002!Q3A\u0005\u0002\t\n\u0011B\\;n\u001b>tG\u000f[:\t\u0011-\u0002!\u0011#Q\u0001\n\r\n!B\\;n\u001b>tG\u000f[:!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\u0012\u0013\u0001\u00027fMRDQ!\u000e\u0001\u0005B\t\nQA]5hQRDQa\u000e\u0001\u0005Ba\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\u0004c\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005\u0005K\u0012a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u00131aU3r\u0015\t\t\u0015\u0004\u0005\u0002G\u00136\tqI\u0003\u0002I\r\u0005)A/\u001f9fg&\u0011!j\u0012\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQ\u0001\u0014\u0001\u0005B5\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u001dB\u0011aiT\u0005\u0003!\u001e\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006%\u0002!\teU\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004)^K\u0006C\u0001\rV\u0013\t1\u0016DA\u0002B]fDQ\u0001W)A\u0002Q\u000bQa\u001d;beRDQAW)A\u0002Q\u000ba!\\8oi\"\u001c\b\"\u0002/\u0001\t\u0003j\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rqF-\u001b\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\n\tqaY8eK\u001e,g.\u0003\u0002dA\nAQ\t\u001f9s\u0007>$W\rC\u0003f7\u0002\u0007a-A\u0002dib\u0004\"aX4\n\u0005!\u0004'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006Un\u0003\rAX\u0001\u0003KZDQ\u0001\u001c\u0001\u0005B5\f!\u0002\u001d:fiRLh*Y7f+\u0005q\u0007CA8s\u001d\tA\u0002/\u0003\u0002r3\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\t\u0018\u0004C\u0004w\u0001\u0005\u0005I\u0011A<\u0002\t\r|\u0007/\u001f\u000b\u0004_aL\bbB\u0011v!\u0003\u0005\ra\t\u0005\bSU\u0004\n\u00111\u0001$\u0011\u001dY\b!%A\u0005\u0002q\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001~U\t\u0019cpK\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0011$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005E\u0001!%A\u0005\u0002q\fabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017bA:\u0002\u001e!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111F\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00012\u0001GA\u0018\u0013\r\t\t$\u0007\u0002\u0004\u0013:$\b\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001VA\u001d\u0011)\tY$a\r\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0004\"CA \u0001\u0005\u0005I\u0011IA!\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\"!\u0015\t)%a\u0013U\u001b\t\t9EC\u0002\u0002Je\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0011%#XM]1u_JD\u0011\"!\u0015\u0001\u0003\u0003%\t!a\u0015\u0002\u0011\r\fg.R9vC2$B!!\u0016\u0002\\A\u0019\u0001$a\u0016\n\u0007\u0005e\u0013DA\u0004C_>dW-\u00198\t\u0013\u0005m\u0012qJA\u0001\u0002\u0004!\u0006\"CA0\u0001\u0005\u0005I\u0011IA1\u0003\u0019)\u0017/^1mgR!\u0011QKA2\u0011%\tY$!\u0018\u0002\u0002\u0003\u0007A\u000bK\b\u0001\u0003O\ni'a\u001c\u0002t\u0005U\u0014\u0011PA>!\r\t\u0012\u0011N\u0005\u0004\u0003W\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003c\n!l\u0018$V\u001d\u000e{\u0006f\u001d;beR|F-\u0019;fY\u0001rW/\\0n_:$\bn]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!I\u0006$X\r\t;iCR\u0004\u0013n\u001d\u0011a]Vlw,\\8oi\"\u001c\b\rI1gi\u0016\u0014\b\u0005Y:uCJ$x\fZ1uK\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0014a\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00171q5\u001a\u0014g\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\u0002\u0014(L\u001a1\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA?\u0003\u0015\td&\u000e\u00181\u000f%\t\tIAA\u0001\u0012\u0003\t\u0019)A\u0005BI\u0012luN\u001c;igB\u0019\u0011#!\"\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u000f\u001bR!!\"\u0002\nv\u0001r!a#\u0002\u0012\u000e\u001as&\u0004\u0002\u0002\u000e*\u0019\u0011qR\r\u0002\u000fI,h\u000e^5nK&!\u00111SAG\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u0005\u0015E\u0011AAL)\t\t\u0019\t\u0003\u0006\u0002\u001c\u0006\u0015\u0015\u0011!C#\u0003;\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033A!\"!)\u0002\u0006\u0006\u0005I\u0011QAR\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0013QUAT\u0011\u0019\t\u0013q\u0014a\u0001G!1\u0011&a(A\u0002\rB!\"a+\u0002\u0006\u0006\u0005I\u0011QAW\u0003\u001d)h.\u00199qYf$B!a,\u0002<B)\u0001$!-\u00026&\u0019\u00111W\r\u0003\r=\u0003H/[8o!\u0015A\u0012qW\u0012$\u0013\r\tI,\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005u\u0016\u0011VA\u0001\u0002\u0004y\u0013a\u0001=%a!Q\u0011\u0011YAC\u0003\u0003%I!a1\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000b\u0004B!a\u0007\u0002H&!\u0011\u0011ZA\u000f\u0005\u0019y%M[3di\u0002")
public class AddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(AddMonths addMonths) {
        return AddMonths$.MODULE$.unapply(addMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, AddMonths> tupled() {
        return AddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, AddMonths>> curried() {
        return AddMonths$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.numMonths();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object months) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(BoxesRunTime.unboxToInt((Object)start), BoxesRunTime.unboxToInt((Object)months)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, dtu){
            public static final long serialVersionUID = 0L;
            private final String dtu$19;

            public final String apply(String sd, String m) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".dateAddMonths(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$19, sd, m}));
            }
            {
                this.dtu$19 = dtu$19;
            }
        });
    }

    @Override
    public String prettyName() {
        return "add_months";
    }

    public AddMonths copy(Expression startDate, Expression numMonths) {
        return new AddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    @Override
    public String productPrefix() {
        return "AddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            case 0: {
                expression = this.startDate();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        AddMonths addMonths = (AddMonths)x$1;
        Expression expression = this.startDate();
        Expression expression2 = addMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = addMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!addMonths.canEqual(this)) return false;
        return true;
    }

    public AddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes$class.$init$(this);
    }
}

