/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2.0 _FUNC_ '2.1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001>\u0011!c\u0012:fCR,'\u000f\u00165b]>\u0013X)];bY*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!QY\u0012\u0005\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef\u001cu.\u001c9be&\u001cxN\u001c\t\u0003+aq!!\u0005\f\n\u0005]\u0011\u0011a\u00029bG.\fw-Z\u0005\u00033i\u0011aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002\u0018\u0005A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t9\u0001K]8ek\u000e$\bC\u0001\u000f#\u0013\t\u0019SD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005&\u0001\tU\r\u0011\"\u0001'\u0003\u0011aWM\u001a;\u0016\u0003\u001d\u0002\"!\u0005\u0015\n\u0005%\u0012!AC#yaJ,7o]5p]\"A1\u0006\u0001B\tB\u0003%q%A\u0003mK\u001a$\b\u0005\u0003\u0005.\u0001\tU\r\u0011\"\u0001'\u0003\u0015\u0011\u0018n\u001a5u\u0011!y\u0003A!E!\u0002\u00139\u0013A\u0002:jO\"$\b\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004gQ*\u0004CA\t\u0001\u0011\u0015)\u0003\u00071\u0001(\u0011\u0015i\u0003\u00071\u0001(\u0011\u00159\u0004\u0001\"\u00119\u0003\u0019\u0019\u00180\u001c2pYV\t\u0011\b\u0005\u0002;{9\u0011AdO\u0005\u0003yu\ta\u0001\u0015:fI\u00164\u0017B\u0001 @\u0005\u0019\u0019FO]5oO*\u0011A(\b\u0005\u0006\u0003\u0002!\tFQ\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u0007\u001aC\u0005C\u0001\u000fE\u0013\t)UDA\u0002B]fDQa\u0012!A\u0002\r\u000ba!\u001b8qkR\f\u0004\"B%A\u0001\u0004\u0019\u0015AB5oaV$(\u0007C\u0004L\u0001\u0005\u0005I\u0011\u0001'\u0002\t\r|\u0007/\u001f\u000b\u0004g5s\u0005bB\u0013K!\u0003\u0005\ra\n\u0005\b[)\u0003\n\u00111\u0001(\u0011\u001d\u0001\u0006!%A\u0005\u0002E\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001SU\t93kK\u0001U!\t)&,D\u0001W\u0015\t9\u0006,A\u0005v]\u000eDWmY6fI*\u0011\u0011,H\u0001\u000bC:tw\u000e^1uS>t\u0017BA.W\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b;\u0002\t\n\u0011\"\u0001R\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBqa\u0018\u0001\u0002\u0002\u0013\u0005\u0003-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005Y\u0006twMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005y\u001a\u0007bB5\u0001\u0003\u0003%\tA[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002WB\u0011A\u0004\\\u0005\u0003[v\u00111!\u00138u\u0011\u001dy\u0007!!A\u0005\u0002A\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002Dc\"9!O\\A\u0001\u0002\u0004Y\u0017a\u0001=%c!9A\u000fAA\u0001\n\u0003*\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003Y\u00042a\u001e>D\u001b\u0005A(BA=\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003wb\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\b{\u0002\t\t\u0011\"\u0001\u007f\u0003!\u0019\u0017M\\#rk\u0006dGcA@\u0002\u0006A\u0019A$!\u0001\n\u0007\u0005\rQDA\u0004C_>dW-\u00198\t\u000fId\u0018\u0011!a\u0001\u0007\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00131B\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\fi\u0001\u0003\u0005s\u0003\u000f\t\t\u00111\u0001DQ=\u0001\u0011\u0011CA\f\u00033\ti\"a\b\u0002$\u0005\u0015\u0002cA\t\u0002\u0014%\u0019\u0011Q\u0003\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111D\u0001RKb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013n\u001d\u0011he\u0016\fG/\u001a:!i\"\fg\u000eI8sA\u0015\fX/\u00197!i>\u0004\u0003-\u001a=qeJ\u0002g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011E\u0001\u0003\u0014*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!_J$WM]3e]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A5\f\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0017!g>\u0004\u0013\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001J7\u000f\t8pi\u0002\u001aX\u000f\u001d9peR,GM\f\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002(\u0005\u00119K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00113A}3UKT\"`AEZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#G\f\u0019!?\u001a+fjQ0!OIr\u0013gJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!M\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002\u0004(\f\u00192AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u000f%\tYCAA\u0001\u0012\u0003\ti#\u0001\nHe\u0016\fG/\u001a:UQ\u0006twJ]#rk\u0006d\u0007cA\t\u00020\u0019A\u0011AAA\u0001\u0012\u0003\t\tdE\u0003\u00020\u0005M\u0012\u0005E\u0004\u00026\u0005mreJ\u001a\u000e\u0005\u0005]\"bAA\u001d;\u00059!/\u001e8uS6,\u0017\u0002BA\u001f\u0003o\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001d\t\u0014q\u0006C\u0001\u0003\u0003\"\"!!\f\t\u0015\u0005\u0015\u0013qFA\u0001\n\u000b\n9%\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0007BCA&\u0003_\t\t\u0011\"!\u0002N\u0005)\u0011\r\u001d9msR)1'a\u0014\u0002R!1Q%!\u0013A\u0002\u001dBa!LA%\u0001\u00049\u0003BCA+\u0003_\t\t\u0011\"!\u0002X\u00059QO\\1qa2LH\u0003BA-\u0003K\u0002R\u0001HA.\u0003?J1!!\u0018\u001e\u0005\u0019y\u0005\u000f^5p]B)A$!\u0019(O%\u0019\u00111M\u000f\u0003\rQ+\b\u000f\\33\u0011%\t9'a\u0015\u0002\u0002\u0003\u00071'A\u0002yIAB!\"a\u001b\u00020\u0005\u0005I\u0011BA7\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0004c\u00012\u0002r%\u0019\u00111O2\u0003\r=\u0013'.Z2u\u0001")
public class GreaterThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThanOrEqual greaterThanOrEqual) {
        return GreaterThanOrEqual$.MODULE$.unapply(greaterThanOrEqual);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThanOrEqual> tupled() {
        return GreaterThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThanOrEqual>> curried() {
        return GreaterThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return ">=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gteq(input1, input2));
    }

    public GreaterThanOrEqual copy(Expression left, Expression right) {
        return new GreaterThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThanOrEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public GreaterThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

