/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Levenshtein$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str1, str2) - Returns the Levenshtein distance between the two given strings.", examples="\n    Examples:\n      > SELECT _FUNC_('kitten', 'sitting');\n       3\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001>\u00111\u0002T3wK:\u001c\b\u000e^3j]*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003U\u00022A\u000e B\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003{e\tq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n\u00191+Z9\u000b\u0005uJ\u0002C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t15I\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\")\u0001\n\u0001C!\u0013\u0006AA-\u0019;b)f\u0004X-F\u0001K!\t\u00115*\u0003\u0002M\u0007\nAA)\u0019;b)f\u0004X\rC\u0003O\u0001\u0011Es*\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002Q'V\u0003\"\u0001G)\n\u0005IK\"aA!os\")A+\u0014a\u0001!\u0006IA.\u001a4u-\u0006dW/\u001a\u0005\u0006-6\u0003\r\u0001U\u0001\u000be&<\u0007\u000e\u001e,bYV,\u0007\"\u0002-\u0001\t\u0003J\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rQ\u0006-\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\tqaY8eK\u001e,g.\u0003\u0002`9\nAQ\t\u001f9s\u0007>$W\rC\u0003b/\u0002\u0007!-A\u0002dib\u0004\"aW2\n\u0005\u0011d&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006M^\u0003\rAW\u0001\u0003KZDq\u0001\u001b\u0001\u0002\u0002\u0013\u0005\u0011.\u0001\u0003d_BLHcA\u0018kW\"9\u0011e\u001aI\u0001\u0002\u0004\u0019\u0003bB\u0015h!\u0003\u0005\ra\t\u0005\b[\u0002\t\n\u0011\"\u0001o\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001c\u0016\u0003GA\\\u0013!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005YL\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001p\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002>\u0001#\u0003%\tA\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001da\b!!A\u0005Bu\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0011\u0001\u00026bm\u0006LA!a\u0003\u0002\u0002\t11\u000b\u001e:j]\u001eD\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0001c\u0001\r\u0002\u0016%\u0019\u0011qC\r\u0003\u0007%sG\u000fC\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001)\u0002 !Q\u0011\u0011EA\r\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013\u0007C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*A)\u00111FA\u0019!6\u0011\u0011Q\u0006\u0006\u0004\u0003_I\u0012AC2pY2,7\r^5p]&!\u00111GA\u0017\u0005!IE/\u001a:bi>\u0014\b\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0003\u0003\u00022\u0001GA\u001f\u0013\r\ty$\u0007\u0002\b\u0005>|G.Z1o\u0011%\t\t#!\u000e\u0002\u0002\u0003\u0007\u0001\u000bC\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H\u00051Q-];bYN$B!a\u000f\u0002J!I\u0011\u0011EA\"\u0003\u0003\u0005\r\u0001\u0015\u0015\u0010\u0001\u00055\u00131KA+\u00033\nY&a\u0018\u0002bA\u0019\u0011#a\u0014\n\u0007\u0005E#AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0013\u0001V0G+:\u001bu\fK:ueFb\u0003e\u001d;se%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004C*\u001a<f]NDG/Z5oA\u0011L7\u000f^1oG\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\u001e5fAQ<x\u000eI4jm\u0016t\u0007e\u001d;sS:<7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QL\u0001G\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3.\u001b;uK:<C\u0006I\u0014tSR$\u0018N\\4(SmR\u0001\u0005\t\u0011!A\u0001\u00023G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019'A\u00032]Ur\u0003gB\u0005\u0002h\t\t\t\u0011#\u0001\u0002j\u0005YA*\u001a<f]NDG/Z5o!\r\t\u00121\u000e\u0004\t\u0003\t\t\t\u0011#\u0001\u0002nM)\u00111NA8;A9\u0011\u0011OA<G\rzSBAA:\u0015\r\t)(G\u0001\beVtG/[7f\u0013\u0011\tI(a\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003W\"\t!! \u0015\u0005\u0005%\u0004BCAA\u0003W\n\t\u0011\"\u0012\u0002\u0004\u0006AAo\\*ue&tw\rF\u0001\u007f\u0011)\t9)a\u001b\u0002\u0002\u0013\u0005\u0015\u0011R\u0001\u0006CB\u0004H.\u001f\u000b\u0006_\u0005-\u0015Q\u0012\u0005\u0007C\u0005\u0015\u0005\u0019A\u0012\t\r%\n)\t1\u0001$\u0011)\t\t*a\u001b\u0002\u0002\u0013\u0005\u00151S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)*!)\u0011\u000ba\t9*a'\n\u0007\u0005e\u0015D\u0001\u0004PaRLwN\u001c\t\u00061\u0005u5eI\u0005\u0004\u0003?K\"A\u0002+va2,'\u0007C\u0005\u0002$\u0006=\u0015\u0011!a\u0001_\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\u001d\u00161NA\u0001\n\u0013\tI+A\u0006sK\u0006$'+Z:pYZ,GCAAV!\ry\u0018QV\u0005\u0005\u0003_\u000b\tA\u0001\u0004PE*,7\r\u001e")
public class Levenshtein
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Levenshtein levenshtein) {
        return Levenshtein$.MODULE$.unapply(levenshtein);
    }

    public static Function1<Tuple2<Expression, Expression>, Levenshtein> tupled() {
        return Levenshtein$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Levenshtein>> curried() {
        return Levenshtein$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object leftValue, Object rightValue) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)leftValue).levenshteinDistance((UTF8String)rightValue));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$5;

            public final String apply(String left, String right) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".levenshteinDistance(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$5.value(), left, right}));
            }
            {
                this.ev$5 = ev$5;
            }
        });
    }

    public Levenshtein copy(Expression left, Expression right) {
        return new Levenshtein(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Levenshtein";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Levenshtein;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Levenshtein)) return false;
        boolean bl = true;
        if (!bl) return false;
        Levenshtein levenshtein = (Levenshtein)x$1;
        Expression expression = this.left();
        Expression expression2 = levenshtein.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = levenshtein.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!levenshtein.canEqual(this)) return false;
        return true;
    }

    public Levenshtein(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

