/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001>\u0011QAT1Om2T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nA\u0001\\3giV\t1\u0005\u0005\u0002\u0012I%\u0011QE\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0014\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u000b1,g\r\u001e\u0011\t\u0011%\u0002!Q3A\u0005\u0002\t\nQA]5hQRD\u0001b\u000b\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0007e&<\u0007\u000e\u001e\u0011\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ry\u0003'\r\t\u0003#\u0001AQ!\t\u0017A\u0002\rBQ!\u000b\u0017A\u0002\rBQa\r\u0001\u0005BQ\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HB\u0001\u0006if\u0004Xm]\u0005\u0003u]\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\u0006y\u0001!\t%P\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001 \u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111ID\u0001\u0007yI|w\u000e\u001e \n\u0003iI!AR\r\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u001a!\t14*\u0003\u0002Mo\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0006\u001d\u0002!\teT\u0001\u0005KZ\fG\u000e\u0006\u0002Q'B\u0011\u0001$U\u0005\u0003%f\u00111!\u00118z\u0011\u001d!V\n%AA\u0002U\u000bQ!\u001b8qkR\u0004\"AV,\u000e\u0003\u0011I!\u0001\u0017\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u00065\u0002!\teW\u0001\nI><UM\\\"pI\u0016$2\u0001\u00182h!\ti\u0006-D\u0001_\u0015\ty&!A\u0004d_\u0012,w-\u001a8\n\u0005\u0005t&\u0001C#yaJ\u001cu\u000eZ3\t\u000b\rL\u0006\u0019\u00013\u0002\u0007\r$\b\u0010\u0005\u0002^K&\u0011aM\u0018\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015A\u0017\f1\u0001]\u0003\t)g\u000fC\u0004k\u0001\u0005\u0005I\u0011A6\u0002\t\r|\u0007/\u001f\u000b\u0004_1l\u0007bB\u0011j!\u0003\u0005\ra\t\u0005\bS%\u0004\n\u00111\u0001$\u0011\u001dy\u0007!%A\u0005\u0002A\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001rU\t\u0019#oK\u0001t!\t!\u00180D\u0001v\u0015\t1x/A\u0005v]\u000eDWmY6fI*\u0011\u00010G\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001>v\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\by\u0002\t\n\u0011\"\u0001q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBqA \u0001\u0002\u0002\u0013\u0005s0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0003mC:<'BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005M\u0001!!A\u0005\u0002\u0005U\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\f!\rA\u0012\u0011D\u0005\u0004\u00037I\"aA%oi\"I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0001\u00161\u0005\u0005\u000b\u0003K\ti\"!AA\u0002\u0005]\u0011a\u0001=%c!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00131F\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0006\t\u0006\u0003_\t)\u0004U\u0007\u0003\u0003cQ1!a\r\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\t\tD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0004AA\u0001\n\u0003\ti$\u0001\u0005dC:,\u0015/^1m)\u0011\ty$!\u0012\u0011\u0007a\t\t%C\u0002\u0002De\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002&\u0005e\u0012\u0011!a\u0001!\"I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131J\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0012Q\n\u0005\n\u0003K\t9%!AA\u0002ACs\u0002AA)\u0003/\nI&!\u0018\u0002`\u0005\r\u0014Q\r\t\u0004#\u0005M\u0013bAA+\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA.\u00035{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3S\u0001j\u0003EU3ukJt7\u000f\t1fqB\u0014\u0018\u0007\u0019\u0011jM\u0002JGoJ:!]>$\bET1OY\u0001z'\u000f\t1fqB\u0014(\u0007\u0019\u0011pi\",'o^5tK:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003C\n\u0011K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015dCN$\bf\n(b\u001d\u001e\u0002\u0013m\u001d\u0011e_V\u0014G.Z\u0015-AE\u00124'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\u001ad\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qM\u0001\u0006c9*d\u0006M\u0004\n\u0003W\u0012\u0011\u0011!E\u0001\u0003[\nQAT1Om2\u00042!EA8\r!\t!!!A\t\u0002\u0005E4#BA8\u0003gj\u0002cBA;\u0003w\u001a3eL\u0007\u0003\u0003oR1!!\u001f\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!! \u0002x\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f5\ny\u0007\"\u0001\u0002\u0002R\u0011\u0011Q\u000e\u0005\u000b\u0003\u000b\u000by'!A\u0005F\u0005\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0001BCAF\u0003_\n\t\u0011\"!\u0002\u000e\u0006)\u0011\r\u001d9msR)q&a$\u0002\u0012\"1\u0011%!#A\u0002\rBa!KAE\u0001\u0004\u0019\u0003BCAK\u0003_\n\t\u0011\"!\u0002\u0018\u00069QO\\1qa2LH\u0003BAM\u0003K\u0003R\u0001GAN\u0003?K1!!(\u001a\u0005\u0019y\u0005\u000f^5p]B)\u0001$!)$G%\u0019\u00111U\r\u0003\rQ+\b\u000f\\33\u0011%\t9+a%\u0002\u0002\u0003\u0007q&A\u0002yIAB!\"a+\u0002p\u0005\u0005I\u0011BAW\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0006\u0003BA\u0002\u0003cKA!a-\u0002\u0006\t1qJ\u00196fGR\u0004")
public class NaNvl
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl naNvl) {
        return NaNvl$.MODULE$.unapply(naNvl);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public Object eval(InternalRow input) {
        DataType dataType2;
        block6: {
            Object object;
            block3: {
                Object object2;
                block5: {
                    Object value2;
                    block4: {
                        block2: {
                            value2 = this.left().eval(input);
                            if (value2 != null) break block2;
                            object = null;
                            break block3;
                        }
                        dataType2 = this.left().dataType();
                        if (!DoubleType$.MODULE$.equals(dataType2)) break block4;
                        object2 = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)value2)).isNaN() ? this.right().eval(input) : value2;
                        break block5;
                    }
                    if (!FloatType$.MODULE$.equals(dataType2)) break block6;
                    object2 = Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)value2)).isNaN() ? this.right().eval(input) : value2;
                }
                object = object2;
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType2 = this.left().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2);
        if (bl) {
            ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
            return exprCode;
        }
        throw new MatchError((Object)dataType2);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

