/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u0001>\u0011\u0011bU3oi\u0016t7-Z:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\t\u0015/u\u0019\u0003CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0002\u0002\u000f\r|G-Z4f]&\u0011A$\u0007\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t9\u0001K]8ek\u000e$\bC\u0001\u0010%\u0013\t)sD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005(\u0001\tU\r\u0011\"\u0001)\u0003\r\u0019HO]\u000b\u0002!!A!\u0006\u0001B\tB\u0003%\u0001#\u0001\u0003tiJ\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011\u0001\u0015\u0002\u00111\fgnZ;bO\u0016D\u0001B\f\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\nY\u0006tw-^1hK\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\bG>,h\u000e\u001e:z\u0011!\u0011\u0004A!E!\u0002\u0013\u0001\u0012\u0001C2pk:$(/\u001f\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u00144\u0001\u0004\u0001\u0002b\u0002\u00174!\u0003\u0005\r\u0001\u0005\u0005\baM\u0002\n\u00111\u0001\u0011\u0011\u0015!\u0004\u0001\"\u0001<)\t1D\bC\u0003(u\u0001\u0007\u0001\u0003C\u00035\u0001\u0011\u0005a\bF\u00027\u007f\u0001CQaJ\u001fA\u0002AAQ\u0001L\u001fA\u0002AAQA\u0011\u0001\u0005B\r\u000b\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002\tB\u0011a$R\u0005\u0003\r~\u0011qAQ8pY\u0016\fg\u000eC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0005CA&O\u001b\u0005a%BA'\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tyEJ\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\t\u0006\u0001\"\u0011S\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002'B\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u000f\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\\?\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037~\u0001\"a\u00131\n\u0005\u0005d%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003!\u0019\u0007.\u001b7ee\u0016tW#A3\u0011\u0007Qc\u0006\u0003C\u0003h\u0001\u0011\u0005\u0003.\u0001\u0003fm\u0006dGCA5m!\tq\".\u0003\u0002l?\t\u0019\u0011I\\=\t\u000f54\u0007\u0013!a\u0001]\u0006)\u0011N\u001c9viB\u0011q\u000e]\u0007\u0002\t%\u0011\u0011\u000f\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003t\u0001\u0011%A/\u0001\u0007hKR\u001cVM\u001c;f]\u000e,7\u000f\u0006\u0003vw\u0006%\u0001C\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u0011)H/\u001b7\n\u0005i<(\u0001E$f]\u0016\u0014\u0018nY!se\u0006LH)\u0019;b\u0011\u0015a(\u000f1\u0001~\u0003%\u0019XM\u001c;f]\u000e,7\u000fE\u0002\u007f\u0003\u0007q!AH@\n\u0007\u0005\u0005q$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003y\u0002bBA\u0006e\u0002\u0007\u0011QB\u0001\u0007Y>\u001c\u0017\r\\3\u0011\t\u0005=\u0011qC\u0007\u0003\u0003#Q1\u0001_A\n\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003#\u0011a\u0001T8dC2,\u0007\"CA\u000f\u0001\u0005\u0005I\u0011AA\u0010\u0003\u0011\u0019w\u000e]=\u0015\u000fY\n\t#a\t\u0002&!Aq%a\u0007\u0011\u0002\u0003\u0007\u0001\u0003\u0003\u0005-\u00037\u0001\n\u00111\u0001\u0011\u0011!\u0001\u00141\u0004I\u0001\u0002\u0004\u0001\u0002\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\u0007A\tyc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tYdH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019\u0005AI\u0001\n\u0003\tY#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005-\u0012AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003\u0017\u0002\u0011\u0011!C!\u0003\u001b\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#\u0002BA+\u0003'\tA\u0001\\1oO&!\u0011QAA*\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019a$!\u0019\n\u0007\u0005\rtDA\u0002J]RD\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011.a\u001b\t\u0015\u00055\u0014QMA\u0001\u0002\u0004\ty&A\u0002yIEB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\u000b\u0005]\u0014QP5\u000e\u0005\u0005e$bAA>?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011QQ\u0001\tG\u0006tW)];bYR\u0019A)a\"\t\u0013\u00055\u0014\u0011QA\u0001\u0002\u0004I\u0007\"CAF\u0001\u0005\u0005I\u0011IAG\u0003\u0019)\u0017/^1mgR\u0019A)a$\t\u0013\u00055\u0014\u0011RA\u0001\u0002\u0004I\u0007f\u0004\u0001\u0002\u0014\u0006e\u00151TAP\u0003C\u000b)+a*\u0011\u0007E\t)*C\u0002\u0002\u0018\n\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001e\u0006auLR+O\u0007~C3\u000f\u001e:\\Y\u0001b\u0017M\\4-A\r|WO\u001c;ssvK\u0003%\f\u0011Ta2LGo\u001d\u0011agR\u0014\b\rI5oi>\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\u0005\u0014(/Y=!_\u001a\u0004so\u001c:eg:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003G\u000baN\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0011&\u0004C\u000f[3sK\u0006\u0002si\\8eA5|'O\\5oO::\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\7\nB\u0015N\t\u0017#i\",'/\u001a\u0012^Ym\u0013si\\8eE1\u0012Sn\u001c:oS:<'%X/\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bIr\u0003G\f\u0019\b\u0013\u00055&!!A\t\u0002\u0005=\u0016!C*f]R,gnY3t!\r\t\u0012\u0011\u0017\u0004\t\u0003\t\t\t\u0011#\u0001\u00024N)\u0011\u0011WA[GAA\u0011qWA_!A\u0001b'\u0004\u0002\u0002:*\u0019\u00111X\u0010\u0002\u000fI,h\u000e^5nK&!\u0011qXA]\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\bi\u0005EF\u0011AAb)\t\ty\u000b\u0003\u0006\u0002H\u0006E\u0016\u0011!C#\u0003\u0013\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001fB!\"!4\u00022\u0006\u0005I\u0011QAh\u0003\u0015\t\u0007\u000f\u001d7z)\u001d1\u0014\u0011[Aj\u0003+DaaJAf\u0001\u0004\u0001\u0002\u0002\u0003\u0017\u0002LB\u0005\t\u0019\u0001\t\t\u0011A\nY\r%AA\u0002AA!\"!7\u00022\u0006\u0005I\u0011QAn\u0003\u001d)h.\u00199qYf$B!!8\u0002jB)a$a8\u0002d&\u0019\u0011\u0011]\u0010\u0003\r=\u0003H/[8o!\u0019q\u0012Q\u001d\t\u0011!%\u0019\u0011q]\u0010\u0003\rQ+\b\u000f\\34\u0011%\tY/a6\u0002\u0002\u0003\u0007a'A\u0002yIAB!\"a<\u00022F\u0005I\u0011AA\u0016\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!Q\u00111_AY#\u0003%\t!a\u000b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011)\t90!-\u0012\u0002\u0013\u0005\u00111F\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u00111`AY#\u0003%\t!a\u000b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!\"a@\u00022\u0006\u0005I\u0011\u0002B\u0001\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0001\u0003BA)\u0005\u000bIAAa\u0002\u0002T\t1qJ\u00196fGR\u0004")
public class Sentences
extends Expression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences sentences) {
        return Sentences$.MODULE$.unapply(sentences);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new ArrayType(StringType$.MODULE$, false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.language();
        Expression expression3 = this.country();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object string = this.str().eval(input);
        if (string == null) {
            genericArrayData = null;
        } else {
            UTF8String languageStr = (UTF8String)this.language().eval(input);
            UTF8String countryStr = (UTF8String)this.country().eval(input);
            Locale locale = languageStr == null || countryStr == null ? Locale.US : new Locale(languageStr.toString(), countryStr.toString());
            genericArrayData = this.getSentences(((UTF8String)string).toString(), locale);
        }
        return genericArrayData;
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.country();
                break;
            }
            case 1: {
                expression = this.language();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes$class.$init$(this);
        CodegenFallback$class.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

