/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the leading string contains the characters from the trim string\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('Sp', 'SSparkSQLS');\n       arkSQLS\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mv!B\u0001\u0003\u0011\u0003y\u0011AD*ue&tw\r\u0016:j[2+g\r\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\tq1\u000b\u001e:j]\u001e$&/[7MK\u001a$8cA\t\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"!F\u000e\n\u0005q1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0010\u0012\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u0015\t\u0013\u0003\"\u0001#\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u0013\u0011PA?!\t\u0001BE\u0002\u0003\u0013\u0005\u0001+3#\u0002\u0013'S1R\u0002C\u0001\t(\u0013\tA#A\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001\u0005\u0016\n\u0005-\u0012!!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+5J!A\f\f\u0003\u000fA\u0013x\u000eZ;di\"A\u0001\u0007\nBK\u0002\u0013\u0005\u0011'\u0001\u0004te\u000e\u001cFO]\u000b\u0002M!A1\u0007\nB\tB\u0003%a%A\u0004te\u000e\u001cFO\u001d\u0011\t\u0011U\"#Q3A\u0005\u0002Y\nq\u0001\u001e:j[N#(/F\u00018!\r)\u0002HJ\u0005\u0003sY\u0011aa\u00149uS>t\u0007\u0002C\u001e%\u0005#\u0005\u000b\u0011B\u001c\u0002\u0011Q\u0014\u0018.\\*ue\u0002BQA\b\u0013\u0005\u0002u\"2a\t @\u0011\u0015\u0001D\b1\u0001'\u0011\u001d)D\b%AA\u0002]BQA\b\u0013\u0005\u0002\u0005#2a\t\"D\u0011\u0015)\u0004\t1\u0001'\u0011\u0015\u0001\u0004\t1\u0001'\u0011\u0015qB\u0005\"\u0001F)\t\u0019c\tC\u00031\t\u0002\u0007a\u0005C\u0003II\u0011\u0005\u0013*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0013\t\u0003\u0017:s!!\u0006'\n\u000553\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\f\t\u000bI#C\u0011I*\u0002\t\u00154\u0018\r\u001c\u000b\u0003)^\u0003\"!F+\n\u0005Y3\"aA!os\"9\u0001,\u0015I\u0001\u0002\u0004I\u0016!B5oaV$\bC\u0001.\\\u001b\u0005!\u0011B\u0001/\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000by#C\u0011K0\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00011gWB\u0011\u0011\rZ\u0007\u0002E*\u00111MA\u0001\bG>$WmZ3o\u0013\t)'M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00159W\f1\u0001i\u0003\r\u0019G\u000f\u001f\t\u0003C&L!A\u001b2\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")A.\u0018a\u0001A\u0006\u0011QM\u001e\u0005\b]\u0012\n\t\u0011\"\u0001p\u0003\u0011\u0019w\u000e]=\u0015\u0007\r\u0002\u0018\u000fC\u00041[B\u0005\t\u0019\u0001\u0014\t\u000fUj\u0007\u0013!a\u0001o!91\u000fJI\u0001\n\u0003!\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002k*\u0012aE^\u0016\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001 \f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u007fs\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005A%%A\u0005\u0002\u0005\r\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bQ#a\u000e<\t\u0013\u0005%A%!A\u0005B\u0005-\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001\u00027b]\u001eT!!a\u0006\u0002\t)\fg/Y\u0005\u0004\u001f\u0006E\u0001\"CA\u000fI\u0005\u0005I\u0011AA\u0010\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0003E\u0002\u0016\u0003GI1!!\n\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003S!\u0013\u0011!C\u0001\u0003W\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002U\u0003[A!\"a\f\u0002(\u0005\u0005\t\u0019AA\u0011\u0003\rAH%\r\u0005\n\u0003g!\u0013\u0011!C!\u0003k\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0001R!!\u000f\u0002@Qk!!a\u000f\u000b\u0007\u0005ub#\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sCR|'\u000fC\u0005\u0002F\u0011\n\t\u0011\"\u0001\u0002H\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002J\u0005=\u0003cA\u000b\u0002L%\u0019\u0011Q\n\f\u0003\u000f\t{w\u000e\\3b]\"I\u0011qFA\"\u0003\u0003\u0005\r\u0001\u0016\u0005\n\u0003'\"\u0013\u0011!C!\u0003+\na!Z9vC2\u001cH\u0003BA%\u0003/B\u0011\"a\f\u0002R\u0005\u0005\t\u0019\u0001+)'\u0011\nY&!\u0019\u0002d\u0005\u001d\u0014\u0011NA7\u0003_\n\u0019(!\u001e\u0011\u0007A\ti&C\u0002\u0002`\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002f\u0005\t)F\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!Y\u0016\fG-\u001b8hAM\u0004\u0018mY3!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)iJLWn\u0015;sY\u0001\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!Y\u0016\fG-\u001b8hAM$(/\u001b8hA\r|g\u000e^1j]N\u0004C\u000f[3!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<'\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA6\u0003\u0005u!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006\t;sS6\u001cFO\u001d\u0011.AQDW\r\t;sS6\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!i>\u0004CO]5nY\u0001\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002\n\u0007e]5oO2,\u0007e\u001d9bG\u0016T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011O\u0001\u0002\f)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u001eb\u0003eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I1sWN\u000bFj\u0015\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006c9*d\u0006\r\u0005\u0007\u0003w\u0002\u0003\u0019\u0001\u0014\u0002\u0007M$(\u000fC\u00036A\u0001\u0007a\u0005\u0003\u0004\"#\u0011\u0005\u0011\u0011\u0011\u000b\u0004G\u0005\r\u0005bBA>\u0003\u007f\u0002\rA\n\u0005\tCE\t\t\u0011\"!\u0002\bR)1%!#\u0002\f\"1\u0001'!\"A\u0002\u0019B\u0001\"NAC!\u0003\u0005\ra\u000e\u0005\n\u0003\u001f\u000b\u0012\u0011!CA\u0003#\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0014\u0006m\u0005\u0003B\u000b9\u0003+\u0003R!FALM]J1!!'\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011QTAG\u0003\u0003\u0005\raI\u0001\u0004q\u0012\u0002\u0004\"CAQ#E\u0005I\u0011AA\u0002\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011QU\t\u0012\u0002\u0013\u0005\u00111A\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011V\t\u0002\u0002\u0013%\u00111V\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002.B!\u0011qBAX\u0013\u0011\t\t,!\u0005\u0003\r=\u0013'.Z2u\u0001")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression$class.children(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression$class.sql(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$4;

            public final ExprCode apply(Expression x$33) {
                return x$33.genCode(this.ctx$4);
            }
            {
                this.ctx$4 = ctx$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$34) {
                    return x$34.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$35) {
                    return x$35.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

