/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class HashByteArrayBenchmark$ {
    public static HashByteArrayBenchmark$ MODULE$;

    static {
        new HashByteArrayBenchmark$();
    }

    public void test(int length, long seed, int numArrays, int iters) {
        Random random = new Random(seed);
        byte[][] arrays = (byte[][])Array$.MODULE$.fill(numArrays, (Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            byte[] bytes = new byte[length];
            random.nextBytes(bytes);
            return var2_2;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Benchmark benchmark = new Benchmark(new StringBuilder(29).append("Hash byte arrays with length ").append(length).toString(), (long)iters * (long)numArrays, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Murmur3_x86_32", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                for (int i = 0; i < numArrays; ++i) {
                    sum$1.elem += (long)Murmur3_x86_32.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length, (int)42);
                }
            });
        });
        benchmark.addCase("xxHash 64-bit", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                for (int i = 0; i < numArrays; ++i) {
                    sum$2.elem += XXH64.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length, (long)42L);
                }
            });
        });
        benchmark.addCase("HiveHasher", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                for (int i = 0; i < numArrays; ++i) {
                    sum$3.elem += (long)HiveHasher.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length);
                }
            });
        });
        benchmark.run();
    }

    public void main(String[] args) {
        this.test(8, 42L, 1024, 2048);
        this.test(16, 42L, 1024, 2048);
        this.test(24, 42L, 1024, 2048);
        this.test(31, 42L, 1024, 2048);
        this.test(95, 42L, 1024, 2048);
        this.test(287, 42L, 1024, 2048);
        this.test(1055, 42L, 1024, 2048);
        this.test(2079, 42L, 1024, 2048);
        this.test(8223, 42L, 1024, 2048);
    }

    private HashByteArrayBenchmark$() {
        MODULE$ = this;
    }
}

