/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.MathContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class RandomDataGenerator$ {
    public static RandomDataGenerator$ MODULE$;
    private final float PROBABILITY_OF_INTERESTING_VALUE;
    private final float PROBABILITY_OF_NULL;
    private final int MAX_STR_LEN;
    private final int MAX_ARR_SIZE;
    private final int MAX_MAP_SIZE;

    static {
        new RandomDataGenerator$();
    }

    private float PROBABILITY_OF_INTERESTING_VALUE() {
        return this.PROBABILITY_OF_INTERESTING_VALUE;
    }

    private float PROBABILITY_OF_NULL() {
        return this.PROBABILITY_OF_NULL;
    }

    public final int MAX_STR_LEN() {
        return this.MAX_STR_LEN;
    }

    public final int MAX_ARR_SIZE() {
        return this.MAX_ARR_SIZE;
    }

    public final int MAX_MAP_SIZE() {
        return this.MAX_MAP_SIZE;
    }

    private <T> Some<Function0<T>> randomNumeric(Random rand, Function1<Random, T> uniformRand, Seq<T> interestingValues) {
        Function0 & Serializable & scala.Serializable f = (Function0 & Serializable & scala.Serializable)() -> rand.nextFloat() <= MODULE$.PROBABILITY_OF_INTERESTING_VALUE() ? interestingValues.apply(rand.nextInt(interestingValues.length())) : uniformRand.apply((Object)rand);
        return new Some((Object)f);
    }

    /*
     * WARNING - void declaration
     */
    public float intBitsToFloat(int bits) {
        void var2_2;
        float value = Float.intBitsToFloat(bits);
        return Predef$.MODULE$.float2Float(value).isNaN() ? Float.NaN : var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public double longBitsToDouble(long bits) {
        void var3_2;
        double value = Double.longBitsToDouble(bits);
        return Predef$.MODULE$.double2Double(value).isNaN() ? Double.NaN : var3_2;
    }

    public StructType randomSchema(Random rand, int numFields, Seq<DataType> acceptedTypes) {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.tabulate(numFields, (Function1 & Serializable & scala.Serializable)i -> RandomDataGenerator$.$anonfun$randomSchema$1(acceptedTypes, rand, BoxesRunTime.unboxToInt((Object)i))));
    }

    public StructType randomNestedSchema(Random rand, int totalFields, Seq<DataType> acceptedTypes) {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int i = 0;
        int numFields = totalFields;
        while (numFields > 0) {
            int v = rand.nextInt(3);
            if (v == 0) {
                DataType dt = (DataType)acceptedTypes.apply(rand.nextInt(acceptedTypes.size()));
                fields.$plus$eq((Object)new StructField(new StringBuilder(4).append("col_").append(i).toString(), dt, rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                --numFields;
            } else if (v == 1) {
                DataType dt = (DataType)acceptedTypes.apply(rand.nextInt(acceptedTypes.size()));
                fields.$plus$eq((Object)new StructField(new StringBuilder(4).append("col_").append(i).toString(), (DataType)ArrayType$.MODULE$.apply(dt), rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                --numFields;
            } else {
                int n = Math.max(rand.nextInt(numFields), 1);
                StructType nested = this.randomNestedSchema(rand, n, acceptedTypes);
                fields.$plus$eq((Object)new StructField(new StringBuilder(4).append("col_").append(i).toString(), (DataType)nested, rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                numFields -= n;
            }
            ++i;
        }
        return StructType$.MODULE$.apply((Seq)fields);
    }

    public Option<Function0<Object>> forType(DataType dataType, boolean nullable, Random rand) {
        DecimalType decimalType;
        Option option;
        Option option2;
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Function0 & Serializable & scala.Serializable)() -> rand.nextString(rand.nextInt(MODULE$.MAX_STR_LEN())));
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Function0 & Serializable & scala.Serializable)() -> {
                void var1_1;
                byte[] arr = new byte[rand.nextInt(MODULE$.MAX_STR_LEN())];
                rand.nextBytes(arr);
                return var1_1;
            });
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            option2 = new Some((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rand.nextBoolean());
        } else if (DateType$.MODULE$.equals(dataType2)) {
            Function0 & Serializable & scala.Serializable generator = (Function0 & Serializable & scala.Serializable)() -> {
                long milliseconds = rand.nextLong() % 253402329599999L;
                while (milliseconds < -62135740800000L) {
                    milliseconds = rand.nextLong() % 253402329599999L;
                }
                return DateTimeUtils$.MODULE$.toJavaDate((int)(milliseconds / 86400000L));
            };
            option2 = new Some((Object)generator);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            Function0 & Serializable & scala.Serializable generator = (Function0 & Serializable & scala.Serializable)() -> {
                long milliseconds = rand.nextLong() % 253402329599999L;
                while (milliseconds < -62135740800000L) {
                    milliseconds = rand.nextLong() % 253402329599999L;
                }
                return DateTimeUtils$.MODULE$.toJavaTimestamp(milliseconds * 1000L);
            };
            option2 = new Some((Object)generator);
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Function0 & Serializable & scala.Serializable)() -> {
                int months = rand.nextInt(1000);
                long ns = rand.nextLong();
                return new CalendarInterval(months, ns);
            });
        } else if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            option2 = new Some((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.BigDecimal().apply(rand.nextLong() % (long)scala.math.package$.MODULE$.pow(10.0, (double)precision), scale, new MathContext(precision)).bigDecimal());
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToDouble((double)RandomDataGenerator$.MODULE$.longBitsToDouble(r.nextLong())), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double$.MODULE$.MinValue(), Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN, 0.0})));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToFloat((float)RandomDataGenerator$.MODULE$.intBitsToFloat(r.nextInt())), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{Float$.MODULE$.MinValue(), Float.MIN_VALUE, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NaN, 0.0f})));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)RandomDataGenerator$.$anonfun$forType$10(x$1)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, 127, (byte)0})));
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.nextInt()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 0})));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextLong()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 0L})));
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToShort((short)RandomDataGenerator$.$anonfun$forType$13(x$4)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, (short)0})));
        } else if (NullType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Function0 & Serializable & scala.Serializable)() -> null);
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            option2 = this.forType(elementType, containsNull, rand).map((Function1 & Serializable & scala.Serializable)elementGenerator -> (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.fill(rand.nextInt(MODULE$.MAX_ARR_SIZE()), elementGenerator));
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            option2 = this.forType(keyType, false, rand).flatMap((Function1 & Serializable & scala.Serializable)keyGenerator -> MODULE$.forType(valueType, valueContainsNull, rand).map((Function1 & Serializable & scala.Serializable)valueGenerator -> (Function0 & Serializable & scala.Serializable)() -> {
                int length = rand.nextInt(MODULE$.MAX_MAP_SIZE());
                HashSet keys = (HashSet)HashSet$.MODULE$.apply((Seq)Seq$.MODULE$.fill(length, keyGenerator));
                for (int count = 0; keys.size() < length && count < MODULE$.MAX_MAP_SIZE(); ++count) {
                    keys.$plus$eq(keyGenerator.apply());
                }
                Seq values = (Seq)Seq$.MODULE$.fill(keys.size(), valueGenerator);
                return ((TraversableOnce)keys.zip((GenIterable)values, HashSet$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }));
        } else if (dataType2 instanceof StructType) {
            None$ none$;
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Seq maybeFieldGenerators = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.forType(field.dataType(), field.nullable(), rand), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            if (maybeFieldGenerators.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDefined()))) {
                Seq fieldGenerators = (Seq)maybeFieldGenerators.map((Function1 & Serializable & scala.Serializable)x$6 -> (Function0)x$6.get(), Seq$.MODULE$.canBuildFrom());
                none$ = new Some((Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.fromSeq((Seq)fieldGenerators.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply(), Seq$.MODULE$.canBuildFrom())));
            } else {
                none$ = None$.MODULE$;
            }
            option2 = none$;
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            Option<Function0<Object>> maybeSqlTypeGenerator = this.forType(userDefinedType.sqlType(), nullable, rand);
            Function1 toCatalystType = CatalystTypeConverters$.MODULE$.createToCatalystConverter(userDefinedType.sqlType());
            option2 = maybeSqlTypeGenerator.map((Function1 & Serializable & scala.Serializable)sqlTypeGenerator -> (Function0 & Serializable & scala.Serializable)() -> {
                Object generatedScalaValue = sqlTypeGenerator.apply();
                return generatedScalaValue == null ? null : userDefinedType.deserialize(toCatalystType.apply(generatedScalaValue));
            });
        } else {
            option2 = None$.MODULE$;
        }
        Option valueGenerator2 = option2;
        return valueGenerator2.map((Function1 & Serializable & scala.Serializable)valueGenerator -> nullable ? (Function0 & Serializable & scala.Serializable)() -> rand.nextFloat() <= MODULE$.PROBABILITY_OF_NULL() ? null : valueGenerator.apply() : valueGenerator);
    }

    public boolean forType$default$2() {
        return true;
    }

    public Random forType$default$3() {
        return new Random();
    }

    public Row randomRow(Random rand, StructType schema) {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            ArrayBuffer arrayBuffer;
            DataType dataType = f.dataType();
            if (dataType instanceof ArrayType) {
                ArrayBuffer arrayBuffer2;
                ArrayType arrayType = (ArrayType)dataType;
                DataType childType = arrayType.elementType();
                boolean nullable = arrayType.containsNull();
                if (f.nullable() && rand.nextFloat() <= MODULE$.PROBABILITY_OF_NULL()) {
                    arrayBuffer2 = null;
                } else {
                    ArrayBuffer arr = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                    int n = 1;
                    Option<Function0<Object>> generator = MODULE$.forType(childType, nullable, rand);
                    Predef$.MODULE$.assert(generator.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Unsupported type");
                    Function0 gen = (Function0)generator.get();
                    for (int i = 0; i < n; ++i) {
                        arr.$plus$eq(gen.apply());
                    }
                    arrayBuffer2 = arr;
                }
                ArrayBuffer data = arrayBuffer2;
                arrayBuffer = fields.$plus$eq(data);
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] children = structType.fields();
                arrayBuffer = fields.$plus$eq((Object)MODULE$.randomRow(rand, new StructType(children)));
            } else {
                Option<Function0<Object>> generator = MODULE$.forType(f.dataType(), f.nullable(), rand);
                Predef$.MODULE$.assert(generator.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Unsupported type");
                Function0 gen = (Function0)generator.get();
                arrayBuffer = fields.$plus$eq(gen.apply());
            }
            return arrayBuffer;
        });
        return Row$.MODULE$.fromSeq((Seq)fields);
    }

    public static final /* synthetic */ StructField $anonfun$randomSchema$1(Seq acceptedTypes$1, Random rand$2, int i) {
        DataType dt = (DataType)acceptedTypes$1.apply(rand$2.nextInt(acceptedTypes$1.size()));
        return new StructField(new StringBuilder(4).append("col_").append(i).toString(), dt, rand$2.nextBoolean(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ byte $anonfun$forType$10(Random x$1) {
        return (byte)x$1.nextInt();
    }

    public static final /* synthetic */ short $anonfun$forType$13(Random x$4) {
        return (short)x$4.nextInt();
    }

    private RandomDataGenerator$() {
        MODULE$ = this;
        this.PROBABILITY_OF_INTERESTING_VALUE = 0.5f;
        this.PROBABILITY_OF_NULL = 0.1f;
        this.MAX_STR_LEN = 1024;
        this.MAX_ARR_SIZE = 128;
        this.MAX_MAP_SIZE = 128;
    }
}

