/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00153AAB\u0004\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!9a\u0006AI\u0001\n\u0003y\u0003b\u0002\u001e\u0001\u0005\u0004%\ta\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u00031I\u000bg\u000eZ8n\t\u0006$\u0018mR3oKJ\fGo\u001c:Tk&$XM\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u00059\u0011\u0001\u0007;fgR\u0014\u0016M\u001c3p[\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^5p]R\u00191$I\u0015\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006E\t\u0001\raI\u0001\tI\u0006$\u0018\rV=qKB\u0011AeJ\u0007\u0002K)\u0011aeB\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\bU\t\u0001\n\u00111\u0001,\u0003!qW\u000f\u001c7bE2,\u0007C\u0001\u000f-\u0013\tiSDA\u0004C_>dW-\u00198\u0002EQ,7\u000f\u001e*b]\u0012|W\u000eR1uC\u001e+g.\u001a:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0001$FA\u00162W\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003%)hn\u00195fG.,GM\u0003\u00028;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e\"$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0012\r^8nS\u000e$\u0016\u0010]3t/&$\b\u000eR1uC\u001e+g.\u001a:bi>\u00148/F\u0001=!\ri$iI\u0007\u0002})\u0011q\bQ\u0001\nS6lW\u000f^1cY\u0016T!!Q\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\t\u00191+\u001a;\u0002=\u0005$x.\\5d)f\u0004Xm],ji\"$\u0015\r^1HK:,'/\u0019;peN\u0004\u0003")
public class RandomDataGeneratorSuite
extends SparkFunSuite {
    private final Set<DataType> atomicTypesWithDataGenerators;

    public void testRandomDataGeneration(DataType dataType, boolean nullable) {
        Assertion assertion;
        Function1 toCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType);
        Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType(dataType, nullable, new Random(33)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(42).append("Random data generator was not defined for ").append(dataType).toString(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41)));
        if (nullable) {
            Iterator $org_scalatest_assert_macro_left = package$.MODULE$.Iterator().fill(100, generator);
            Object $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", null, $org_scalatest_assert_macro_left.contains(null), Prettifier$.MODULE$.default());
            assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        } else {
            Iterator $org_scalatest_assert_macro_left = package$.MODULE$.Iterator().fill(100, generator);
            Object $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", null, $org_scalatest_assert_macro_left.contains(null), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable & scala.Serializable)_ -> RandomDataGeneratorSuite.$anonfun$testRandomDataGeneration$2(generator, toCatalyst, BoxesRunTime.unboxToInt((Object)_)));
    }

    public boolean testRandomDataGeneration$default$2() {
        return true;
    }

    public Set<DataType> atomicTypesWithDataGenerators() {
        return this.atomicTypesWithDataGenerators;
    }

    public static final /* synthetic */ Object $anonfun$testRandomDataGeneration$2(Function0 generator$1, Function1 toCatalyst$1, int _) {
        Object generatedValue = generator$1.apply();
        return toCatalyst$1.apply(generatedValue);
    }

    public static final /* synthetic */ boolean $anonfun$new$2(DataType dataType$2, boolean nullable) {
        return !(dataType$2 instanceof DecimalType);
    }

    public static final /* synthetic */ void $anonfun$new$1(RandomDataGeneratorSuite $this, DataType dataType) {
        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).withFilter((Function1 & Serializable & scala.Serializable)nullable -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$2(dataType, BoxesRunTime.unboxToBoolean((Object)nullable)))).foreach((Function1 & Serializable & scala.Serializable)nullable -> {
            $this.test(new StringBuilder(12).append(dataType).append(" (nullable=").append(BoxesRunTime.unboxToBoolean((Object)nullable)).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration(dataType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$5(ArrayType arrayType) {
        return RandomDataGenerator$.MODULE$.forType(arrayType.elementType(), arrayType.containsNull(), RandomDataGenerator$.MODULE$.forType$default$3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$atomicTypesWithDataGenerators$1(DataType x$1) {
        return RandomDataGenerator$.MODULE$.forType(x$1, RandomDataGenerator$.MODULE$.forType$default$2(), RandomDataGenerator$.MODULE$.forType$default$3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$new$9(DataType keyType$1, DataType valueType) {
        return !(keyType$1 instanceof DecimalType);
    }

    public static final /* synthetic */ void $anonfun$new$10(RandomDataGeneratorSuite $this, DataType keyType$1, DataType valueType) {
        MapType mapType = MapType$.MODULE$.apply(keyType$1, valueType);
        $this.test(String.valueOf(mapType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration((DataType)mapType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public static final /* synthetic */ void $anonfun$new$8(RandomDataGeneratorSuite $this, DataType keyType) {
        $this.atomicTypesWithDataGenerators().withFilter((Function1 & Serializable & scala.Serializable)valueType -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$9(keyType, valueType))).foreach((Function1 & Serializable & scala.Serializable)valueType -> {
            RandomDataGeneratorSuite.$anonfun$new$10($this, keyType, valueType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$13(RandomDataGeneratorSuite $this, DataType colOneType$1, DataType colTwoType) {
        StructField structField = new StructField("a", colOneType$1, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("b", colTwoType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        $this.test(String.valueOf(structType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testRandomDataGeneration((DataType)structType, $this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }

    public static final /* synthetic */ void $anonfun$new$12(RandomDataGeneratorSuite $this, DataType colOneType) {
        $this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)colTwoType -> {
            RandomDataGeneratorSuite.$anonfun$new$13($this, colOneType, colTwoType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$16(RandomDataGeneratorSuite $this, MapType mapType$2, int seed) {
        Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)mapType$2, false, new Random(seed)).get();
        Seq maps = (Seq)Seq$.MODULE$.fill(100, (Function0 & Serializable & scala.Serializable)() -> (Map)generator.apply());
        int expectedTotalElements = 50 * RandomDataGenerator$.MODULE$.MAX_MAP_SIZE();
        int deviation = scala.math.package$.MODULE$.abs(BoxesRunTime.unboxToInt((Object)((TraversableOnce)maps.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) - expectedTotalElements);
        double $org_scalatest_assert_macro_left = (double)deviation / (double)expectedTotalElements;
        double $org_scalatest_assert_macro_right = 0.2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    public RandomDataGeneratorSuite() {
        DataTypeTestUtils$.MODULE$.atomicTypes().foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            RandomDataGeneratorSuite.$anonfun$new$1(this, dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.atomicArrayTypes().withFilter((Function1 & Serializable & scala.Serializable)arrayType -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$new$5(arrayType))).foreach((Function1 & Serializable & scala.Serializable)arrayType -> {
            this.test(String.valueOf(arrayType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testRandomDataGeneration((DataType)arrayType, this.testRandomDataGeneration$default$2()), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            return BoxedUnit.UNIT;
        });
        this.atomicTypesWithDataGenerators = (Set)DataTypeTestUtils$.MODULE$.atomicTypes().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RandomDataGeneratorSuite.$anonfun$atomicTypesWithDataGenerators$1(x$1)));
        this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)keyType -> {
            RandomDataGeneratorSuite.$anonfun$new$8(this, keyType);
            return BoxedUnit.UNIT;
        });
        this.atomicTypesWithDataGenerators().foreach((Function1 & Serializable & scala.Serializable)colOneType -> {
            RandomDataGeneratorSuite.$anonfun$new$12(this, colOneType);
            return BoxedUnit.UNIT;
        });
        this.test("check size of generated map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapType mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomDataGeneratorSuite.$anonfun$new$16(this, mapType, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("Use Float.NaN for all NaN values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int bits = -6966608;
            float nan1 = Float.intBitsToFloat(bits);
            float nan2 = RandomDataGenerator$.MODULE$.intBitsToFloat(bits);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.float2Float(nan1).isNaN(), "scala.Predef.float2Float(nan1).isNaN()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.float2Float(nan2).isNaN(), "scala.Predef.float2Float(nan2).isNaN()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            byte[] arrayExpected = ByteBuffer.allocate(4).putFloat(Float.NaN).array();
            byte[] array1 = ByteBuffer.allocate(4).putFloat(nan1).array();
            byte[] array2 = ByteBuffer.allocate(4).putFloat(nan2).array();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Arrays.equals(array1, arrayExpected), "java.util.Arrays.equals(array1, arrayExpected)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Arrays.equals(array2, arrayExpected), "java.util.Arrays.equals(array2, arrayExpected)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("Use Double.NaN for all NaN values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int bits = -6966608;
            double nan1 = Double.longBitsToDouble(bits);
            double nan2 = RandomDataGenerator$.MODULE$.longBitsToDouble(bits);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(nan1).isNaN(), "scala.Predef.double2Double(nan1).isNaN()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(nan2).isNaN(), "scala.Predef.double2Double(nan2).isNaN()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            byte[] arrayExpected = ByteBuffer.allocate(8).putDouble(Double.NaN).array();
            byte[] array1 = ByteBuffer.allocate(8).putDouble(nan1).array();
            byte[] array2 = ByteBuffer.allocate(8).putDouble(nan2).array();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Arrays.equals(array1, arrayExpected), "java.util.Arrays.equals(array1, arrayExpected)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Arrays.equals(array2, arrayExpected), "java.util.Arrays.equals(array2, arrayExpected)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }
}

