/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Entry;
import org.scalatest.FunSpec;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAD\b\u00011!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00039\u0003B\u0002\u0018\u0001A\u0003%\u0001\u0006C\u00040\u0001\t\u0007I\u0011\u0001\u0019\t\ri\u0002\u0001\u0015!\u00032\u0011\u001dY\u0004A1A\u0005\u0002ABa\u0001\u0010\u0001!\u0002\u0013\t\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000f\r\u0003!\u0019!C\u0001}!1A\t\u0001Q\u0001\n}Bq!\u0012\u0001C\u0002\u0013\u0005a\b\u0003\u0004G\u0001\u0001\u0006Ia\u0010\u0002\b%><H+Z:u\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00039U\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005yY\"a\u0002$v]N\u0003Xm\u0019\t\u00035\u0001J!!I\u000e\u0003\u00115\u000bGo\u00195feN\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"A\b\u0002\rM\u001c\u0007.Z7b+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u0010\u0003\u0015!\u0018\u0010]3t\u0013\ti#F\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007%\u0001\u0004wC2,Xm]\u000b\u0002cA\u0019!'N\u001c\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012Q!\u0011:sCf\u0004\"A\r\u001d\n\u0005e\u001a$aA!os\u00069a/\u00197vKN\u0004\u0013!\u0005<bYV,7oV5uQ>,HoQ8mg\u0005\u0011b/\u00197vKN<\u0016\u000e\u001e5pkR\u001cu\u000e\\\u001a!\u0003%\u0019\u0018-\u001c9mKJ{w/F\u0001@!\t)\u0003)\u0003\u0002B\u001f\t\u0019!k\\<\u0002\u0015M\fW\u000e\u001d7f%><\b%\u0001\u000btC6\u0004H.\u001a*po^KG\u000f[8vi\u000e{GnM\u0001\u0016g\u0006l\u0007\u000f\\3S_^<\u0016\u000e\u001e5pkR\u001cu\u000e\\\u001a!\u0003-qwnU2iK6\f'k\\<\u0002\u00199|7k\u00195f[\u0006\u0014vn\u001e\u0011")
public class RowTest
extends FunSpec
implements Matchers {
    private final StructType schema;
    private final Object[] values;
    private final Object[] valuesWithoutCol3;
    private final Row sampleRow;
    private final Row sampleRowWithoutCol3;
    private final Row noSchemaRow;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Object[] values() {
        return this.values;
    }

    public Object[] valuesWithoutCol3() {
        return this.valuesWithoutCol3;
    }

    public Row sampleRow() {
        return this.sampleRow;
    }

    public Row sampleRowWithoutCol3() {
        return this.sampleRowWithoutCol3;
    }

    public Row noSchemaRow() {
        return this.noSchemaRow;
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        RowTest rowTest = this;
        synchronized (rowTest) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    private static final Seq modifyValues$1(Seq values) {
        Object[] array = (Object[])values.toArray(ClassTag$.MODULE$.Any());
        array[2] = "42";
        return Predef$.MODULE$.genericWrapArray((Object)array);
    }

    public RowTest() {
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        StructField structField = new StructField("col1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("col2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("col3", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        this.values = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"value1", "value2", BoxesRunTime.boxToInteger((int)1)}), ClassTag$.MODULE$.Any());
        this.valuesWithoutCol3 = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "value2", null}), ClassTag$.MODULE$.Any());
        this.sampleRow = new GenericRowWithSchema(this.values(), this.schema());
        this.sampleRowWithoutCol3 = new GenericRowWithSchema(this.valuesWithoutCol3(), this.schema());
        this.noSchemaRow = new GenericRow(this.values());
        this.describe("Row (without schema)", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.it().apply("throws an exception when accessing by fieldName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.noSchemaRow().fieldIndex("col1"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            return (UnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Nothing$)this.noSchemaRow().getAs("col1"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40)), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.describe("Row (with schema)", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.it().apply("fieldIndex(name) returns field index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.sampleRow().fieldIndex("col1")), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0));
                return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.sampleRow().fieldIndex("col3")), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            this.it().apply("getAs[T] retrieves a value by fieldname", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToStringShouldWrapper((String)this.sampleRow().getAs("col1"), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).shouldBe((Object)"value1");
                return this.convertToAnyShouldWrapper(this.sampleRow().getAs("col3"), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            this.it().apply("Accessing non existent field throws an exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (String)this.sampleRow().getAs("non_existent"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62)), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.it().apply("getValuesMap() retrieves values of multiple fields as a Map(field -> value)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col1"), (Object)"value1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col2"), (Object)"value2")}));
                return this.convertToAnyShouldWrapper(this.sampleRow().getValuesMap((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$))), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72), Prettifier$.MODULE$.default()).shouldBe((Object)expected);
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.it().apply("getValuesMap() retrieves null value on non AnyVal Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col1"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col2"), (Object)"value2")}));
                return this.convertToAnyShouldWrapper(this.sampleRowWithoutCol3().getValuesMap((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$))), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default()).shouldBe((Object)expected);
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            this.it().apply("getAs() on type extending AnyVal throws an exception when accessing field that is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (NullPointerException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.sampleRowWithoutCol3().getInt(this.sampleRowWithoutCol3().fieldIndex("col3")), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84)), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            this.it().apply("getAs() on type extending AnyVal does not throw exception when value is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.convertToStringShouldWrapper((String)this.sampleRowWithoutCol3().getAs(this.sampleRowWithoutCol3().fieldIndex("col1")), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90), Prettifier$.MODULE$.default()).shouldBe(null, Predef$.MODULE$.$conforms()), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.describe("row equals", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row externalRow = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            Row externalRow2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            InternalRow internalRow2 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            this.it().apply("equality check for external rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(externalRow, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).shouldEqual((Object)externalRow2, Equality$.MODULE$.default()), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            this.it().apply("equality check for internal rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(internalRow, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105), Prettifier$.MODULE$.default()).shouldEqual((Object)internalRow2, Equality$.MODULE$.default()), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.describe("row immutability", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "3", "IV", BoxesRunTime.boxToLong((long)6L)}));
            Row externalRow = Row$.MODULE$.fromSeq(values);
            InternalRow internalRow = InternalRow$.MODULE$.fromSeq(values);
            this.it().apply("copy should return same ref for external rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(externalRow, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default()).should(this.be()).theSameInstanceAs((Object)externalRow.copy(), Predef$.MODULE$.$conforms()), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            this.it().apply("toSeq should not expose internal state for external rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                Seq modifiedValues = RowTest.modifyValues$1(externalRow.toSeq());
                return this.convertToAnyShouldWrapper(externalRow.toSeq(), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126), Prettifier$.MODULE$.default()).should(this.not()).equal((Object)modifiedValues, Equality$.MODULE$.default());
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            this.it().apply("toSeq should not expose internal state for internal rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                Seq modifiedValues = RowTest.modifyValues$1(internalRow.toSeq((Seq)Seq$.MODULE$.empty()));
                return this.convertToAnyShouldWrapper(internalRow.toSeq((Seq)Seq$.MODULE$.empty()), new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).should(this.not()).equal((Object)modifiedValues, Equality$.MODULE$.default());
            }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("RowTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }
}

