/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001A2A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0018\u0001A\u0003%1DA\u000eDCR\fG._:u)f\u0004XmQ8om\u0016\u0014H/\u001a:t'VLG/\u001a\u0006\u0003\r\u001d\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\tQ!A\u0006tS6\u0004H.\u001a+za\u0016\u001cX#A\u000e\u0011\u0007q1\u0013F\u0004\u0002\u001eG9\u0011a$I\u0007\u0002?)\u0011\u0001eD\u0001\u0007yI|w\u000e\u001e \n\u0003\t\nQa]2bY\u0006L!\u0001J\u0013\u0002\u000fA\f7m[1hK*\t!%\u0003\u0002(Q\t\u00191+Z9\u000b\u0005\u0011*\u0003C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\b\u0003\u0015!\u0018\u0010]3t\u0013\tq3F\u0001\u0005ECR\fG+\u001f9f\u00031\u0019\u0018.\u001c9mKRK\b/Z:!\u0001")
public class CatalystTypeConvertersSuite
extends SparkFunSuite {
    private final Seq<DataType> simpleTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, DateType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, DecimalType$.MODULE$.SYSTEM_DEFAULT(), DecimalType$.MODULE$.USER_DEFAULT()}));

    private Seq<DataType> simpleTypes() {
        return this.simpleTypes;
    }

    public CatalystTypeConvertersSuite() {
        this.test("null handling in rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((Seq)this.simpleTypes().map((Function1 & Serializable & scala.Serializable)t -> new StructField(t.getClass().getName(), t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
            Function1 convertToCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)schema);
            Function1 convertToScala = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema);
            Row scalaRow = Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(this.simpleTypes().length(), (Function0 & Serializable & scala.Serializable)() -> null));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(convertToScala.apply(convertToCatalyst.apply((Object)scalaRow)));
            Row $org_scalatest_assert_macro_right = scalaRow;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("null handling for individual values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.simpleTypes().foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter(dataType).apply(null));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("option handling in convertToCatalyst", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)123));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("option handling in createToCatalystConverter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)IntegerType$.MODULE$).apply((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("primitive array handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int[] intArray = new int[]{1, 100, 10000};
            UnsafeArrayData intUnsafeArray = UnsafeArrayData.fromPrimitiveArray((int[])intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intUnsafeArray));
            int[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            double[] doubleArray = new double[]{1.1, 111.1, 11111.1};
            UnsafeArrayData doubleUnsafeArray = UnsafeArrayData.fromPrimitiveArray((double[])doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleUnsafeArray));
            double[] $org_scalatest_assert_macro_right2 = doubleArray;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("An array with null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object[] intArray = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), null, BoxesRunTime.boxToInteger((int)10000)}), ClassTag$.MODULE$.Any());
            GenericArrayData intGenericArray = new GenericArrayData(intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intGenericArray));
            Object[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Object $org_scalatest_assert_macro_left2 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)intArrayType).apply((Object)intArray);
            GenericArrayData $org_scalatest_assert_macro_right2 = intGenericArray;
            Object object = $org_scalatest_assert_macro_left2;
            GenericArrayData genericArrayData = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(object != null ? !object.equals(genericArrayData) : genericArrayData != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Object[] doubleArray = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.1), null, BoxesRunTime.boxToDouble((double)111.1), null, BoxesRunTime.boxToDouble((double)11111.1)}), ClassTag$.MODULE$.Any());
            GenericArrayData doubleGenericArray = new GenericArrayData(doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleGenericArray));
            Object[] $org_scalatest_assert_macro_right3 = doubleArray;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Object $org_scalatest_assert_macro_left4 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)doubleArrayType).apply((Object)doubleArray);
            GenericArrayData $org_scalatest_assert_macro_right4 = doubleGenericArray;
            Object object2 = $org_scalatest_assert_macro_left4;
            GenericArrayData genericArrayData2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(object2 != null ? !object2.equals(genericArrayData2) : genericArrayData2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("converting a wrong value to the struct type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType structType = new StructType().add("f1", (DataType)IntegerType$.MODULE$);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)structType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to struct<f1:int>";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("converting a wrong value to the map type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MapType mapType = new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)mapType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to a map type with key type (string) and value type (int)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("converting a wrong value to the array type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ArrayType arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)arrayType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to an array of int";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("converting a wrong value to the decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecimalType decimalType = new DecimalType(10, 0);
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)decimalType).apply((Object)"test"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (test) of the type (java.lang.String) cannot be converted to decimal(10,0)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("converting a wrong value to the string type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$).apply((Object)BoxesRunTime.boxToDouble((double)0.1)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "The value (0.1) of the type (java.lang.Double) cannot be converted to the string type";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("SPARK-24571: convert Char to String", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            char chr = 'X';
            Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$);
            UTF8String expected = UTF8String.fromString((String)"X");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(converter.apply((Object)BoxesRunTime.boxToCharacter((char)chr)));
            UTF8String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }
}

