/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.TestRelation;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193Aa\u0003\u0007\u00013!)!\u0005\u0001C\u0001G!9Q\u0005\u0001b\u0001\n\u00031\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0014\t\r1\u0002\u0001\u0015!\u0003(\u0011\u001di\u0003A1A\u0005\u0002\u0019BaA\f\u0001!\u0002\u00139\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B!\u0001\t\u0003\u0011\u0005\"\u0002#\u0001\t\u0003)%!\u0007#bi\u0006\u001cv.\u001e:dKZ\u0013\u0014I\\1msNL7oU;ji\u0016T!!\u0004\b\u0002\u0011\u0005t\u0017\r\\=tSNT!a\u0004\t\u0002\u0011\r\fG/\u00197zgRT!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000e\u001f!\tYB$D\u0001\u0013\u0013\ti\"CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003?\u0001j\u0011\u0001D\u0005\u0003C1\u0011A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005}\u0001\u0011!\u0002;bE2,W#A\u0014\u0011\u0005}A\u0013BA\u0015\r\u00051!Vm\u001d;SK2\fG/[8o\u0003\u0019!\u0018M\u00197fA\u0005i!/Z9vSJ,G\rV1cY\u0016\faB]3rk&\u0014X\r\u001a+bE2,\u0007%\u0001\u0006xS\u0012,'\u000fV1cY\u0016\f1b^5eKJ$\u0016M\u00197fA\u0005\t\u0012m]:feRtu\u000e\u001e*fg>dg/\u001a3\u0015\u0005E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRDQ\u0001\u000f\u0005A\u0002e\n1\u0002\\8hS\u000e\fG\u000e\u00157b]B\u0011!hP\u0007\u0002w)\u0011A(P\u0001\bY><\u0017nY1m\u0015\tqd\"A\u0003qY\u0006t7/\u0003\u0002Aw\tYAj\\4jG\u0006d\u0007\u000b\\1o\u00039\t7o]3siJ+7o\u001c7wK\u0012$\"!M\"\t\u000baJ\u0001\u0019A\u001d\u0002\u000fQ|Gj\\<feR\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013:\t1\"\u001a=qe\u0016\u001c8/[8og&\u00111\n\u0013\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW\rC\u0003N\u0015\u0001\u0007a)\u0001\u0003biR\u0014\b")
public class DataSourceV2AnalysisSuite
extends SparkFunSuite
implements AnalysisTest {
    private final TestRelation table;
    private final TestRelation requiredTable;
    private final TestRelation widerTable;
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest.getAnalyzer$(this, caseSensitive);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    @Override
    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    public TestRelation table() {
        return this.table;
    }

    public TestRelation requiredTable() {
        return this.requiredTable;
    }

    public TestRelation widerTable() {
        return this.widerTable;
    }

    public void assertNotResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Plan should not be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }

    public void assertResolved(LogicalPlan logicalPlan) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(logicalPlan.resolved(), "logicalPlan.resolved", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(25).append("Plan should be resolved: ").append(logicalPlan).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
    }

    public AttributeReference toLower(AttributeReference attr) {
        String x$1 = attr.name().toLowerCase(Locale.ROOT);
        DataType x$2 = attr.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = attr.exprId();
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public DataSourceV2AnalysisSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.table = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.requiredTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
        this.test("Append.byName: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)this.table().schema().toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)parsedPlan, this.checkAnalysis$default$3());
            this.assertResolved((LogicalPlan)parsedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("Append.byName: does not match by position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Append.byName: case sensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), true);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Append.byName: case insensitive column resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("X", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference X = (AttributeReference)query.output().head();
            AttributeReference y = (AttributeReference)query.output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$1 = new Cast((Expression)this.toLower(X), (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$2 = "x";
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
            Cast x$6 = new Cast((Expression)y, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$7 = "y";
            ExprId x$8 = Alias$.MODULE$.apply$default$3((Expression)x$6, x$7);
            Seq x$9 = Alias$.MODULE$.apply$default$4((Expression)x$6, x$7);
            Option x$10 = Alias$.MODULE$.apply$default$5((Expression)x$6, x$7);
            aliasArray[1] = new Alias((Expression)x$6, x$7, x$8, x$9, x$10);
            AppendData expectedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, false);
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Append.byName: data columns are reordered by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$11 = new Cast((Expression)x, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$12 = "x";
            ExprId x$13 = Alias$.MODULE$.apply$default$3((Expression)x$11, x$12);
            Seq x$14 = Alias$.MODULE$.apply$default$4((Expression)x$11, x$12);
            Option x$15 = Alias$.MODULE$.apply$default$5((Expression)x$11, x$12);
            aliasArray[0] = new Alias((Expression)x$11, x$12, x$13, x$14, x$15);
            Cast x$16 = new Cast((Expression)y, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$17 = "y";
            ExprId x$18 = Alias$.MODULE$.apply$default$3((Expression)x$16, x$17);
            Seq x$19 = Alias$.MODULE$.apply$default$4((Expression)x$16, x$17);
            Option x$20 = Alias$.MODULE$.apply$default$5((Expression)x$16, x$17);
            aliasArray[1] = new Alias((Expression)x$16, x$17, x$18, x$19, x$20);
            AppendData expectedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Append.byName: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.requiredTable(), (LogicalPlan)this.table());
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot write nullable values to non-null column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Append.byName: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)this.requiredTable());
            this.assertResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)parsedPlan, this.checkAnalysis$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("Append.byName: missing required columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.requiredTable(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("Append.byName: missing optional columns cause failure and are identified by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot find data for output column", "'x'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("Append.byName: fail canWrite check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)this.widerTable());
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "Cannot safely cast", "'x'", "'y'", "DoubleType to FloatType"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("Append.byName: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.widerTable(), (LogicalPlan)this.table());
            Alias[] aliasArray = new Alias[2];
            Cast x$21 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$22 = "x";
            ExprId x$23 = Alias$.MODULE$.apply$default$3((Expression)x$21, x$22);
            Seq x$24 = Alias$.MODULE$.apply$default$4((Expression)x$21, x$22);
            Option x$25 = Alias$.MODULE$.apply$default$5((Expression)x$21, x$22);
            aliasArray[0] = new Alias((Expression)x$21, x$22, x$23, x$24, x$25);
            Cast x$26 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$27 = "y";
            ExprId x$28 = Alias$.MODULE$.apply$default$3((Expression)x$26, x$27);
            Seq x$29 = Alias$.MODULE$.apply$default$4((Expression)x$26, x$27);
            Option x$30 = Alias$.MODULE$.apply$default$5((Expression)x$26, x$27);
            aliasArray[1] = new Alias((Expression)x$26, x$27, x$28, x$29, x$30);
            AppendData expectedPlan = AppendData$.MODULE$.byName((NamedRelation)this.widerTable(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)this.table()));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("Append.byName: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("z", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "too many data columns", "Table columns: 'x', 'y'", "Data columns: 'x', 'y', 'z'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("Append.byName: multiple field errors are reported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation xRequiredTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)xRequiredTable, (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot safely cast", "'x'", "DoubleType to FloatType", "Cannot write nullable values to non-null column", "'x'", "Cannot find data for output column", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("Append.byPosition: basic behavior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference a = (AttributeReference)query.output().head();
            AttributeReference b = (AttributeReference)query.output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$31 = new Cast((Expression)a, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$32 = "x";
            ExprId x$33 = Alias$.MODULE$.apply$default$3((Expression)x$31, x$32);
            Seq x$34 = Alias$.MODULE$.apply$default$4((Expression)x$31, x$32);
            Option x$35 = Alias$.MODULE$.apply$default$5((Expression)x$31, x$32);
            aliasArray[0] = new Alias((Expression)x$31, x$32, x$33, x$34, x$35);
            Cast x$36 = new Cast((Expression)b, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$37 = "y";
            ExprId x$38 = Alias$.MODULE$.apply$default$3((Expression)x$36, x$37);
            Seq x$39 = Alias$.MODULE$.apply$default$4((Expression)x$36, x$37);
            Option x$40 = Alias$.MODULE$.apply$default$5((Expression)x$36, x$37);
            aliasArray[1] = new Alias((Expression)x$36, x$37, x$38, x$39, x$40);
            AppendData expectedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, false);
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("Append.byPosition: data columns are not reordered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("x", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference y = (AttributeReference)query.output().head();
            AttributeReference x = (AttributeReference)query.output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)query);
            Alias[] aliasArray = new Alias[2];
            Cast x$41 = new Cast((Expression)y, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$42 = "x";
            ExprId x$43 = Alias$.MODULE$.apply$default$3((Expression)x$41, x$42);
            Seq x$44 = Alias$.MODULE$.apply$default$4((Expression)x$41, x$42);
            Option x$45 = Alias$.MODULE$.apply$default$5((Expression)x$41, x$42);
            aliasArray[0] = new Alias((Expression)x$41, x$42, x$43, x$44, x$45);
            Cast x$46 = new Cast((Expression)x, (DataType)FloatType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$47 = "y";
            ExprId x$48 = Alias$.MODULE$.apply$default$3((Expression)x$46, x$47);
            Seq x$49 = Alias$.MODULE$.apply$default$4((Expression)x$46, x$47);
            Option x$50 = Alias$.MODULE$.apply$default$5((Expression)x$46, x$47);
            aliasArray[1] = new Alias((Expression)x$46, x$47, x$48, x$49, x$50);
            AppendData expectedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)query));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("Append.byPosition: fail nullable data written to required columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.requiredTable(), (LogicalPlan)this.table());
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot write nullable values to non-null column", "'x'", "'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("Append.byPosition: allow required data written to nullable columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)this.requiredTable());
            this.assertResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)parsedPlan, this.checkAnalysis$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("Append.byPosition: missing required columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.requiredTable(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "not enough data columns", "Table columns: 'x', 'y'", "Data columns: 'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("Append.byPosition: missing optional columns cause failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("y", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "not enough data columns", "Table columns: 'x', 'y'", "Data columns: 'y'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("Append.byPosition: fail canWrite check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)this.table(), (LogicalPlan)widerTable);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "Cannot safely cast", "'x'", "'y'", "DoubleType to FloatType"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        this.test("Append.byPosition: insert safe cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation widerTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AttributeReference x = (AttributeReference)this.table().output().head();
            AttributeReference y = (AttributeReference)this.table().output().last();
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)widerTable, (LogicalPlan)this.table());
            Alias[] aliasArray = new Alias[2];
            Cast x$51 = new Cast((Expression)x, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$52 = "a";
            ExprId x$53 = Alias$.MODULE$.apply$default$3((Expression)x$51, x$52);
            Seq x$54 = Alias$.MODULE$.apply$default$4((Expression)x$51, x$52);
            Option x$55 = Alias$.MODULE$.apply$default$5((Expression)x$51, x$52);
            aliasArray[0] = new Alias((Expression)x$51, x$52, x$53, x$54, x$55);
            Cast x$56 = new Cast((Expression)y, (DataType)DoubleType$.MODULE$, (Option)new Some((Object)this.conf().sessionLocalTimeZone()));
            String x$57 = "b";
            ExprId x$58 = Alias$.MODULE$.apply$default$3((Expression)x$56, x$57);
            Seq x$59 = Alias$.MODULE$.apply$default$4((Expression)x$56, x$57);
            Option x$60 = Alias$.MODULE$.apply$default$5((Expression)x$56, x$57);
            aliasArray[1] = new Alias((Expression)x$56, x$57, x$58, x$59, x$60);
            AppendData expectedPlan = AppendData$.MODULE$.byPosition((NamedRelation)widerTable, (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)this.table()));
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.checkAnalysis((LogicalPlan)parsedPlan, (LogicalPlan)expectedPlan, this.checkAnalysis$default$3());
            this.assertResolved((LogicalPlan)expectedPlan);
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("Append.byPosition: fail extra data fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byName((NamedRelation)this.table(), (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write", "'table-name'", "too many data columns", "Table columns: 'x', 'y'", "Data columns: 'a', 'b', 'c'"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("Append.byPosition: multiple field errors are reported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestRelation xRequiredTable = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)FloatType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            TestRelation query = new TestRelation((Seq<AttributeReference>)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))).toAttributes());
            AppendData parsedPlan = AppendData$.MODULE$.byPosition((NamedRelation)xRequiredTable, (LogicalPlan)query);
            this.assertNotResolved((LogicalPlan)parsedPlan);
            this.assertAnalysisError((LogicalPlan)parsedPlan, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write incompatible data to table", "'table-name'", "Cannot write nullable values to non-null column", "'x'", "Cannot safely cast", "'x'", "DoubleType to FloatType"}))), this.assertAnalysisError$default$3());
        }, new Position("DataSourceV2AnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
    }
}

