/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.TestRelations$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t\t\"+Z:pYZ,\u0007*\u001b8ugN+\u0018\u000e^3\u000b\u0005\u0011)\u0011\u0001C1oC2L8/[:\u000b\u0005\u00199\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tR\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AF\f\u000e\u0003\rI!\u0001G\u0002\u0003\u0019\u0005s\u0017\r\\=tSN$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0001")
public class ResolveHintsSuite
extends SparkFunSuite
implements AnalysisTest {
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest.getAnalyzer$(this, caseSensitive);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    @Override
    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    public ResolveHintsSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("invalid hints should be ignored", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("some_random_hint_that_does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("case-sensitive or insensitive parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), true);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), true);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("multiple broadcast hint aliases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table"));
            LogicalPlan x$1 = package.plans$.MODULE$.table("table2");
            JoinType x$2 = qual$1.join$default$2();
            Option x$3 = qual$1.join$default$3();
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$1.join(x$1, x$2, x$3)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo(true)), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), false);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("do not traverse past existing broadcast hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), (LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo(true))), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo(true))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("should work for subqueries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).as("tableAlias")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).as("tableAlias")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false);
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("do not traverse past subquery alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery((Symbol)SymbolLiteral.bootstrap("apply", "tableAlias"))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("should work for CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(ctetable) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new HintInfo(true))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("should not traverse down CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(table) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze(), false), new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("coalesce and repartition hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new Repartition(10, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("coalesce", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20))})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new Repartition(20, false, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new Repartition(100, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            this.checkAnalysis((LogicalPlan)new UnresolvedHint("RePARTITion", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)200))})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new Repartition(200, true, (LogicalPlan)TestRelations$.MODULE$.testRelation()), this.checkAnalysis$default$3());
            String errMsgCoal = "COALESCE Hint expects a partition number as parameter";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.empty(), package.plans$.MODULE$.table("TaBlE")), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsgCoal}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))})), package.plans$.MODULE$.table("TaBlE")), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsgCoal}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0))})), package.plans$.MODULE$.table("TaBlE")), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsgCoal}))), this.assertAnalysisError$default$3());
            String errMsgRepa = "REPARTITION Hint expects a partition number as parameter";
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.apply("a")})), package.plans$.MODULE$.table("TaBlE")), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsgRepa}))), this.assertAnalysisError$default$3());
            this.assertAnalysisError((LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))})), package.plans$.MODULE$.table("TaBlE")), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{errMsgRepa}))), this.assertAnalysisError$default$3());
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }
}

