/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.encoders.ArrayClass;
import org.apache.spark.sql.catalyst.encoders.ComplexClass;
import org.apache.spark.sql.catalyst.encoders.EncoderResolutionSuite$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.encoders.NestedArrayClass;
import org.apache.spark.sql.catalyst.encoders.PrimitiveArrayClass;
import org.apache.spark.sql.catalyst.encoders.StringLongClass;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I4AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0003/\u0001\u0011%q\u0006C\u0003f\u0001\u0011%aM\u0001\fF]\u000e|G-\u001a:SKN|G.\u001e;j_:\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0005f]\u000e|G-\u001a:t\u0015\tQ1\"\u0001\u0005dCR\fG._:u\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Q#\u0007\t\u0003-]i\u0011!D\u0005\u000315\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\n\u0003\u0015\u0001H.\u00198t\u0013\tq2D\u0001\u0005QY\u0006tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\tq!A\u0002tiJ,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\nQ\u0001^=qKNT!AK\u0007\u0002\rUt7/\u00194f\u0013\tasE\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fAa\u001d;sA\u0005Y1-Y:u'V\u001c7-Z:t+\r\u0001dk\u0019\u000b\u0004c]z\u0006C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRDq\u0001\u000f\u0003\u0002\u0002\u0003\u000f\u0011(\u0001\u0006fm&$WM\\2fIE\u00022A\u000f(U\u001d\tY4J\u0004\u0002=\u0011:\u0011Q(\u0012\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!Q\n\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001#4\u0003\u001d\u0011XM\u001a7fGRL!AR$\u0002\u000fI,h\u000e^5nK*\u0011AiM\u0005\u0003\u0013*\u000bq\u0001]1dW\u0006<WM\u0003\u0002G\u000f&\u0011A*T\u0001\tk:Lg/\u001a:tK*\u0011\u0011JS\u0005\u0003\u001fB\u0013q\u0001V=qKR\u000bw-\u0003\u0002R%\nAA+\u001f9f)\u0006<7O\u0003\u0002T\u000f\u0006\u0019\u0011\r]5\u0011\u0005U3F\u0002\u0001\u0003\u0006/\u0012\u0011\r\u0001\u0017\u0002\u0002)F\u0011\u0011\f\u0018\t\u0003eiK!aW\u001a\u0003\u000f9{G\u000f[5oOB\u0011!'X\u0005\u0003=N\u00121!\u00118z\u0011\u001d\u0001G!!AA\u0004\u0005\f!\"\u001a<jI\u0016t7-\u001a\u00133!\rQdJ\u0019\t\u0003+\u000e$Q\u0001\u001a\u0003C\u0002a\u0013\u0011!V\u0001\tG\u0006\u001cHOR1jYV\u0019q\r\\9\u0015\u0007EBW\u000eC\u0004j\u000b\u0005\u0005\t9\u00016\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002;\u001d.\u0004\"!\u00167\u0005\u000b]+!\u0019\u0001-\t\u000f9,\u0011\u0011!a\u0002_\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007ir\u0005\u000f\u0005\u0002Vc\u0012)A-\u0002b\u00011\u0002")
public class EncoderResolutionSuite
extends SparkFunSuite
implements PlanTest {
    private final UTF8String str;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    private UTF8String str() {
        return this.str;
    }

    private <T, U> void castSuccess(TypeTags.TypeTag<T> evidence$1, TypeTags.TypeTag<U> evidence$2) {
        ExpressionEncoder from = ExpressionEncoder$.MODULE$.apply(evidence$1);
        ExpressionEncoder to = ExpressionEncoder$.MODULE$.apply(evidence$2);
        String catalystType = ((StructField)from.schema().head()).dataType().simpleString();
        this.test(new StringBuilder(29).append("cast from ").append(catalystType).append(" to ").append(((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly(evidence$2)).tpe()).append(" should success").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> to.resolveAndBind(from.schema().toAttributes(), to.resolveAndBind$default$2()), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
    }

    private <T, U> void castFail(TypeTags.TypeTag<T> evidence$3, TypeTags.TypeTag<U> evidence$4) {
        ExpressionEncoder from = ExpressionEncoder$.MODULE$.apply(evidence$3);
        ExpressionEncoder to = ExpressionEncoder$.MODULE$.apply(evidence$4);
        String catalystType = ((StructField)from.schema().head()).dataType().simpleString();
        this.test(new StringBuilder(26).append("cast from ").append(catalystType).append(" to ").append(((TypeTags.WeakTypeTag)Predef$.MODULE$.implicitly(evidence$4)).tpe()).append(" should fail").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> to.resolveAndBind(from.schema().toAttributes(), to.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256)), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
    }

    public EncoderResolutionSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.str = UTF8String.fromString((String)"hello");
        this.test("real type doesn't match encoder schema but they are compatible: product", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.StringLongClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator1$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator1$1(null)));
            Seq attrs1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            encoder.resolveAndBind(attrs1, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.str(), BoxesRunTime.boxToInteger((int)1)})));
            Seq attrs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long()}));
            return (StringLongClass)encoder.resolveAndBind(attrs2, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L)})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("real type doesn't match encoder schema but they are compatible: nested product", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.ComplexClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator2$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator2$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long()}))}));
            return (ComplexClass)encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L)}))})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("real type doesn't match encoder schema but they are compatible: tupled encoder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.StringLongClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator3$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.tuple(ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator3$1(null))), ExpressionEncoder$.MODULE$.apply(((TypeTags)package$.MODULE$.universe()).TypeTag().Long()));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).byte()})), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
            return (Tuple2)encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.str(), BoxesRunTime.boxToByte((byte)((byte)1))})), BoxesRunTime.boxToInteger((int)2)})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("real type doesn't match encoder schema but they are compatible: primitive array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.PrimitiveArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator4$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator4$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arr")).array((DataType)IntegerType$.MODULE$)}));
            GenericArrayData array = new GenericArrayData(new int[]{1, 2, 3});
            return (PrimitiveArrayClass)encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("the real type is not compatible with encoder schema: primitive array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.PrimitiveArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator5$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator5$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arr")).array((DataType)StringType$.MODULE$)}));
            String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81))).message();
            String $org_scalatest_assert_macro_right = new StringBuilder(34).append(new StringOps(Predef$.MODULE$.augmentString("\n         |Cannot up cast array element from string to bigint as it may truncate\n         |The type path of the target object is:\n         |- array element class: \"scala.Long\"\n         |- field (class: \"scala.Array\", name: \"arr\")\n         |- root class: \"org.apache.spark.sql.catalyst.encoders.PrimitiveArrayClass\"\n         |You can either add an explicit cast to the input data or choose a higher precision type\n       ")).stripMargin().trim()).append(" of the field in the target object").toString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("real type doesn't match encoder schema but they are compatible: array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.ArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator6$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator6$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arr")).array((DataType)new StructType().add("a", "int").add("b", "int").add("c", "int"))}));
            GenericArrayData array = new GenericArrayData((Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))});
            return (ArrayClass)encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("real type doesn't match encoder schema but they are compatible: nested array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator7$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.NestedArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator7$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator7$1(null)));
            StructType et = new StructType().add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("a", "int").add("b", "int").add("c", "int")));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "nestedArr")).array((DataType)et)}));
            GenericArrayData innerArr = new GenericArrayData((Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))});
            GenericArrayData outerArr = new GenericArrayData((Object)new InternalRow[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{innerArr}))});
            return (NestedArrayClass)encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()).fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outerArr})));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("the real type is not compatible with encoder schema: non-array field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator8$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.ArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator8$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator8$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arr")).int()}));
            String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112))).message();
            String $org_scalatest_assert_macro_right = "need an array field but got int";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("the real type is not compatible with encoder schema: array element type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.ArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator9$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator9$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arr")).array((DataType)new StructType().add("c", "int"))}));
            String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119))).message();
            String $org_scalatest_assert_macro_right = "No such struct field a in c";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("the real type is not compatible with encoder schema: nested array element type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.catalyst.encoders.NestedArrayClass").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator10$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator10$1(null)));
            this.withClue("inner element is not array", (Function0 & Serializable & scala.Serializable)() -> {
                Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "nestedArr")).array((DataType)new StructType().add("arr", "int"))}));
                String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128))).message();
                String $org_scalatest_assert_macro_right = "need an array field but got int";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            });
            return (Assertion)this.withClue("nested array element type is not compatible", (Function0 & Serializable & scala.Serializable)() -> {
                Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "nestedArr")).array((DataType)new StructType().add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", "int"))))}));
                String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).message();
                String $org_scalatest_assert_macro_right = "No such struct field a in c";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            });
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("nullability of array type element should not fail analysis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator11$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator11$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator11$1(null)));
            AttributeReference attributeReference = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).array((DataType)IntegerType$.MODULE$);
            List attrs = Nil$.MODULE$.$colon$colon((Object)attributeReference);
            ExpressionEncoder bound = encoder.resolveAndBind((Seq)attrs, encoder.resolveAndBind$default$2());
            bound.fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData(new int[]{1, 2})})));
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Seq)bound.fromRow(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}), ClassTag$.MODULE$.Any()))}))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("the real number of fields doesn't match encoder schema: tuple encoder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator12$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator12$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator12$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
            String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))).message();
            String $org_scalatest_assert_macro_right = "Try to map struct<a:string,b:bigint,c:int> to Tuple2, but failed as the number of fields does not line up.";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Seq attrs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string()}));
            String $org_scalatest_assert_macro_left2 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs2, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169))).message();
            String $org_scalatest_assert_macro_right2 = "Try to map struct<a:string> to Tuple2, but failed as the number of fields does not line up.";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("the real number of fields doesn't match encoder schema: nested tuple encoder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator13$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator13$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator13$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "y")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "z")).int()}))}));
            String $org_scalatest_assert_macro_left = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180))).message();
            String $org_scalatest_assert_macro_right = "Try to map struct<x:bigint,y:string,z:int> to Tuple2, but failed as the number of fields does not line up.";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Seq attrs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).long()}))}));
            String $org_scalatest_assert_macro_left2 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> encoder.resolveAndBind(attrs2, encoder.resolveAndBind$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187))).message();
            String $org_scalatest_assert_macro_right2 = "Try to map struct<x:bigint> to Tuple2, but failed as the number of fields does not line up.";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("nested case class can have different number of fields from the real schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator14$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.sql.catalyst.encoders.StringIntClass").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator14$1(EncoderResolutionSuite $outer) {
                }
            }
            ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator14$1(null)));
            Seq attrs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))}));
            return encoder.resolveAndBind(attrs, encoder.resolveAndBind$default$2());
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("throw exception if real type is not compatible with encoder schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String msg2;
            String msg1;
            String $org_scalatest_assert_macro_left = msg1 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator15$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.catalyst.encoders.StringIntClass").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator15$1(EncoderResolutionSuite $outer) {
                    }
                }
                ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator15$1(null)));
                Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).long()}));
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                return qual$1.resolveAndBind(x$1, x$2);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200))).message();
            String $org_scalatest_assert_macro_right = new StringBuilder(34).append(new StringOps(Predef$.MODULE$.augmentString("\n         |Cannot up cast `b` from bigint to int as it may truncate\n         |The type path of the target object is:\n         |- field (class: \"scala.Int\", name: \"b\")\n         |- root class: \"org.apache.spark.sql.catalyst.encoders.StringIntClass\"\n         |You can either add an explicit cast to the input data or choose a higher precision type\n       ")).stripMargin().trim()).append(" of the field in the target object").toString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            String $org_scalatest_assert_macro_left2 = msg2 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                StructType structType = new StructType().add("a", (DataType)StringType$.MODULE$).add("b", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.catalyst.encoders.ComplexClass").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator16$1(EncoderResolutionSuite $outer) {
                    }
                }
                ExpressionEncoder qual$2 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator16$1(null)));
                Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).long(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).struct(structType)}));
                Analyzer x$4 = qual$2.resolveAndBind$default$2();
                return qual$2.resolveAndBind(x$3, x$4);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212))).message();
            String $org_scalatest_assert_macro_right2 = new StringBuilder(34).append(new StringOps(Predef$.MODULE$.augmentString("\n         |Cannot up cast `b`.`b` from decimal(38,18) to bigint as it may truncate\n         |The type path of the target object is:\n         |- field (class: \"scala.Long\", name: \"b\")\n         |- field (class: \"org.apache.spark.sql.catalyst.encoders.StringLongClass\", name: \"b\")\n         |- root class: \"org.apache.spark.sql.catalyst.encoders.ComplexClass\"\n         |You can either add an explicit cast to the input data or choose a higher precision type\n       ")).stripMargin().trim()).append(" of the field in the target object").toString();
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }, new Position("EncoderResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.castSuccess(((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator17$1(EncoderResolutionSuite $outer) {
            }
        }
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator18$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castSuccess(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator17$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator18$1(null)));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator19$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castSuccess(((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator19$1(null)));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator20$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castSuccess(((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator20$1(null)));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator21$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castSuccess(((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator21$1(null)));
        this.castFail(((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator22$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator22$1(EncoderResolutionSuite $outer) {
            }
        }
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator23$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Date").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator23$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castFail(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator22$1(null)), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator23$1(null)));
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator24$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator24$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castFail(((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator24$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator25$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castFail(((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator25$1(null)));
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator26$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castFail(((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator26$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u11 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m11 = package$.MODULE$.universe().runtimeMirror(EncoderResolutionSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator27$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator27$1(EncoderResolutionSuite $outer) {
            }
        }
        this.castFail(((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_apache_spark_sql_catalyst_encoders_EncoderResolutionSuite$$typecreator27$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
    }
}

