/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Crc32;
import org.apache.spark.sql.catalyst.expressions.Crc32$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.HiveHashFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Md5;
import org.apache.spark.sql.catalyst.expressions.Md5$;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Sha1;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.Sha2;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateMutableProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.enablers.CheckerAsserting;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscarded$;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MaxSize$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfig$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.GeneratorDrivenPropertyChecks;
import org.scalatest.prop.Whenever;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001=4Aa\u0005\u000b\u0001C!)!\u0006\u0001C\u0001W!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\nQCaA\u0017\u0001!\u0002\u0013)\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007A\u0002\u0001\u000b\u0011B/\t\u000f\u0005\u0004!\u0019!C\u00059\"1!\r\u0001Q\u0001\nuCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003]\u0011\u0019Q\u0007\u0001)A\u0005;\")1\u000e\u0001C\u0005Y\n!\u0002*Y:i\u000bb\u0004(/Z:tS>t7oU;ji\u0016T!!\u0006\f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003/a\t\u0001bY1uC2L8\u000f\u001e\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0004\u0001\t2\u0003CA\u0012%\u001b\u0005Q\u0012BA\u0013\u001b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011q\u0005K\u0007\u0002)%\u0011\u0011\u0006\u0006\u0002\u0015\u000bb\u0004(/Z:tS>tWI^1m\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0014\u0001\u0003\u0019\u0011\u0018M\u001c3p[V\tq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!Q\u000f^5m\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c2\u0005\u0019\u0011\u0016M\u001c3p[\u00069!/\u00198e_6\u0004\u0013!D2iK\u000e\\\u0007*\u001b<f\u0011\u0006\u001c\b\u000e\u0006\u0003;}\r[\u0005CA\u001e=\u001b\u0005\u0019\u0014BA\u001f4\u0005\u0011)f.\u001b;\t\u000b}\"\u0001\u0019\u0001!\u0002\u000b%t\u0007/\u001e;\u0011\u0005m\n\u0015B\u0001\"4\u0005\r\te.\u001f\u0005\u0006\t\u0012\u0001\r!R\u0001\tI\u0006$\u0018\rV=qKB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nG\u0001\u0006if\u0004Xm]\u0005\u0003\u0015\u001e\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0019\u0012\u0001\r!T\u0001\tKb\u0004Xm\u0019;fIB\u00111HT\u0005\u0003\u001fN\u0012A\u0001T8oO\u0006a2\r[3dW\"Kg/\u001a%bg\"4uN]%oi\u0016<'/\u00197UsB,GC\u0001\u001eS\u0011\u0015!U\u00011\u0001F\u00039\u0019HO];di>37\u000b\u001e:j]\u001e,\u0012!\u0016\t\u0003\rZK!aV$\u0003\u0015M#(/^2u)f\u0004X-A\btiJ,8\r^(g'R\u0014\u0018N\\4!\u0003-\u0019HO];di>3W\u000b\u0012+\u0002\u0019M$(/^2u\u001f\u001a,F\t\u0016\u0011\u0002\u001b\u0005\u0014(/Y=PMN#(/\u001b8h+\u0005i\u0006C\u0001$_\u0013\tyvIA\u0005BeJ\f\u0017\u0010V=qK\u0006q\u0011M\u001d:bs>37\u000b\u001e:j]\u001e\u0004\u0013aC1se\u0006LxJ\u001a(vY2\fA\"\u0019:sCf|eMT;mY\u0002\n1\"\\1q\u001f\u001a\u001cFO]5oOV\tQ\r\u0005\u0002GM&\u0011qm\u0012\u0002\b\u001b\u0006\u0004H+\u001f9f\u00031i\u0017\r](g'R\u0014\u0018N\\4!\u0003)\t'O]1z\u001f\u001a,F\tV\u0001\fCJ\u0014\u0018-_(g+\u0012#\u0006%\u0001\u0005uKN$\b*Y:i)\tQT\u000eC\u0003o%\u0001\u0007Q+A\u0006j]B,HoU2iK6\f\u0007")
public class HashExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private final Random random;
    private final StructType structOfString;
    private final StructType structOfUDT;
    private final ArrayType arrayOfString;
    private final ArrayType arrayOfNull;
    private final MapType mapOfString;
    private final ArrayType arrayOfUDT;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfig$ PropertyCheckConfig$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscarded$ MaxDiscarded$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$MaxSize$ MaxSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$1);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$2);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public package.Projection generateProject(Function0<package.Projection> generator, Expression expression) {
        return ExpressionEvalHelper.generateProject$(this, generator, expression);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithGeneratedMutableProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithGeneratedMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithGeneratedMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithGeneratedMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithGeneratedMutableProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithGeneratedMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithGeneratedMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithGeneratedMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public GeneratorDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Configuration.PropertyCheckConfiguration PropertyCheckConfig2PropertyCheckConfiguration(Configuration.PropertyCheckConfig p) {
        return Configuration.PropertyCheckConfig2PropertyCheckConfiguration$((Configuration)this, (Configuration.PropertyCheckConfig)p);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscarded maxDiscarded(int value) {
        return Configuration.maxDiscarded$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.MaxSize maxSize(int value) {
        return Configuration.maxSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Test.Parameters getParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable c) {
        return Configuration.getParams$((Configuration)this, configParams, (Configuration.PropertyCheckConfigurable)c);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfig$ PropertyCheckConfig() {
        if (this.PropertyCheckConfig$module == null) {
            this.PropertyCheckConfig$lzycompute$1();
        }
        return this.PropertyCheckConfig$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscarded$ MaxDiscarded() {
        if (this.MaxDiscarded$module == null) {
            this.MaxDiscarded$lzycompute$1();
        }
        return this.MaxDiscarded$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$MaxSize$ MaxSize() {
        if (this.MaxSize$module == null) {
            this.MaxSize$lzycompute$1();
        }
        return this.MaxSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    public Random random() {
        return this.random;
    }

    public void checkHiveHash(Object input, DataType dataType, long expected) {
        long actual = HiveHashFunction$.MODULE$.hash(input, dataType, 0L);
        this.withClue(new StringBuilder(40).append("hash mismatch for input = `").append(input).append("` of type `").append(dataType).append("`.").toString(), (Function0 & Serializable & scala.Serializable)() -> {
            long $org_scalatest_assert_macro_left = actual;
            long $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        });
    }

    public void checkHiveHashForIntegralType(DataType dataType) {
        this.checkHiveHash(null, dataType, 0L);
        this.checkHiveHash(BoxesRunTime.boxToInteger((int)1), dataType, 1L);
        this.checkHiveHash(BoxesRunTime.boxToInteger((int)0), dataType, 0L);
        this.checkHiveHash(BoxesRunTime.boxToInteger((int)-1), dataType, -1L);
        this.checkHiveHash(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), dataType, Integer.MAX_VALUE);
        this.checkHiveHash(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), dataType, Integer.MIN_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int input = this.random().nextInt();
            this.checkHiveHash(BoxesRunTime.boxToInteger((int)input), dataType, input);
        });
    }

    private StructType structOfString() {
        return this.structOfString;
    }

    private StructType structOfUDT() {
        return this.structOfUDT;
    }

    private ArrayType arrayOfString() {
        return this.arrayOfString;
    }

    private ArrayType arrayOfNull() {
        return this.arrayOfNull;
    }

    private MapType mapOfString() {
        return this.mapOfString;
    }

    private ArrayType arrayOfUDT() {
        return this.arrayOfUDT;
    }

    private void testHash(StructType inputSchema) {
        Function0 inputGenerator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)inputSchema, false, RandomDataGenerator$.MODULE$.forType$default$3()).get();
        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(inputSchema);
        int seed = Random$.MODULE$.nextInt();
        this.test(new StringBuilder(28).append("murmur3/xxHash64/hive hash: ").append(inputSchema.simpleString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            UnsafeRow input = (UnsafeRow)encoder.toRow((Object)((Row)inputGenerator.apply()));
            Seq literals = (Seq)((TraversableLike)input.toSeq(inputSchema).zip((GenIterable)inputSchema.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object value = tuple2._1();
                DataType dt = (DataType)tuple2._2();
                Literal literal = Literal$.MODULE$.create(value, dt);
                return literal;
            }, Seq$.MODULE$.canBuildFrom());
            Murmur3Hash qual$1 = new Murmur3Hash(literals, seed);
            InternalRow x$1 = qual$1.eval$default$1();
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Murmur3Hash(literals, seed), qual$1.eval(x$1), this.checkEvaluation$default$3());
            XxHash64 qual$2 = new XxHash64(literals, (long)seed);
            InternalRow x$2 = qual$2.eval$default$1();
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new XxHash64(literals, (long)seed), qual$2.eval(x$2), this.checkEvaluation$default$3());
            HiveHash qual$3 = new HiveHash(literals);
            InternalRow x$3 = qual$3.eval$default$1();
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new HiveHash(literals), BoxesRunTime.boxToInteger((int)qual$3.eval(x$3)), this.checkEvaluation$default$3());
        }), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void PropertyCheckConfig$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.PropertyCheckConfig$module == null) {
                this.PropertyCheckConfig$module = new Configuration$PropertyCheckConfig$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscarded$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.MaxDiscarded$module == null) {
                this.MaxDiscarded$module = new Configuration$MaxDiscarded$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void MaxSize$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.MaxSize$module == null) {
                this.MaxSize$module = new Configuration$MaxSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        HashExpressionsSuite hashExpressionsSuite = this;
        synchronized (hashExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    private final void checkHiveHashForDateType$1(String dateString, long expected) {
        this.checkHiveHash(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)dateString)).get(), (DataType)DateType$.MODULE$, expected);
    }

    private final void checkHiveHashForTimestampType$1(String timestamp, long expected, TimeZone timeZone) {
        this.checkHiveHash(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)timestamp), timeZone).get(), (DataType)TimestampType$.MODULE$, expected);
    }

    private static final TimeZone checkHiveHashForTimestampType$default$3$1() {
        return TimeZone.getTimeZone("UTC");
    }

    private final void checkHiveHashForIntervalType$1(String interval, long expected) {
        this.checkHiveHash(CalendarInterval.fromString((String)interval), (DataType)CalendarIntervalType$.MODULE$, expected);
    }

    private final void checkHiveHashForDecimal$1(String input, int precision, int scale, long expected) {
        DecimalType decimalType = DataTypes.createDecimalType((int)precision, (int)scale);
        Decimal value = Decimal$.MODULE$.apply(new BigDecimal(input));
        Decimal decimal = value.changePrecision(precision, scale) ? value : null;
        this.checkHiveHash(decimal, (DataType)decimalType, expected);
    }

    private final void checkResult$1(StructType schema, InternalRow input) {
        BoundReference[] exprs = (BoundReference[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            BoundReference boundReference = new BoundReference(i, f.dataType(), true);
            return boundReference;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BoundReference.class)));
        Murmur3Hash murmur3HashExpr = new Murmur3Hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs), 42);
        package.MutableProjection murmur3HashPlan = (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Murmur3Hash[]{murmur3HashExpr})));
        Object murmursHashEval = new Murmur3Hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs), 42).eval(input);
        int $org_scalatest_assert_macro_left = ((SpecializedGetters)murmur3HashPlan.apply((Object)input)).getInt(0);
        Object $org_scalatest_assert_macro_right = murmursHashEval;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), (Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        HiveHash hiveHashExpr = new HiveHash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
        package.MutableProjection hiveHashPlan = (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HiveHash[]{hiveHashExpr})));
        int hiveHashEval = new HiveHash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs)).eval(input);
        int $org_scalatest_assert_macro_left2 = ((SpecializedGetters)hiveHashPlan.apply((Object)input)).getInt(0);
        int $org_scalatest_assert_macro_right2 = hiveHashEval;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$51(int i) {
        return UTF8String.fromString((String)((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ StructField $anonfun$new$52(int i) {
        return new StructField(((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ GenericInternalRow $anonfun$new$56(int k$1, int L$1, int j$1, int N$1, int i) {
        return new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)((Object)BoxesRunTime.boxToInteger((int)(k$1 * L$1 + j$1 * N$1 + i))).toString())}), ClassTag$.MODULE$.Any()));
    }

    public static final /* synthetic */ GenericInternalRow $anonfun$new$55(int N$1, int k$1, int L$1, int j) {
        return new GenericInternalRow((Object[])((TraversableOnce)Seq$.MODULE$.tabulate(N$1, (Function1 & Serializable & scala.Serializable)i -> HashExpressionsSuite.$anonfun$new$56(k$1, L$1, j, N$1, BoxesRunTime.unboxToInt((Object)i)))).toArray(ClassTag$.MODULE$.Any()));
    }

    public static final /* synthetic */ GenericInternalRow $anonfun$new$54(int M$1, int N$1, int L$1, int k) {
        return new GenericInternalRow((Object[])((TraversableOnce)Seq$.MODULE$.tabulate(M$1, (Function1 & Serializable & scala.Serializable)j -> HashExpressionsSuite.$anonfun$new$55(N$1, k, L$1, BoxesRunTime.unboxToInt((Object)j)))).toArray(ClassTag$.MODULE$.Any()));
    }

    public static final /* synthetic */ StructField $anonfun$new$57(HashExpressionsSuite $this, int x$1) {
        return new StructField("structOfString", (DataType)$this.structOfString(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ StructField $anonfun$new$58(StructType inner$1, int x$2) {
        return new StructField("structOfStructOfString", (DataType)inner$1, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ StructField $anonfun$new$59(StructType outer$1, int x$3) {
        return new StructField("structOfStructOfStructOfString", (DataType)outer$1, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public HashExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        GeneratorDrivenPropertyChecks.$init$((GeneratorDrivenPropertyChecks)this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.random = new Random();
        this.test("md5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Md5((Expression)Literal$.MODULE$.apply((Object)"ABC".getBytes(StandardCharsets.UTF_8))), "902fbdd2b1df0c4f70b4a5d23525e932", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Md5((Expression)Literal$.MODULE$.create(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5, 6}), ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$)), "6ac1e56bc78f031059be7be854522c4c", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Md5((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Md5$.MODULE$, (DataType)BinaryType$.MODULE$);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("sha1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha1((Expression)Literal$.MODULE$.apply((Object)"ABC".getBytes(StandardCharsets.UTF_8))), "3c01bdbb26f358bab27f267924aa2c9a03fcfdb8", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha1((Expression)Literal$.MODULE$.create(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5, 6}), ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$)), "5d211bad8f4ee70e16c7d343a838fc344a1ed961", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha1((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha1((Expression)Literal$.MODULE$.apply((Object)"".getBytes(StandardCharsets.UTF_8))), "da39a3ee5e6b4b0d3255bfef95601890afd80709", this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Sha1$.MODULE$, (DataType)BinaryType$.MODULE$);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("sha2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.apply((Object)"ABC".getBytes(StandardCharsets.UTF_8)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)256))), DigestUtils.sha256Hex((String)"ABC"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.create(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5, 6}), ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)384))), DigestUtils.sha384Hex((byte[])((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5, 6}), ClassTag$.MODULE$.Byte()))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1024))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)512))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.apply((Object)"ABC".getBytes(StandardCharsets.UTF_8)), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Sha2((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("crc32", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Crc32((Expression)Literal$.MODULE$.apply((Object)"ABC".getBytes(StandardCharsets.UTF_8))), BoxesRunTime.boxToLong((long)2743272264L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Crc32((Expression)Literal$.MODULE$.create(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5, 6}), ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$)), BoxesRunTime.boxToLong((long)2180413220L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Crc32((Expression)Literal$.MODULE$.create(null, (DataType)BinaryType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Crc32$.MODULE$, (DataType)BinaryType$.MODULE$);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("hive-hash for null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHash(null, (DataType)NullType$.MODULE$, 0L), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("hive-hash for boolean", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$, 1L);
            this.checkHiveHash(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$, 0L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("hive-hash for byte", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForIntegralType((DataType)ByteType$.MODULE$), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("hive-hash for short", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForIntegralType((DataType)ShortType$.MODULE$), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("hive-hash for int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForIntegralType((DataType)IntegerType$.MODULE$), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("hive-hash for long", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(BoxesRunTime.boxToLong((long)1L), (DataType)LongType$.MODULE$, 1L);
            this.checkHiveHash(BoxesRunTime.boxToLong((long)0L), (DataType)LongType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToLong((long)-1L), (DataType)LongType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (DataType)LongType$.MODULE$, Integer.MIN_VALUE);
            this.checkHiveHash(BoxesRunTime.boxToLong((long)Long.MIN_VALUE), (DataType)LongType$.MODULE$, Integer.MIN_VALUE);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                long input = this.random().nextLong();
                this.checkHiveHash(BoxesRunTime.boxToLong((long)input), (DataType)LongType$.MODULE$, (int)(input >>> 32 ^ input));
            });
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("hive-hash for float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)0.0f), (DataType)FloatType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)0.0f), (DataType)FloatType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)1.1f), (DataType)FloatType$.MODULE$, 1066192077L);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)-1.1f), (DataType)FloatType$.MODULE$, -1081291571L);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)1.0E8f), (DataType)FloatType$.MODULE$, 1287568416L);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), (DataType)FloatType$.MODULE$, 0x7F7FFFFFL);
            this.checkHiveHash(BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), (DataType)FloatType$.MODULE$, -8388609L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("hive-hash for double", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(BoxesRunTime.boxToInteger((int)0), (DataType)DoubleType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)0.0), (DataType)DoubleType$.MODULE$, 0L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)1.1), (DataType)DoubleType$.MODULE$, -1503133693L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)-1.1), (DataType)DoubleType$.MODULE$, 644349955L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)1.000000000000001E9), (DataType)DoubleType$.MODULE$, 1104006509L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)1.0E9), (DataType)DoubleType$.MODULE$, 1104006501L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)1.0E19), (DataType)DoubleType$.MODULE$, 594568676L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), (DataType)DoubleType$.MODULE$, -2146435072L);
            this.checkHiveHash(BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (DataType)DoubleType$.MODULE$, 0x100000L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("hive-hash for string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(UTF8String.fromString((String)"apache spark"), (DataType)StringType$.MODULE$, 1142704523L);
            this.checkHiveHash(UTF8String.fromString((String)"!@#$%^&*()_+=-"), (DataType)StringType$.MODULE$, -613724358L);
            this.checkHiveHash(UTF8String.fromString((String)"abcdefghijklmnopqrstuvwxyz"), (DataType)StringType$.MODULE$, 958031277L);
            this.checkHiveHash(UTF8String.fromString((String)"AbCdEfGhIjKlMnOpQrStUvWxYz012"), (DataType)StringType$.MODULE$, -648013852L);
            this.checkHiveHash(UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (DataType)StringType$.MODULE$, -898686242L);
            this.checkHiveHash(UTF8String.fromString((String)"\u0928\u092e\u0938\u094d\u0924\u0947"), (DataType)StringType$.MODULE$, 2006045948L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("hive-hash for date type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.checkHiveHashForDateType$1("2017-01-01", 17167L);
            this.checkHiveHashForDateType$1("0000-01-01", -719530L);
            this.checkHiveHashForDateType$1("9999-12-31", 2932896L);
            this.checkHiveHashForDateType$1("1970-01-01", 0L);
            this.checkHiveHashForDateType$1("1800-01-01", -62091L);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForDateType$1("0-0-0", 0L), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForDateType$1("-1212-01-01", 0L), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForDateType$1("2016-99-99", 0L), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForDateType$1("", 0L), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            return (NoSuchElementException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForDateType$1("2016-02-30", 16861L), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("hive-hash for timestamp type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.checkHiveHashForTimestampType$1("2017-02-24 10:56:29", 1445725271L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.checkHiveHashForTimestampType$1("2017-02-24 10:56:29.111111", 1353936655L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.checkHiveHashForTimestampType$1("2017-02-24 10:56:29", 1445732471L, TimeZone.getTimeZone("US/Pacific"));
            this.checkHiveHashForTimestampType$1("0001-01-01 00:00:00", 1645926784L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.checkHiveHashForTimestampType$1("9999-01-01 00:00:00", -1081818240L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.checkHiveHashForTimestampType$1("1970-01-01 00:00:00", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.checkHiveHashForTimestampType$1("1800-01-01 03:12:45", -267420885L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1());
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("0-0-0 0:0:0", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("-99-99-99 99:99:45", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("555555-55555-5555", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("2016-02-30 00:00:00", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            return (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkHiveHashForTimestampType$1("2017-02-24 10:56:29.11111111", 0L, HashExpressionsSuite.checkHiveHashForTimestampType$default$3$1()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("hive-hash for CalendarInterval type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHashForIntervalType$1("interval 1 microsecond", 24273L);
            this.checkHiveHashForIntervalType$1("interval -1 microsecond", 22273L);
            this.checkHiveHashForIntervalType$1("interval 0 microsecond", 23273L);
            this.checkHiveHashForIntervalType$1("interval 999 microsecond", 1022273L);
            this.checkHiveHashForIntervalType$1("interval -999 microsecond", -975727L);
            this.checkHiveHashForIntervalType$1("interval 1 millisecond", 1023273L);
            this.checkHiveHashForIntervalType$1("interval -1 millisecond", -976727L);
            this.checkHiveHashForIntervalType$1("interval 0 millisecond", 23273L);
            this.checkHiveHashForIntervalType$1("interval 999 millisecond", 999023273L);
            this.checkHiveHashForIntervalType$1("interval -999 millisecond", -998976727L);
            this.checkHiveHashForIntervalType$1("interval 1 second", 23310L);
            this.checkHiveHashForIntervalType$1("interval -1 second", 23273L);
            this.checkHiveHashForIntervalType$1("interval 0 second", 23273L);
            this.checkHiveHashForIntervalType$1("interval 2147483647 second", -2147460412L);
            this.checkHiveHashForIntervalType$1("interval -2147483648 second", -2147460412L);
            this.checkHiveHashForIntervalType$1("interval 1 minute", 25493L);
            this.checkHiveHashForIntervalType$1("interval -1 minute", 25456L);
            this.checkHiveHashForIntervalType$1("interval 0 minute", 23273L);
            this.checkHiveHashForIntervalType$1("interval 2147483647 minute", 21830L);
            this.checkHiveHashForIntervalType$1("interval -2147483648 minute", 22163L);
            this.checkHiveHashForIntervalType$1("interval 1 hour", 156473L);
            this.checkHiveHashForIntervalType$1("interval -1 hour", 156436L);
            this.checkHiveHashForIntervalType$1("interval 0 hour", 23273L);
            this.checkHiveHashForIntervalType$1("interval 2147483647 hour", -62308L);
            this.checkHiveHashForIntervalType$1("interval -2147483648 hour", -43327L);
            this.checkHiveHashForIntervalType$1("interval 1 day", 3220073L);
            this.checkHiveHashForIntervalType$1("interval -1 day", 3220036L);
            this.checkHiveHashForIntervalType$1("interval 0 day", 23273L);
            this.checkHiveHashForIntervalType$1("interval 106751991 day", -451506760L);
            this.checkHiveHashForIntervalType$1("interval -106751991 day", -451514123L);
            this.checkHiveHashForIntervalType$1("interval 0 day 0 hour", 23273L);
            this.checkHiveHashForIntervalType$1("interval 0 day 0 hour 0 minute", 23273L);
            this.checkHiveHashForIntervalType$1("interval 0 day 0 hour 0 minute 0 second", 23273L);
            this.checkHiveHashForIntervalType$1("interval 0 day 0 hour 0 minute 0 second 0 millisecond", 23273L);
            this.checkHiveHashForIntervalType$1("interval 0 day 0 hour 0 minute 0 second 0 millisecond 0 microsecond", 23273L);
            this.checkHiveHashForIntervalType$1("interval 6 day 15 hour", 21202073L);
            this.checkHiveHashForIntervalType$1("interval 5 day 4 hour 8 minute", 16557833L);
            this.checkHiveHashForIntervalType$1("interval -23 day 56 hour -1111113 minute 9898989 second", -2128468593L);
            this.checkHiveHashForIntervalType$1("interval 66 day 12 hour 39 minute 23 second 987 millisecond", 1199697904L);
            this.checkHiveHashForIntervalType$1("interval 66 day 12 hour 39 minute 23 second 987 millisecond 123 microsecond", 1199820904L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("hive-hash for array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHash(new GenericArrayData((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int())), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), 0L);
            this.checkHiveHash(new GenericArrayData(new int[]{1, 10000, Integer.MAX_VALUE}), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), -2147172688L);
            this.checkHiveHash(new GenericArrayData(new long[]{-1L, 0L, 999L, Integer.MIN_VALUE}), (DataType)new ArrayType((DataType)LongType$.MODULE$, false), -2147452680L);
            ArrayType arrayTypeWithNull = new ArrayType((DataType)IntegerType$.MODULE$, true);
            this.checkHiveHash(new GenericArrayData(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}), ClassTag$.MODULE$.Null())), (DataType)arrayTypeWithNull, 0L);
            this.checkHiveHash(new GenericArrayData((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-12221), BoxesRunTime.boxToInteger((int)89), null, BoxesRunTime.boxToInteger((int)767)}), ClassTag$.MODULE$.Any())), (DataType)arrayTypeWithNull, -363989515L);
            this.checkHiveHash(new GenericArrayData((Object)new GenericArrayData[]{new GenericArrayData(new long[]{1234L, -9L, 67L}), new GenericArrayData(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}), ClassTag$.MODULE$.Null())), new GenericArrayData(new long[]{55L, -100L, -2147452680L})}), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$)), -1007531064L);
            this.checkHiveHash(new GenericArrayData((Object)new ArrayBasedMapData[]{new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{-99, 1234}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"sql"), null})), new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{67}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"apache spark")}))}), (DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)), 1139205955L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("hive-hash for map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapType mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
            this.checkHiveHash(new ArrayBasedMapData((ArrayData)new GenericArrayData(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing())), (ArrayData)new GenericArrayData(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()))), (DataType)mapType, 0L);
            this.checkHiveHash(new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{1, 2}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"foo"), UTF8String.fromString((String)"bar")})), (DataType)mapType, 198872L);
            this.checkHiveHash(new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{55, -99}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"apache spark"), null})), (DataType)mapType, 1142704473L);
            MapType nestedMapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
            this.checkHiveHash(new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{1, -100}), (ArrayData)new GenericArrayData((Object)new ArrayBasedMapData[]{new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{-99, 1234}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"sql"), null})), new ArrayBasedMapData((ArrayData)new GenericArrayData(new int[]{67}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"apache spark")}))})), (DataType)nestedMapType, -1142817416L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("hive-hash for struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            GenericInternalRow row = new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}), ClassTag$.MODULE$.Any()));
            this.checkHiveHash(row, (DataType)new StructType().add("col1", (DataType)IntegerType$.MODULE$).add("col2", (DataType)IntegerType$.MODULE$).add("col3", (DataType)IntegerType$.MODULE$), 1026L);
            StructType structType = new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("arrayOfString", (DataType)this.arrayOfString()).add("mapOfString", (DataType)this.mapOfString());
            ArrayBuffer rowValues = new ArrayBuffer();
            rowValues.$plus$eq(null);
            rowValues.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
            rowValues.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
            rowValues.$plus$eq((Object)BoxesRunTime.boxToInteger((int)2));
            rowValues.$plus$eq((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
            rowValues.$plus$eq((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE));
            rowValues.$plus$eq((Object)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"apache spark"), UTF8String.fromString((String)"hello world")}));
            rowValues.$plus$eq((Object)new ArrayBasedMapData((ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"project"), UTF8String.fromString((String)"meta")}), (ArrayData)new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)"apache spark"), null})));
            GenericInternalRow row2 = new GenericInternalRow((Object[])rowValues.toArray(ClassTag$.MODULE$.Any()));
            this.checkHiveHash(row2, (DataType)structType, -2119012447L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.structOfString = new StructType().add("str", (DataType)StringType$.MODULE$);
        this.structOfUDT = new StructType().add("udt", (DataType)new ExamplePointUDT(), false);
        this.arrayOfString = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
        this.arrayOfNull = ArrayType$.MODULE$.apply((DataType)NullType$.MODULE$);
        this.mapOfString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
        this.arrayOfUDT = new ArrayType((DataType)new ExamplePointUDT(), false);
        this.testHash(new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("bigDecimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("smallDecimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$).add("udt", (DataType)new ExamplePointUDT()));
        this.testHash(new StructType().add("arrayOfNull", (DataType)this.arrayOfNull()).add("arrayOfString", (DataType)this.arrayOfString()).add("arrayOfArrayOfString", (DataType)ArrayType$.MODULE$.apply((DataType)this.arrayOfString())).add("arrayOfArrayOfInt", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))).add("arrayOfMap", (DataType)ArrayType$.MODULE$.apply((DataType)this.mapOfString())).add("arrayOfStruct", (DataType)ArrayType$.MODULE$.apply((DataType)this.structOfString())).add("arrayOfUDT", (DataType)this.arrayOfUDT()));
        this.testHash(new StructType().add("mapOfIntAndString", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)).add("mapOfStringAndArray", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.arrayOfString())).add("mapOfArrayAndInt", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)IntegerType$.MODULE$)).add("mapOfArray", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)this.arrayOfString())).add("mapOfStringAndStruct", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.structOfString())).add("mapOfStructAndString", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)StringType$.MODULE$)).add("mapOfStruct", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)this.structOfString())));
        this.testHash(new StructType().add("structOfString", (DataType)this.structOfString()).add("structOfStructOfString", (DataType)new StructType().add("struct", (DataType)this.structOfString())).add("structOfArray", (DataType)new StructType().add("array", (DataType)this.arrayOfString())).add("structOfMap", (DataType)new StructType().add("map", (DataType)this.mapOfString())).add("structOfArrayAndMap", (DataType)new StructType().add("array", (DataType)this.arrayOfString()).add("map", (DataType)this.mapOfString())).add("structOfUDT", (DataType)this.structOfUDT()));
        this.test("hive-hash for decimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkHiveHashForDecimal$1("18", 38, 0, 558L);
            this.checkHiveHashForDecimal$1("-18", 38, 0, -558L);
            this.checkHiveHashForDecimal$1("-18", 38, 12, -558L);
            this.checkHiveHashForDecimal$1("18446744073709001000", 38, 19, 0L);
            this.checkHiveHashForDecimal$1("-18446744073709001000", 38, 22, 0L);
            this.checkHiveHashForDecimal$1("-18446744073709001000", 38, 3, 17070057L);
            this.checkHiveHashForDecimal$1("18446744073709001000", 38, 4, -17070057L);
            this.checkHiveHashForDecimal$1("9223372036854775807", 38, 4, 2147482656L);
            this.checkHiveHashForDecimal$1("-9223372036854775807", 38, 5, -2147482656L);
            this.checkHiveHashForDecimal$1("00000.00000000000", 38, 34, 0L);
            this.checkHiveHashForDecimal$1("-00000.00000000000", 38, 11, 0L);
            this.checkHiveHashForDecimal$1("123456.1234567890", 38, 2, 382713974L);
            this.checkHiveHashForDecimal$1("123456.1234567890", 38, 20, 1871500252L);
            this.checkHiveHashForDecimal$1("123456.1234567890", 38, 10, 1871500252L);
            this.checkHiveHashForDecimal$1("-123456.1234567890", 38, 10, -1871500234L);
            this.checkHiveHashForDecimal$1("123456.1234567890", 38, 0, 3827136L);
            this.checkHiveHashForDecimal$1("-123456.1234567890", 38, 0, -3827136L);
            this.checkHiveHashForDecimal$1("123456.1234567890", 38, 20, 1871500252L);
            this.checkHiveHashForDecimal$1("-123456.1234567890", 38, 20, -1871500234L);
            this.checkHiveHashForDecimal$1("123456.123456789012345678901234567890", 38, 0, 3827136L);
            this.checkHiveHashForDecimal$1("-123456.123456789012345678901234567890", 38, 0, -3827136L);
            this.checkHiveHashForDecimal$1("123456.123456789012345678901234567890", 38, 10, 1871500252L);
            this.checkHiveHashForDecimal$1("-123456.123456789012345678901234567890", 38, 10, -1871500234L);
            this.checkHiveHashForDecimal$1("123456.123456789012345678901234567890", 38, 20, 236317582L);
            this.checkHiveHashForDecimal$1("-123456.123456789012345678901234567890", 38, 20, -236317544L);
            this.checkHiveHashForDecimal$1("123456.123456789012345678901234567890", 38, 30, 1728235666L);
            this.checkHiveHashForDecimal$1("-123456.123456789012345678901234567890", 38, 30, -1728235608L);
            this.checkHiveHashForDecimal$1("123456.123456789012345678901234567890", 38, 31, 1728235666L);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("SPARK-18207: Compute hash for a lot of expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 1000;
            GenericInternalRow wideRow = new GenericInternalRow((Object[])((TraversableOnce)Seq$.MODULE$.tabulate(N, (Function1 & Serializable & scala.Serializable)i -> HashExpressionsSuite.$anonfun$new$51(BoxesRunTime.unboxToInt((Object)i)))).toArray(ClassTag$.MODULE$.Any()));
            StructType schema = StructType$.MODULE$.apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), N).map((Function1 & Serializable & scala.Serializable)i -> HashExpressionsSuite.$anonfun$new$52(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()));
            this.checkResult$1(schema, (InternalRow)wideRow);
            InternalRow nestedRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{wideRow}));
            StructType nestedSchema = new StructType().add("nested", (DataType)schema);
            this.checkResult$1(nestedSchema, nestedRow);
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        this.test("SPARK-22284: Compute hash for nested structs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int M = 80;
            int N = 10;
            int L = M * N;
            int O = 50;
            int seed = 42;
            GenericInternalRow wideRow = new GenericInternalRow((Object[])((TraversableOnce)Seq$.MODULE$.tabulate(O, (Function1 & Serializable & scala.Serializable)k -> HashExpressionsSuite.$anonfun$new$54(M, N, L, BoxesRunTime.unboxToInt((Object)k)))).toArray(ClassTag$.MODULE$.Any()));
            StructType inner = new StructType((StructField[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).map((Function1 & Serializable & scala.Serializable)x$1 -> HashExpressionsSuite.$anonfun$new$57(this, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
            StructType outer = new StructType((StructField[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), M).map((Function1 & Serializable & scala.Serializable)x$2 -> HashExpressionsSuite.$anonfun$new$58(inner, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
            StructType schema = new StructType((StructField[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), O).map((Function1 & Serializable & scala.Serializable)x$3 -> HashExpressionsSuite.$anonfun$new$59(outer, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
            BoundReference[] exprs = (BoundReference[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                BoundReference boundReference = new BoundReference(i, f.dataType(), true);
                return boundReference;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BoundReference.class)));
            Murmur3Hash murmur3HashExpr = new Murmur3Hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs), 42);
            package.MutableProjection murmur3HashPlan = (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Murmur3Hash[]{murmur3HashExpr})));
            Object murmursHashEval = new Murmur3Hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs), 42).eval((InternalRow)wideRow);
            int $org_scalatest_assert_macro_left = ((SpecializedGetters)murmur3HashPlan.apply((Object)wideRow)).getInt(0);
            Object $org_scalatest_assert_macro_right = murmursHashEval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), (Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        }, new Position("HashExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
    }
}

