/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.ArrayAggregate;
import org.apache.spark.sql.catalyst.expressions.ArrayExists;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.StringRepeat;
import org.apache.spark.sql.catalyst.expressions.ZipWith;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.CheckerAsserting;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscarded$;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MaxSize$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfig$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.GeneratorDrivenPropertyChecks;
import org.scalatest.prop.Whenever;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0006\r\u0001eAQA\t\u0001\u0005\u0002\rBQ!\n\u0001\u0005\n\u0019BQ!\n\u0001\u0005\n}BQ!\n\u0001\u0005\n1CQ!\u0017\u0001\u0005\niCQ!\u001d\u0001\u0005\u0002IDQ!\u001d\u0001\u0005\u0002YDQ!\u001f\u0001\u0005\u0002iDQ! \u0001\u0005\u0002yDa! \u0001\u0005\u0002\u00055!!\u0007%jO\",'o\u0014:eKJ4UO\\2uS>t7oU;ji\u0016T!!\u0004\b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001iq\u0002CA\u000e\u001d\u001b\u0005\u0011\u0012BA\u000f\u0013\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011q\u0004I\u0007\u0002\u0019%\u0011\u0011\u0005\u0004\u0002\u0015\u000bb\u0004(/Z:tS>tWI^1m\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0010\u0001\u00031\u0019'/Z1uK2\u000bWN\u00193b)\u00119#F\r\u001e\u0011\u0005}A\u0013BA\u0015\r\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006W\t\u0001\r\u0001L\u0001\u0003IR\u0004\"!\f\u0019\u000e\u00039R!a\f\t\u0002\u000bQL\b/Z:\n\u0005Er#\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bM\u0012\u0001\u0019\u0001\u001b\u0002\u00119,H\u000e\\1cY\u0016\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012qAQ8pY\u0016\fg\u000eC\u0003<\u0005\u0001\u0007A(A\u0001g!\u0011)ThJ\u0014\n\u0005y2$!\u0003$v]\u000e$\u0018n\u001c82)\u00199\u0003I\u0011#G\u0011\")\u0011i\u0001a\u0001Y\u0005\u0019A\r^\u0019\t\u000b\r\u001b\u0001\u0019\u0001\u001b\u0002\u00139,H\u000e\\1cY\u0016\f\u0004\"B#\u0004\u0001\u0004a\u0013a\u00013ue!)qi\u0001a\u0001i\u0005Ia.\u001e7mC\ndWM\r\u0005\u0006w\r\u0001\r!\u0013\t\u0006k);seJ\u0005\u0003\u0017Z\u0012\u0011BR;oGRLwN\u001c\u001a\u0015\u0011\u001djej\u0014)R'VCQ!\u0011\u0003A\u00021BQa\u0011\u0003A\u0002QBQ!\u0012\u0003A\u00021BQa\u0012\u0003A\u0002QBQA\u0015\u0003A\u00021\n1\u0001\u001a;4\u0011\u0015!F\u00011\u00015\u0003%qW\u000f\u001c7bE2,7\u0007C\u0003<\t\u0001\u0007a\u000b\u0005\u00046/\u001e:seJ\u0005\u00031Z\u0012\u0011BR;oGRLwN\\\u001a\u0002\u001fY\fG.\u001b3bi\u0016\u0014\u0015N\u001c3j]\u001e$2a\u00170a!\tyB,\u0003\u0002^\u0019\tqA*Y7cI\u00064UO\\2uS>t\u0007\"B0\u0006\u0001\u00049\u0013!A3\t\u000b\u0005,\u0001\u0019\u00012\u0002\u000f\u0005\u0014x-\u00138g_B\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u0019\u0003\u0019a$o\\8u}%\tq'\u0003\u0002km\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\r\u0019V-\u001d\u0006\u0003UZ\u0002B!N8-i%\u0011\u0001O\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0013Q\u0014\u0018M\\:g_JlGcA\u0014tk\")AO\u0002a\u0001O\u0005!Q\r\u001f9s\u0011\u0015Yd\u00011\u0001=)\r9s\u000f\u001f\u0005\u0006i\u001e\u0001\ra\n\u0005\u0006w\u001d\u0001\r!S\u0001\u0007M&dG/\u001a:\u0015\u0007\u001dZH\u0010C\u0003u\u0011\u0001\u0007q\u0005C\u0003<\u0011\u0001\u0007A(A\u0005bO\u001e\u0014XmZ1uKRAqe`A\u0001\u0003\u000b\tI\u0001C\u0003u\u0013\u0001\u0007q\u0005\u0003\u0004\u0002\u0004%\u0001\raJ\u0001\u0005u\u0016\u0014x\u000e\u0003\u0004\u0002\b%\u0001\r!S\u0001\u0006[\u0016\u0014x-\u001a\u0005\u0007\u0003\u0017I\u0001\u0019\u0001\u001f\u0002\r\u0019Lg.[:i)\u001d9\u0013qBA\t\u0003'AQ\u0001\u001e\u0006A\u0002\u001dBa!a\u0001\u000b\u0001\u00049\u0003BBA\u0004\u0015\u0001\u0007\u0011\n")
public class HigherOrderFunctionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfig$ PropertyCheckConfig$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscarded$ MaxDiscarded$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$MaxSize$ MaxSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$1);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$2);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public package.Projection generateProject(Function0<package.Projection> generator, Expression expression) {
        return ExpressionEvalHelper.generateProject$(this, generator, expression);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithGeneratedMutableProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithGeneratedMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithGeneratedMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithGeneratedMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithGeneratedMutableProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithGeneratedMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithGeneratedMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithGeneratedMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public GeneratorDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfigurable config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return GeneratorDrivenPropertyChecks.forAll$((GeneratorDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfigurable)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Configuration.PropertyCheckConfiguration PropertyCheckConfig2PropertyCheckConfiguration(Configuration.PropertyCheckConfig p) {
        return Configuration.PropertyCheckConfig2PropertyCheckConfiguration$((Configuration)this, (Configuration.PropertyCheckConfig)p);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscarded maxDiscarded(int value) {
        return Configuration.maxDiscarded$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.MaxSize maxSize(int value) {
        return Configuration.maxSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Test.Parameters getParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable c) {
        return Configuration.getParams$((Configuration)this, configParams, (Configuration.PropertyCheckConfigurable)c);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfig$ PropertyCheckConfig() {
        if (this.PropertyCheckConfig$module == null) {
            this.PropertyCheckConfig$lzycompute$1();
        }
        return this.PropertyCheckConfig$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscarded$ MaxDiscarded() {
        if (this.MaxDiscarded$module == null) {
            this.MaxDiscarded$lzycompute$1();
        }
        return this.MaxDiscarded$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$MaxSize$ MaxSize() {
        if (this.MaxSize$module == null) {
            this.MaxSize$lzycompute$1();
        }
        return this.MaxSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private Expression createLambda(DataType dt, boolean nullable, Function1<Expression, Expression> f) {
        NamedLambdaVariable lv = new NamedLambdaVariable("arg", dt, nullable, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Expression function = (Expression)f.apply((Object)lv);
        return new LambdaFunction(function, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{lv})), LambdaFunction$.MODULE$.apply$default$3());
    }

    private Expression createLambda(DataType dt1, boolean nullable1, DataType dt2, boolean nullable2, Function2<Expression, Expression, Expression> f) {
        NamedLambdaVariable lv1 = new NamedLambdaVariable("arg1", dt1, nullable1, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        NamedLambdaVariable lv2 = new NamedLambdaVariable("arg2", dt2, nullable2, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Expression function = (Expression)f.apply((Object)lv1, (Object)lv2);
        return new LambdaFunction(function, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{lv1, lv2})), LambdaFunction$.MODULE$.apply$default$3());
    }

    private Expression createLambda(DataType dt1, boolean nullable1, DataType dt2, boolean nullable2, DataType dt3, boolean nullable3, Function3<Expression, Expression, Expression, Expression> f) {
        NamedLambdaVariable lv1 = new NamedLambdaVariable("arg1", dt1, nullable1, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        NamedLambdaVariable lv2 = new NamedLambdaVariable("arg2", dt2, nullable2, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        NamedLambdaVariable lv3 = new NamedLambdaVariable("arg3", dt3, nullable3, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Expression function = (Expression)f.apply((Object)lv1, (Object)lv2, (Object)lv3);
        return new LambdaFunction(function, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{lv1, lv2, lv3})), LambdaFunction$.MODULE$.apply$default$3());
    }

    private LambdaFunction validateBinding(Expression e, Seq<Tuple2<DataType, Object>> argInfo) {
        Expression expression = e;
        if (!(expression instanceof LambdaFunction)) {
            throw new MatchError((Object)expression);
        }
        LambdaFunction lambdaFunction = (LambdaFunction)expression;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)lambdaFunction.arguments().size()));
        int $org_scalatest_assert_macro_right = argInfo.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        ((IterableLike)lambdaFunction.arguments().zip(argInfo, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            NamedExpression arg;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    arg = (NamedExpression)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DataType dataType = (DataType)tuple2._1();
            boolean nullable = tuple2._2$mcZ$sp();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Expression)arg).dataType());
            DataType $org_scalatest_assert_macro_right = dataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((Expression)arg).nullable()));
            boolean $org_scalatest_assert_macro_right2 = nullable;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            return assertion;
        });
        LambdaFunction lambdaFunction2 = lambdaFunction;
        return lambdaFunction2;
    }

    public Expression transform(Expression expr, Function1<Expression, Expression> f) {
        DataType dataType = expr.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean cn = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)cn));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean cn2 = tuple22._2$mcZ$sp();
        return new ArrayTransform(expr, this.createLambda(et2, cn2, f)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    public Expression transform(Expression expr, Function2<Expression, Expression, Expression> f) {
        DataType dataType = expr.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean cn = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)cn));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean cn2 = tuple22._2$mcZ$sp();
        return new ArrayTransform(expr, this.createLambda(et2, cn2, (DataType)IntegerType$.MODULE$, false, f)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    public Expression filter(Expression expr, Function1<Expression, Expression> f) {
        DataType dataType = expr.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean cn = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)cn));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean cn2 = tuple22._2$mcZ$sp();
        return new ArrayFilter(expr, this.createLambda(et2, cn2, f)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    public Expression aggregate(Expression expr, Expression zero, Function2<Expression, Expression, Expression> merge, Function1<Expression, Expression> finish) {
        DataType dataType = expr.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean cn = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)cn));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean cn2 = tuple22._2$mcZ$sp();
        DataType zeroType = zero.dataType();
        return new ArrayAggregate(expr, zero, this.createLambda(zeroType, true, et2, cn2, merge), this.createLambda(zeroType, true, finish)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    public Expression aggregate(Expression expr, Expression zero, Function2<Expression, Expression, Expression> merge) {
        return this.aggregate(expr, zero, merge, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void PropertyCheckConfig$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.PropertyCheckConfig$module == null) {
                this.PropertyCheckConfig$module = new Configuration$PropertyCheckConfig$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscarded$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.MaxDiscarded$module == null) {
                this.MaxDiscarded$module = new Configuration$MaxDiscarded$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void MaxSize$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.MaxSize$module == null) {
                this.MaxSize$module = new Configuration$MaxSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        HigherOrderFunctionsSuite higherOrderFunctionsSuite = this;
        synchronized (higherOrderFunctionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    private final Expression exists$1(Expression expr, Function1 f) {
        DataType dataType = expr.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean cn = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)cn));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean cn2 = tuple22._2$mcZ$sp();
        return new ArrayExists(expr, this.createLambda(et2, cn2, (Function1<Expression, Expression>)f)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    private final Expression zip_with$1(Expression left, Expression right, Function2 f) {
        DataType rightT;
        DataType leftT;
        DataType dataType = left.dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType dataType2 = leftT = arrayType.elementType();
        DataType leftT2 = dataType2;
        DataType dataType3 = right.dataType();
        if (!(dataType3 instanceof ArrayType)) {
            throw new MatchError((Object)dataType3);
        }
        ArrayType arrayType2 = (ArrayType)dataType3;
        DataType dataType4 = rightT = arrayType2.elementType();
        DataType rightT2 = dataType4;
        return new ZipWith(left, right, this.createLambda(leftT2, true, rightT2, true, (Function2<Expression, Expression, Expression>)f)).bind((Function2 & Serializable & scala.Serializable)(e, argInfo) -> this.validateBinding((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo));
    }

    public HigherOrderFunctionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        GeneratorDrivenPropertyChecks.$init$((GeneratorDrivenPropertyChecks)this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.test("ArrayTransform", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal ai0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null, Predef$.MODULE$.int2Integer(3)})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ain = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable plusOne = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(x).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1));
            Function2 & Serializable & scala.Serializable plusIndex = (Function2 & Serializable & scala.Serializable)(x, i) -> package.expressions$.MODULE$.DslExpression(x).$plus(i);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)ai0, (Function1<Expression, Expression>)plusOne), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)ai0, (Function2<Expression, Expression, Expression>)plusIndex), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform(this.transform((Expression)ai0, (Function2<Expression, Expression, Expression>)plusIndex), (Function1<Expression, Expression>)plusOne), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 6})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)ai1, (Function1<Expression, Expression>)plusOne), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)4)})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)ai1, (Function2<Expression, Expression, Expression>)plusIndex), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)5)})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform(this.transform((Expression)ai1, (Function2<Expression, Expression, Expression>)plusIndex), (Function1<Expression, Expression>)plusOne), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)6)})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)ain, (Function1<Expression, Expression>)plusOne), null, this.checkEvaluation$default$3());
            Literal as0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal as1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", null, "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal asn = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable repeatTwice = (Function1 & Serializable & scala.Serializable)x -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{x, x})));
            Function2 & Serializable & scala.Serializable repeatIndexTimes = (Function2 & Serializable & scala.Serializable)(x, i) -> new StringRepeat(x, i);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)as0, (Function1<Expression, Expression>)repeatTwice), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "bb", "cc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)as0, (Function2<Expression, Expression, Expression>)repeatIndexTimes), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "b", "cc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform(this.transform((Expression)as0, (Function2<Expression, Expression, Expression>)repeatIndexTimes), (Function1<Expression, Expression>)repeatTwice), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "bb", "cccc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)as1, (Function1<Expression, Expression>)repeatTwice), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", null, "cc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)as1, (Function2<Expression, Expression, Expression>)repeatIndexTimes), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", null, "cc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform(this.transform((Expression)as1, (Function2<Expression, Expression, Expression>)repeatIndexTimes), (Function1<Expression, Expression>)repeatTwice), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", null, "cccc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)asn, (Function1<Expression, Expression>)repeatTwice), null, this.checkEvaluation$default$3());
            Literal aai = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)aai, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)array -> new Cast(this.transform((Expression)array, (Function1<Expression, Expression>)plusOne), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3())), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[2, 3, 4]", null, "[5, 6]"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)aai, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)array -> new Cast(this.transform((Expression)array, (Function2<Expression, Expression, Expression>)plusIndex), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3())), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[1, 3, 5]", null, "[4, 6]"})), this.checkEvaluation$default$3());
        }, new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("ArrayFilter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal ai0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null, Predef$.MODULE$.int2Integer(3)})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ain = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable isEven = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(x).$percent((Expression)package.expressions$.MODULE$.intToLiteral(2))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0));
            Function1 & Serializable & scala.Serializable isNullOrOdd = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(x).isNull()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(x).$percent((Expression)package.expressions$.MODULE$.intToLiteral(2))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ai0, (Function1<Expression, Expression>)isEven), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ai0, (Function1<Expression, Expression>)isNullOrOdd), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ai1, (Function1<Expression, Expression>)isEven), Seq$.MODULE$.empty(), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ai1, (Function1<Expression, Expression>)isNullOrOdd), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)3)})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ain, (Function1<Expression, Expression>)isEven), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)ain, (Function1<Expression, Expression>)isNullOrOdd), null, this.checkEvaluation$default$3());
            Literal as0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a0", "b1", "a2", "c3"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal as1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", null, "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal asn = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable startsWithA = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(x).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("a"));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)as0, (Function1<Expression, Expression>)startsWithA), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a0", "a2"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)as1, (Function1<Expression, Expression>)startsWithA), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.filter((Expression)asn, (Function1<Expression, Expression>)startsWithA), null, this.checkEvaluation$default$3());
            Literal aai = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)aai, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)ix -> this.filter((Expression)ix, (Function1<Expression, Expression>)isNullOrOdd)), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5}))})), this.checkEvaluation$default$3());
        }, new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("ArrayExists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal ai0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null, Predef$.MODULE$.int2Integer(3)})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ain = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable isEven = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(x).$percent((Expression)package.expressions$.MODULE$.intToLiteral(2))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0));
            Function1 & Serializable & scala.Serializable isNullOrOdd = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(x).isNull()).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(x).$percent((Expression)package.expressions$.MODULE$.intToLiteral(2))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ai0, isEven), BoxesRunTime.boxToBoolean((boolean)true), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ai0, isNullOrOdd), BoxesRunTime.boxToBoolean((boolean)true), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ai1, isEven), BoxesRunTime.boxToBoolean((boolean)false), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ai1, isNullOrOdd), BoxesRunTime.boxToBoolean((boolean)true), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ain, isEven), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)ain, isNullOrOdd), null, this.checkEvaluation$default$3());
            Literal as0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a0", "b1", "a2", "c3"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal as1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{null, "b", "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal asn = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Function1 & Serializable & scala.Serializable startsWithA = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(x).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("a"));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)as0, startsWithA), BoxesRunTime.boxToBoolean((boolean)true), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)as1, startsWithA), BoxesRunTime.boxToBoolean((boolean)false), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.exists$1((Expression)asn, startsWithA), null, this.checkEvaluation$default$3());
            Literal aai = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.transform((Expression)aai, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)ix -> this.exists$1((Expression)ix, isNullOrOdd)), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), null, BoxesRunTime.boxToBoolean((boolean)true)})), this.checkEvaluation$default$3());
        }, new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("ArrayAggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal ai0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null, Predef$.MODULE$.int2Integer(3)})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ai2 = Literal$.MODULE$.create((Object)Seq$.MODULE$.empty(), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ain = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)ai0, (Expression)package.expressions$.MODULE$.intToLiteral(0), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> package.expressions$.MODULE$.DslExpression(acc).$plus(elem), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)acc -> package.expressions$.MODULE$.DslExpression(acc).$times((Expression)package.expressions$.MODULE$.intToLiteral(10))), BoxesRunTime.boxToInteger((int)60), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)ai1, (Expression)package.expressions$.MODULE$.intToLiteral(0), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> package.expressions$.MODULE$.DslExpression(acc).$plus(package.expressions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{elem, package.expressions$.MODULE$.intToLiteral(0)}))), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)acc -> package.expressions$.MODULE$.DslExpression(acc).$times((Expression)package.expressions$.MODULE$.intToLiteral(10))), BoxesRunTime.boxToInteger((int)40), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)ai2, (Expression)package.expressions$.MODULE$.intToLiteral(0), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> package.expressions$.MODULE$.DslExpression(acc).$plus(elem), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)acc -> package.expressions$.MODULE$.DslExpression(acc).$times((Expression)package.expressions$.MODULE$.intToLiteral(10))), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)ain, (Expression)package.expressions$.MODULE$.intToLiteral(0), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> package.expressions$.MODULE$.DslExpression(acc).$plus(elem), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)acc -> package.expressions$.MODULE$.DslExpression(acc).$times((Expression)package.expressions$.MODULE$.intToLiteral(10))), null, this.checkEvaluation$default$3());
            Literal as0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal as1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", null, "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal as2 = Literal$.MODULE$.create((Object)Seq$.MODULE$.empty(), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal asn = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)as0, (Expression)package.expressions$.MODULE$.stringToLiteral(""), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{acc, elem})))), "abc", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)as1, (Expression)package.expressions$.MODULE$.stringToLiteral(""), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{acc, package.expressions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{elem, package.expressions$.MODULE$.stringToLiteral("x")}))})))), "axc", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)as2, (Expression)package.expressions$.MODULE$.stringToLiteral(""), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{acc, elem})))), "", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)asn, (Expression)package.expressions$.MODULE$.stringToLiteral(""), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{acc, elem})))), null, this.checkEvaluation$default$3());
            Literal aai = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.aggregate((Expression)aai, (Expression)package.expressions$.MODULE$.intToLiteral(0), (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc2, array) -> package.expressions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.aggregate((Expression)array, (Expression)acc2, (Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(acc, elem) -> package.expressions$.MODULE$.DslExpression(acc).$plus(elem)), acc2}))), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
        }, new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("ZipWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal ai0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Literal ai2 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null, Predef$.MODULE$.int2Integer(3)})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ai3 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), null})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
            Literal ain = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
            Function2 & Serializable & scala.Serializable add = (Function2 & Serializable & scala.Serializable)(x, y) -> package.expressions$.MODULE$.DslExpression(x).$plus(y);
            Function1 & Serializable & scala.Serializable plusOne = (Function1 & Serializable & scala.Serializable)x -> package.expressions$.MODULE$.DslExpression(x).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ai0, (Expression)ai1, add), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)6), null})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ai3, (Expression)ai2, add), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, null})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ai2, (Expression)ai3, add), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, null})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ain, (Expression)ain, add), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ai1, (Expression)ain, add), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)ain, (Expression)ai1, add), null, this.checkEvaluation$default$3());
            Literal as0 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Literal as1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", null, "c"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal as2 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal asn = Literal$.MODULE$.create(null, (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            Function2 & Serializable & scala.Serializable concat = (Function2 & Serializable & scala.Serializable)(x, y) -> new Concat((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{x, y})));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)as0, (Expression)as1, concat), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", null, "cc"})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)as0, (Expression)as2, concat), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", null, null})), this.checkEvaluation$default$3());
            Literal aai1 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), null, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            Literal aai2 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))})), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)aai1, (Expression)aai2, (Function2 & Serializable & scala.Serializable)(a1, a2) -> new Cast(this.zip_with$1(this.transform((Expression)a1, (Function1<Expression, Expression>)plusOne), this.transform((Expression)a2, (Function1<Expression, Expression>)plusOne), add), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3())), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[4, 6, 8]", null, null})), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.zip_with$1((Expression)aai1, (Expression)aai1, (Function2 & Serializable & scala.Serializable)(a1, a2) -> new Cast(this.transform((Expression)a1, (Function1<Expression, Expression>)plusOne), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3())), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[2, 3, 4]", null, "[5, 6]"})), this.checkEvaluation$default$3());
        }, new Position("HigherOrderFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
    }
}

