/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LiteralGenerator$ {
    public static LiteralGenerator$ MODULE$;
    private Gen<Literal> byteLiteralGen;
    private Gen<Literal> shortLiteralGen;
    private Gen<Literal> integerLiteralGen;
    private Gen<Literal> longLiteralGen;
    private Gen<Literal> floatLiteralGen;
    private Gen<Literal> doubleLiteralGen;
    private Gen<Literal> stringLiteralGen;
    private Gen<Literal> binaryLiteralGen;
    private Gen<Literal> booleanLiteralGen;
    private Gen<Literal> dateLiteralGen;
    private Gen<Literal> timestampLiteralGen;
    private Gen<Literal> calendarIntervalLiterGen;
    private Gen<Literal> limitedIntegerLiteralGen;
    private volatile int bitmap$0;

    static {
        new LiteralGenerator$();
    }

    private Gen<Literal> byteLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.byteLiteralGen = Arbitrary$.MODULE$.arbByte().arbitrary().map((Function1 & Serializable & scala.Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b)), (DataType)ByteType$.MODULE$));
                this.bitmap$0 |= 1;
            }
        }
        return this.byteLiteralGen;
    }

    public Gen<Literal> byteLiteralGen() {
        return (this.bitmap$0 & 1) == 0 ? this.byteLiteralGen$lzycompute() : this.byteLiteralGen;
    }

    private Gen<Literal> shortLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.shortLiteralGen = Arbitrary$.MODULE$.arbShort().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)s)), (DataType)ShortType$.MODULE$));
                this.bitmap$0 |= 2;
            }
        }
        return this.shortLiteralGen;
    }

    public Gen<Literal> shortLiteralGen() {
        return (this.bitmap$0 & 2) == 0 ? this.shortLiteralGen$lzycompute() : this.shortLiteralGen;
    }

    private Gen<Literal> integerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.integerLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable & scala.Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                this.bitmap$0 |= 4;
            }
        }
        return this.integerLiteralGen;
    }

    public Gen<Literal> integerLiteralGen() {
        return (this.bitmap$0 & 4) == 0 ? this.integerLiteralGen$lzycompute() : this.integerLiteralGen;
    }

    private Gen<Literal> longLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.longLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable & scala.Serializable)l -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)), (DataType)LongType$.MODULE$));
                this.bitmap$0 |= 8;
            }
        }
        return this.longLiteralGen;
    }

    public Gen<Literal> longLiteralGen() {
        return (this.bitmap$0 & 8) == 0 ? this.longLiteralGen$lzycompute() : this.longLiteralGen;
    }

    private Gen<Literal> floatLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.floatLiteralGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToFloat((float)(Float$.MODULE$.MinValue() / (float)2)), (Object)BoxesRunTime.boxToFloat((float)1.7014117E38f), (Seq)Predef$.MODULE$.wrapFloatArray(new float[]{Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY}), (Numeric)Numeric.FloatIsFractional$.MODULE$, Gen.Choose$.MODULE$.chooseFloat()).map((Function1 & Serializable & scala.Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)f)), (DataType)FloatType$.MODULE$));
                this.bitmap$0 |= 0x10;
            }
        }
        return this.floatLiteralGen;
    }

    public Gen<Literal> floatLiteralGen() {
        return (this.bitmap$0 & 0x10) == 0 ? this.floatLiteralGen$lzycompute() : this.floatLiteralGen;
    }

    private Gen<Literal> doubleLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.doubleLiteralGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToDouble((double)(Double$.MODULE$.MinValue() / (double)2)), (Object)BoxesRunTime.boxToDouble((double)8.988465674311579E307), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}), (Numeric)Numeric.DoubleIsFractional$.MODULE$, Gen.Choose$.MODULE$.chooseDouble()).map((Function1 & Serializable & scala.Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)f)), (DataType)DoubleType$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.doubleLiteralGen;
    }

    public Gen<Literal> doubleLiteralGen() {
        return (this.bitmap$0 & 0x20) == 0 ? this.doubleLiteralGen$lzycompute() : this.doubleLiteralGen;
    }

    public Gen<Literal> decimalLiteralGen(int precision, int scale) {
        Predef$.MODULE$.assert(scale >= 0);
        Predef$.MODULE$.assert(precision >= scale);
        return Arbitrary$.MODULE$.arbBigInt().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> {
            String a = s.$percent(package$.MODULE$.BigInt().apply(10).pow(precision - scale)).toString();
            String b = s.$percent(package$.MODULE$.BigInt().apply(10).pow(scale)).abs().toString();
            return Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(new StringBuilder(1).append(a).append(".").append(b).toString()), precision, scale), (DataType)new DecimalType(precision, scale));
        });
    }

    private Gen<Literal> stringLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.stringLiteralGen = Arbitrary$.MODULE$.arbString().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> Literal$.MODULE$.create(s, (DataType)StringType$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.stringLiteralGen;
    }

    public Gen<Literal> stringLiteralGen() {
        return (this.bitmap$0 & 0x40) == 0 ? this.stringLiteralGen$lzycompute() : this.stringLiteralGen;
    }

    private Gen<Literal> binaryLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryLiteralGen = Gen$.MODULE$.listOf((Function0 & Serializable & scala.Serializable)() -> Arbitrary$.MODULE$.arbByte().arbitrary()).map((Function1 & Serializable & scala.Serializable)ab -> Literal$.MODULE$.create(ab.toArray(ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.binaryLiteralGen;
    }

    public Gen<Literal> binaryLiteralGen() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryLiteralGen$lzycompute() : this.binaryLiteralGen;
    }

    private Gen<Literal> booleanLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.booleanLiteralGen = Arbitrary$.MODULE$.arbBool().arbitrary().map((Function1 & Serializable & scala.Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b)), (DataType)BooleanType$.MODULE$));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.booleanLiteralGen;
    }

    public Gen<Literal> booleanLiteralGen() {
        return (this.bitmap$0 & 0x100) == 0 ? this.booleanLiteralGen$lzycompute() : this.booleanLiteralGen;
    }

    private Gen<Literal> dateLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.dateLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.create((Object)new Date(BoxesRunTime.unboxToInt((Object)d)), (DataType)DateType$.MODULE$));
                this.bitmap$0 |= 0x200;
            }
        }
        return this.dateLiteralGen;
    }

    public Gen<Literal> dateLiteralGen() {
        return (this.bitmap$0 & 0x200) == 0 ? this.dateLiteralGen$lzycompute() : this.dateLiteralGen;
    }

    private Gen<Literal> timestampLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.timestampLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable & scala.Serializable)t -> Literal$.MODULE$.create((Object)new Timestamp(BoxesRunTime.unboxToLong((Object)t)), (DataType)TimestampType$.MODULE$));
                this.bitmap$0 |= 0x400;
            }
        }
        return this.timestampLiteralGen;
    }

    public Gen<Literal> timestampLiteralGen() {
        return (this.bitmap$0 & 0x400) == 0 ? this.timestampLiteralGen$lzycompute() : this.timestampLiteralGen;
    }

    private Gen<Literal> calendarIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.calendarIntervalLiterGen = Arbitrary$.MODULE$.arbInt().arbitrary().flatMap((Function1 & Serializable & scala.Serializable)m -> LiteralGenerator$.$anonfun$calendarIntervalLiterGen$1(BoxesRunTime.unboxToInt((Object)m)));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.calendarIntervalLiterGen;
    }

    public Gen<Literal> calendarIntervalLiterGen() {
        return (this.bitmap$0 & 0x800) == 0 ? this.calendarIntervalLiterGen$lzycompute() : this.calendarIntervalLiterGen;
    }

    private Gen<Literal> limitedIntegerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.limitedIntegerLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)-100), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable & scala.Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.limitedIntegerLiteralGen;
    }

    public Gen<Literal> limitedIntegerLiteralGen() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.limitedIntegerLiteralGen$lzycompute() : this.limitedIntegerLiteralGen;
    }

    public Gen<Literal> randomGen(DataType dt) {
        DecimalType decimalType;
        Option option;
        Gen<Literal> gen;
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            gen = this.byteLiteralGen();
        } else if (ShortType$.MODULE$.equals(dataType)) {
            gen = this.shortLiteralGen();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            gen = this.integerLiteralGen();
        } else if (LongType$.MODULE$.equals(dataType)) {
            gen = this.longLiteralGen();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            gen = this.doubleLiteralGen();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            gen = this.floatLiteralGen();
        } else if (DateType$.MODULE$.equals(dataType)) {
            gen = this.dateLiteralGen();
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            gen = this.timestampLiteralGen();
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            gen = this.booleanLiteralGen();
        } else if (StringType$.MODULE$.equals(dataType)) {
            gen = this.stringLiteralGen();
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            gen = this.binaryLiteralGen();
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            gen = this.calendarIntervalLiterGen();
        } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            gen = this.decimalLiteralGen(precision, scale);
        } else {
            throw new IllegalArgumentException(new StringBuilder(19).append("not supported type ").append(dataType).toString());
        }
        return gen;
    }

    public static final /* synthetic */ Gen $anonfun$calendarIntervalLiterGen$1(int m) {
        return Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable & scala.Serializable)s -> Literal$.MODULE$.create((Object)new CalendarInterval(m, BoxesRunTime.unboxToLong((Object)s)), (DataType)CalendarIntervalType$.MODULE$));
    }

    private LiteralGenerator$() {
        MODULE$ = this;
    }
}

