/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.DecimalLiteral$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.util.SizeEstimator$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4A\u0001C\u0005\u00011!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rq\u0002\u0001\u0015!\u0003/\u0011\u0015i\u0004\u0001\"\u0003?\u0011\u0015q\u0006\u0001\"\u0003`\u0005i\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016\u001cV/\u001b;f\u0015\tQ1\"A\u0005bO\u001e\u0014XmZ1uK*\u0011A\"D\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u000f\u001f\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002#%\u0011A$\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005I\u0011A\u0002:b]\u0012|W.F\u0001$!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012aAU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u0005I\u0006$\u0018-F\u0001/!\ryc\u0007O\u0007\u0002a)\u0011\u0011GM\u0001\nS6lW\u000f^1cY\u0016T!a\r\u001b\u0002\u0015\r|G\u000e\\3di&|gNC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9\u0004G\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"!\u000f\u001e\u000e\u0003QJ!a\u000f\u001b\u0003\u0007%sG/A\u0003eCR\f\u0007%A\u0007d_6\u0004\u0018M]3FcV\fGn\u001d\u000b\u0004\u007f\tc\u0006CA\u001dA\u0013\t\tEGA\u0004C_>dW-\u00198\t\u000b\r3\u0001\u0019\u0001#\u0002\t1,g\r\u001e\t\u0003\u000bfs!AR,\u000f\u0005\u001d3fB\u0001%V\u001d\tIEK\u0004\u0002K':\u00111J\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!aT\f\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AC\u0006\n\u0005aK\u0011!F!qaJ|\u00070[7bi\u0016\u0004VM]2f]RLG.Z\u0005\u00035n\u0013\u0001\u0003U3sG\u0016tG/\u001b7f\t&<Wm\u001d;\u000b\u0005aK\u0001\"B/\u0007\u0001\u0004!\u0015!\u0002:jO\"$\u0018aC1tg\u0016\u0014H/R9vC2,\"\u0001Y4\u0015\u0007\u0005$\u0007\u000f\u0005\u0002:E&\u00111\r\u000e\u0002\u0005+:LG\u000fC\u0003D\u000f\u0001\u0007Q\r\u0005\u0002gO2\u0001A!\u00025\b\u0005\u0004I'!\u0001+\u0012\u0005)l\u0007CA\u001dl\u0013\taGGA\u0004O_RD\u0017N\\4\u0011\u0005er\u0017BA85\u0005\r\te.\u001f\u0005\u0006;\u001e\u0001\r!\u001a")
public class ApproximatePercentileSuite
extends SparkFunSuite {
    private final Random random = new Random();
    private final IndexedSeq<Object> data = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> this.random().nextInt(10000), IndexedSeq$.MODULE$.canBuildFrom());

    private Random random() {
        return this.random;
    }

    private IndexedSeq<Object> data() {
        return this.data;
    }

    private boolean compareEquals(ApproximatePercentile.PercentileDigest left, ApproximatePercentile.PercentileDigest right) {
        QuantileSummaries leftSummary = left.quantileSummaries();
        QuantileSummaries rightSummary = right.quantileSummaries();
        return leftSummary.compressThreshold() == rightSummary.compressThreshold() && leftSummary.relativeError() == rightSummary.relativeError() && leftSummary.count() == rightSummary.count() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftSummary.sampled())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rightSummary.sampled()));
    }

    private <T> void assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
    }

    public static final /* synthetic */ void $anonfun$new$5(double relativeError$1, ApproximatePercentile.PercentileDigest buffer$2, IndexedSeq group) {
        ApproximatePercentile.PercentileDigest partialBuffer = new ApproximatePercentile.PercentileDigest(relativeError$1);
        group.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> partialBuffer.add((double)x));
        buffer$2.merge(partialBuffer);
    }

    public static final /* synthetic */ Assertion $anonfun$new$10(ApproximatePercentileSuite $this, double relativeError$2, double memoryFootPrintUpperBound$1, int count) {
        ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(relativeError$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> buffer.add((double)x$4));
        long $org_scalatest_assert_macro_left = SizeEstimator$.MODULE$.estimate((Object)buffer);
        double $org_scalatest_assert_macro_right = memoryFootPrintUpperBound$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), (double)$org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ ApproximatePercentile.PercentileDigest $anonfun$new$15(Range data$1, ApproximatePercentile agg$1, ApproximatePercentile.PercentileDigest group1Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data$1.apply$mcII$sp(index))}));
        return agg$1.update(group1Buffer$1, input);
    }

    public static final /* synthetic */ ApproximatePercentile.PercentileDigest $anonfun$new$16(Range data$1, ApproximatePercentile agg$1, ApproximatePercentile.PercentileDigest group2Buffer$1, int index) {
        InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data$1.apply$mcII$sp(index))}));
        return agg$1.update(group2Buffer$1, input);
    }

    public static final /* synthetic */ boolean $anonfun$new$17(int error$1, Tuple2 pair) {
        return Math.abs(pair._1$mcD$sp() - pair._2$mcD$sp()) < (double)error$1;
    }

    public ApproximatePercentileSuite() {
        this.test("serialize and de-serialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ApproximatePercentile.PercentileDigestSerializer serializer = new ApproximatePercentile.PercentileDigestSerializer();
            ApproximatePercentile.PercentileDigest emptyBuffer = new ApproximatePercentile.PercentileDigest(0.01);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer))), "ApproximatePercentileSuite.this.compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer)))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(0.01);
            this.data().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> buffer.add((double)value));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer))), "ApproximatePercentileSuite.this.compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer)))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            ApproximatePercentile agg = new ApproximatePercentile((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer), "ApproximatePercentileSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("class PercentileDigest, basic operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int valueCount = 10000;
            double[] percentages = new double[]{0.25, 0.5, 0.75};
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0E-4, 0.001, 0.01, 0.1}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)relativeError -> {
                ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(relativeError);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), valueCount).grouped(10).foreach((Function1 & Serializable & scala.Serializable)group -> {
                    ApproximatePercentileSuite.$anonfun$new$5(relativeError, buffer, group);
                    return BoxedUnit.UNIT;
                });
                double[] expectedPercentiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentages)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 * (double)valueCount, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] approxPercentiles = buffer.getPercentiles(new double[]{0.25, 0.5, 0.75});
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedPercentiles)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(approxPercentiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)pair -> {
                    Tuple2 tuple2 = pair;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double expected = tuple2._1$mcD$sp();
                    double estimate = tuple2._2$mcD$sp();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(expected, estimate);
                    Tuple2.mcDD.sp sp3 = sp2;
                    double expected2 = sp3._1$mcD$sp();
                    double estimate2 = sp3._2$mcD$sp();
                    double $org_scalatest_assert_macro_left = (estimate2 - expected2) / (double)valueCount;
                    double $org_scalatest_assert_macro_right = relativeError;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                });
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("class PercentileDigest, makes sure the memory foot print is bounded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double relativeError = 0.01;
            long headBufferSize = SizeEstimator$.MODULE$.estimate((Object)new double[QuantileSummaries$.MODULE$.defaultHeadSize()]);
            double bufferSize = (double)SizeEstimator$.MODULE$.estimate((Object)new QuantileSummaries.Stats(0.0, 0L, 0L)) * (1.0 / relativeError) * (double)2;
            double memoryFootPrintUpperBound = ((double)headBufferSize + bufferSize) * (double)2;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 1000, 10000, 100000, 1000000, 10000000}))).foreach((Function1 & Serializable & scala.Serializable)count -> ApproximatePercentileSuite.$anonfun$new$10(this, relativeError, memoryFootPrintUpperBound, BoxesRunTime.unboxToInt((Object)count)));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("class ApproximatePercentile, high level interface, update, merge, eval...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int count = 10000;
            Range data = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10000).toSeq();
            double[] percentages = new double[]{0.25, 0.5, 0.75};
            int accuracy = 10000;
            double[] expectedPercentiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentages)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> (double)count * x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, false), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
            CreateArray percentageExpression = new CreateArray((Seq)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentages)).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$6))), Seq$.MODULE$.canBuildFrom()));
            Literal accuracyExpression = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000));
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)percentageExpression, (Expression)accuracyExpression);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.nullable(), "agg.nullable", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Range group1 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.length() / 2);
            ApproximatePercentile.PercentileDigest group1Buffer = agg.createAggregationBuffer();
            group1.foreach((Function1 & Serializable & scala.Serializable)index -> ApproximatePercentileSuite.$anonfun$new$15(data, agg, group1Buffer, BoxesRunTime.unboxToInt((Object)index)));
            Range group2 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() / 2), data.length());
            ApproximatePercentile.PercentileDigest group2Buffer = agg.createAggregationBuffer();
            group2.foreach((Function1 & Serializable & scala.Serializable)index -> ApproximatePercentileSuite.$anonfun$new$16(data, agg, group2Buffer, BoxesRunTime.unboxToInt((Object)index)));
            ApproximatePercentile.PercentileDigest mergeBuffer = agg.createAggregationBuffer();
            agg.merge(mergeBuffer, group1Buffer);
            agg.merge(mergeBuffer, group2Buffer);
            Object object = agg.eval(mergeBuffer);
            if (!(object instanceof ArrayData)) {
                throw new MatchError(object);
            }
            ArrayData arrayData = (ArrayData)object;
            int error = count / accuracy;
            double[] percentiles = arrayData.toDoubleArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(expectedPercentiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ApproximatePercentileSuite.$anonfun$new$17(error, pair))), "scala.Predef.refArrayOps[(Double, Double)](scala.Predef.doubleArrayOps(percentiles).zip[Double, Double, Array[(Double, Double)]](scala.Predef.wrapDoubleArray(expectedPercentiles))(scala.this.Array.canBuildFrom[(Double, Double)]((ClassTag.apply[(Double, Double)](classOf[scala.Tuple2]): scala.reflect.ClassTag[(Double, Double)])))).forall(((pair: (Double, Double)) => java.lang.Math.abs(pair._1.-(pair._2)).<(error)))", Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            return assertion;
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("class ApproximatePercentile, low level interface, update, merge, eval...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
            int inputAggregationBufferOffset = 1;
            int mutableAggregationBufferOffset = 2;
            double percentage = 0.5;
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)percentage))).withNewInputAggBufferOffset(inputAggregationBufferOffset).withNewMutableAggBufferOffset(mutableAggregationBufferOffset);
            GenericInternalRow mutableAggBuffer = new GenericInternalRow(new Object[mutableAggregationBufferOffset + 1]);
            agg.initialize((InternalRow)mutableAggBuffer);
            int dataCount = 10;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), dataCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)data -> agg.update((InternalRow)mutableAggBuffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data)}))));
            agg.serializeAggregateBufferInPlace((InternalRow)mutableAggBuffer);
            byte[] serialized = mutableAggBuffer.getBinary(mutableAggregationBufferOffset);
            GenericInternalRow inputAggBuffer = new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, serialized}), ClassTag$.MODULE$.Any()));
            agg.initialize((InternalRow)mutableAggBuffer);
            agg.merge((InternalRow)mutableAggBuffer, (InternalRow)inputAggBuffer);
            double expectedPercentile = (double)dataCount * percentage;
            double $org_scalatest_assert_macro_left = Math.abs(BoxesRunTime.unboxToDouble((Object)agg.eval((InternalRow)mutableAggBuffer)) - expectedPercentile);
            double $org_scalatest_assert_macro_right = 0.1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("class ApproximatePercentile, sql string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int defaultAccuracy = ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
            this.assertEqual(new StringBuilder(30).append("percentile_approx(`a`, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql());
            this.assertEqual(new StringBuilder(51).append("percentile_approx(`a`, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1 & Serializable & scala.Serializable)x$7 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$7))), Seq$.MODULE$.canBuildFrom()))).sql());
            this.assertEqual(new StringBuilder(30).append("percentile_approx(`a`, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(false));
            this.assertEqual(new StringBuilder(51).append("percentile_approx(`a`, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1 & Serializable & scala.Serializable)x$8 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$8))), Seq$.MODULE$.canBuildFrom()))).sql(false));
            this.assertEqual(new StringBuilder(39).append("percentile_approx(DISTINCT `a`, 0.5D, ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(true));
            this.assertEqual(new StringBuilder(60).append("percentile_approx(DISTINCT `a`, array(0.25D, 0.5D, 0.75D), ").append(defaultAccuracy).append(")").toString(), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1 & Serializable & scala.Serializable)x$9 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$9))), Seq$.MODULE$.canBuildFrom()))).sql(true));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("class ApproximatePercentile, fails analysis if percentage or accuracy is not a constant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "a";
            DoubleType$ x$2 = DoubleType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            AttributeReference attribute = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "b";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12));
            this.assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
            ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)attribute, (Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000)));
            this.assertEqual(wrongPercentage.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("class ApproximatePercentile, fails analysis if parameters are invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$13 = "a";
            DoubleType$ x$14 = DoubleType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
            ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1)));
            this.assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy provided must be a positive integer literal (current value = -1)"));
            Seq correctPercentageExpresions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 0.5}))).map((Function1 & Serializable & scala.Serializable)x$10 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$10))), Seq$.MODULE$.canBuildFrom()))}));
            correctPercentageExpresions.foreach((Function1 & Serializable & scala.Serializable)percentageExpression -> {
                String x$19 = "a";
                DoubleType$ x$20 = DoubleType$.MODULE$;
                boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
                Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
                ApproximatePercentile correctPercentage = new ApproximatePercentile((Expression)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                return correctPercentage.checkInputDataTypes();
            });
            Seq wrongPercentageExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)-0.5)), new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 1.1}))).map((Function1 & Serializable & scala.Serializable)x$11 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$11))), Seq$.MODULE$.canBuildFrom()))}));
            wrongPercentageExpressions.foreach((Function1 & Serializable & scala.Serializable)percentageExpression -> {
                TypeCheckResult.TypeCheckFailure typeCheckFailure;
                String msg;
                Seq x$30;
                ExprId x$29;
                Metadata x$28;
                String x$25 = "a";
                DoubleType$ x$26 = DoubleType$.MODULE$;
                boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
                ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)new AttributeReference(x$25, (DataType)x$26, x$27, x$28 = AttributeReference$.MODULE$.apply$default$4(), x$29 = AttributeReference$.MODULE$.apply$default$5(x$25, (DataType)x$26, x$27, x$28), x$30 = AttributeReference$.MODULE$.apply$default$6(x$25, (DataType)x$26, x$27, x$28)), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                TypeCheckResult typeCheckResult = wrongPercentage.checkInputDataTypes();
                boolean bl = typeCheckResult instanceof TypeCheckResult.TypeCheckFailure && (msg = (typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult).message()).contains("must be between 0.0 and 1.0");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "wrongPercentage.checkInputDataTypes() match {\n  case (message: String)org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure((msg @ _)) if msg.contains(\"must be between 0.0 and 1.0\") => true\n  case _ => false\n}", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("class ApproximatePercentile, automatically add type casting for parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()}));
            Seq accuracyExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), DecimalLiteral$.MODULE$.apply(10000L), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)123.0))}));
            Seq percentageExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), DecimalLiteral$.MODULE$.apply(0.5), new CreateArray((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), DecimalLiteral$.MODULE$.apply(0.7)})))}));
            accuracyExpressions.foreach((Function1 & Serializable & scala.Serializable)accuracyExpression -> {
                percentageExpressions.foreach((Function1 & Serializable & scala.Serializable)percentageExpression -> {
                    Bool bool;
                    Bool $org_scalatest_assert_macro_left;
                    ApproximatePercentile approximatePercentile;
                    Alias alias;
                    Expression agg;
                    ApproximatePercentile agg2 = new ApproximatePercentile((Expression)UnresolvedAttribute$.MODULE$.apply("a"), percentageExpression, (Expression)accuracyExpression);
                    Expression analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)testRelation$1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
                    Expression expression = analyzed;
                    if (expression instanceof Alias && (agg = (alias = (Alias)expression).child()) instanceof ApproximatePercentile) {
                        approximatePercentile = (ApproximatePercentile)agg;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(approximatePercentile.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                        DataType $org_scalatest_assert_macro_left2 = approximatePercentile.child().dataType();
                        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
                        DataType dataType = $org_scalatest_assert_macro_left2;
                        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
                        DataType $org_scalatest_assert_macro_left3 = approximatePercentile.percentageExpression().dataType();
                        DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
                        DataType dataType2 = $org_scalatest_assert_macro_left3;
                        DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
                        $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
                        if ($org_scalatest_assert_macro_left.value()) {
                            bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                        } else {
                            DataType $org_scalatest_assert_macro_left4 = approximatePercentile.percentageExpression().dataType();
                            ArrayType $org_scalatest_assert_macro_right3 = new ArrayType((DataType)DoubleType$.MODULE$, false);
                            DataType dataType3 = $org_scalatest_assert_macro_left4;
                            ArrayType arrayType = $org_scalatest_assert_macro_right3;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                        }
                    } else {
                        throw $this.fail(new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
                    }
                    Bool $org_scalatest_assert_macro_right = bool;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
                    DataType $org_scalatest_assert_macro_left5 = approximatePercentile.accuracyExpression().dataType();
                    IntegerType$ $org_scalatest_assert_macro_right4 = IntegerType$.MODULE$;
                    DataType dataType = $org_scalatest_assert_macro_left5;
                    IntegerType$ integerType$ = $org_scalatest_assert_macro_right4;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                    Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                    return assertion;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("class ApproximatePercentile, null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
            ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var7_6 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var11_10 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            Object $org_scalatest_assert_macro_left3 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var15_14 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, object3 == null ? var15_14 != null : !object3.equals(var15_14), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }
}

