/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.optimizer.CollapseProjectSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G\u001d)a\u0005\u0001E\u0001O\u0019)\u0011\u0006\u0001E\u0001U!)!e\u0001C\u0001o!9\u0001h\u0001b\u0001\n\u0003I\u0004B\u0002%\u0004A\u0003%!\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0005Q\u0019u\u000e\u001c7baN,\u0007K]8kK\u000e$8+^5uK*\u00111\u0002D\u0001\n_B$\u0018.\\5{KJT!!\u0004\b\u0002\u0011\r\fG/\u00197zgRT!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\r\u001d!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?1\tQ\u0001\u001d7b]NL!!\t\u0010\u0003\u0011Ac\u0017M\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0006\u0002\u0011=\u0003H/[7ju\u0016\u0004\"\u0001K\u0002\u000e\u0003\u0001\u0011\u0001b\u00149uS6L'0Z\n\u0003\u0007-\u00022\u0001L\u00182\u001b\u0005i#B\u0001\u0018\r\u0003\u0015\u0011X\u000f\\3t\u0013\t\u0001TF\u0001\u0007Sk2,W\t_3dkR|'\u000f\u0005\u00023k5\t1G\u0003\u00025=\u00059An\\4jG\u0006d\u0017B\u0001\u001c4\u0005-aunZ5dC2\u0004F.\u00198\u0015\u0003\u001d\nqAY1uG\",7/F\u0001;!\rY$\tR\u0007\u0002y)\u0011QHP\u0001\nS6lW\u000f^1cY\u0016T!a\u0010!\u0002\u0015\r|G\u000e\\3di&|gNC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019EH\u0001\u0003MSN$\bCA#G\u001b\u0005\u0019\u0011BA$0\u0005\u0015\u0011\u0015\r^2i\u0003!\u0011\u0017\r^2iKN\u0004\u0013\u0001\u0004;fgR\u0014V\r\\1uS>tW#A&\u0011\u0005Ib\u0015BA'4\u00055aunY1m%\u0016d\u0017\r^5p]\u0006iA/Z:u%\u0016d\u0017\r^5p]\u0002\u0002")
public class CollapseProjectSuite
extends SparkFunSuite
implements PlanTest {
    private volatile CollapseProjectSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public CollapseProjectSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        CollapseProjectSuite collapseProjectSuite = this;
        synchronized (collapseProjectSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new CollapseProjectSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$9(NamedExpression x$3) {
        return x$3.metadata().contains("key");
    }

    private static final boolean hasMetadata$1(LogicalPlan logicalPlan) {
        return ((Project)logicalPlan).projectList().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollapseProjectSuite.$anonfun$new$9(x$3)));
    }

    public CollapseProjectSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
        this.test("collapse two deterministic, independent projects into one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "b_plus_1"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "b_plus_1"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("collapse two deterministic, dependent projects into one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_2")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1"))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_2")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("do not collapse nondeterministic projects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "rand")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "rand1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "rand")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(2))).as((Symbol)SymbolLiteral.bootstrap("apply", "rand2"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(query).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("collapse two nondeterministic, independent projects into one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(20L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand2"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(20L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand2"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("collapse one nondeterministic, one deterministic, independent projects into one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("collapse project into aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "b_plus_1"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "a_plus_1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "b_plus_1"))}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("do not collapse common nondeterministic project and aggregate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)Rand$.MODULE$.apply(10L)).as((Symbol)SymbolLiteral.bootstrap("apply", "rand"))}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "rand")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "rand1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "rand")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(2))).as((Symbol)SymbolLiteral.bootstrap("apply", "rand2"))}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(query).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("preserve top-level alias metadata while collapsing projects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Metadata metadata = new MetadataBuilder().putLong("key", 1L).build();
            Alias[] aliasArray = new Alias[1];
            UnresolvedAttribute x$1 = package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a_with_metadata"));
            String x$2 = "b";
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
            Alias[] aliasArray2 = new Alias[1];
            UnresolvedAttribute x$6 = package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"));
            String x$7 = "a_with_metadata";
            Some x$8 = new Some((Object)metadata);
            ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$6, x$7);
            Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$6, x$7);
            aliasArray2[0] = new Alias((Expression)x$6, x$7, x$9, x$10, (Option)x$8);
            LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray2)), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).logicalPlan()))).analyze();
            Predef$.MODULE$.require(CollapseProjectSuite.hasMetadata$1(analyzed));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)analyzed);
            Seq projects = optimized.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Project project;
                    A1 A1 = x1;
                    Object object = A1 instanceof Project ? (project = (Project)A1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Project;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)projects.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(CollapseProjectSuite.hasMetadata$1(optimized), "hasMetadata(optimized)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("CollapseProjectSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }
}

