/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.InferFiltersFromConstraintsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4AAC\u0006\u00011!)1\u0005\u0001C\u0001I\u001d)q\u0005\u0001E\u0001Q\u0019)!\u0006\u0001E\u0001W!)1e\u0001C\u0001q!9\u0011h\u0001b\u0001\n\u0003Q\u0004BB%\u0004A\u0003%1\bC\u0004K\u0001\t\u0007I\u0011A&\t\r=\u0003\u0001\u0015!\u0003M\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0005\u0001JeNZ3s\r&dG/\u001a:t\rJ|WnQ8ogR\u0014\u0018-\u001b8ugN+\u0018\u000e^3\u000b\u00051i\u0011!C8qi&l\u0017N_3s\u0015\tqq\"\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011$\b\t\u00035mi\u0011!E\u0005\u00039E\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u000e\u0003\u0015\u0001H.\u00198t\u0013\t\u0011sD\u0001\u0005QY\u0006tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t1\"\u0001\u0005PaRLW.\u001b>f!\tI3!D\u0001\u0001\u0005!y\u0005\u000f^5nSj,7CA\u0002-!\ri\u0003GM\u0007\u0002])\u0011q&D\u0001\u0006eVdWm]\u0005\u0003c9\u0012ABU;mK\u0016CXmY;u_J\u0004\"a\r\u001c\u000e\u0003QR!!N\u0010\u0002\u000f1|w-[2bY&\u0011q\u0007\u000e\u0002\f\u0019><\u0017nY1m!2\fg\u000eF\u0001)\u0003\u001d\u0011\u0017\r^2iKN,\u0012a\u000f\t\u0004y\r+U\"A\u001f\u000b\u0005yz\u0014!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0015)\u0001\u0006d_2dWm\u0019;j_:T\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\tv\u0012A\u0001T5tiB\u0011aiR\u0007\u0002\u0007%\u0011\u0001\n\r\u0002\u0006\u0005\u0006$8\r[\u0001\tE\u0006$8\r[3tA\u0005aA/Z:u%\u0016d\u0017\r^5p]V\tA\n\u0005\u00024\u001b&\u0011a\n\u000e\u0002\u000e\u0019>\u001c\u0017\r\u001c*fY\u0006$\u0018n\u001c8\u0002\u001bQ,7\u000f\u001e*fY\u0006$\u0018n\u001c8!\u0003a!Xm\u001d;D_:\u001cHO]1j]R\u001c\u0018I\u001a;fe*{\u0017N\u001c\u000b\u0007%ZC&\f\u00180\u0011\u0005M#V\"A!\n\u0005U\u000b%\u0001B+oSRDQaV\u0005A\u0002I\n\u0011\u0001\u001f\u0005\u00063&\u0001\rAM\u0001\u0002s\")1,\u0003a\u0001e\u0005aQ\r\u001f9fGR,G\rT3gi\")Q,\u0003a\u0001e\u0005iQ\r\u001f9fGR,GMU5hQRDQaX\u0005A\u0002\u0001\f\u0001B[8j]RK\b/\u001a\t\u0003=\u0005L!AY\u0010\u0003\u0011){\u0017N\u001c+za\u0016\u0004")
public class InferFiltersFromConstraintsSuite
extends SparkFunSuite
implements PlanTest {
    private volatile InferFiltersFromConstraintsSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public InferFiltersFromConstraintsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private void testConstraintsAfterJoin(LogicalPlan x, LogicalPlan y, LogicalPlan expectedLeft, LogicalPlan expectedRight, JoinType joinType) {
        Some condition = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr()));
        LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, joinType, (Option)condition)).analyze();
        LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(expectedLeft).join(expectedRight, joinType, (Option)condition)).analyze();
        LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
        this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
    }

    private final void Optimize$lzycompute$1() {
        InferFiltersFromConstraintsSuite inferFiltersFromConstraintsSuite = this;
        synchronized (inferFiltersFromConstraintsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new InferFiltersFromConstraintsSuite$Optimize$(this);
            }
        }
    }

    public InferFiltersFromConstraintsSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
        this.test("filter: filter out constraints in condition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).analyze();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("single inner join: filter out values on either side on equi-join keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$1 = y;
            Some x$2 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.c").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            JoinType x$3 = qual$1.join$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$1.join(x$1, x$3, (Option)x$2)).analyze();
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.c").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$4 = right;
            Some x$5 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr()));
            JoinType x$6 = qual$2.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$2.join(x$4, x$6, (Option)x$5)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("single inner join: filter out nulls on either side on non equal keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(x);
            LogicalPlan x$7 = y;
            Some x$8 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.c").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            JoinType x$9 = qual$3.join$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$3.join(x$7, x$9, (Option)x$8)).analyze();
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.c").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$10 = right;
            Some x$11 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr()));
            JoinType x$12 = qual$4.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$4.join(x$10, x$12, (Option)x$11)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("single inner join with pre-existing filters: filter out values on either side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan x$13 = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10)));
            Some x$14 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())));
            JoinType x$15 = qual$5.join$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$5.join(x$13, x$15, (Option)x$14)).analyze();
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10)))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10)))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(left);
            LogicalPlan x$16 = right;
            Some x$17 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.b").attr())));
            JoinType x$18 = qual$6.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$6.join(x$16, x$18, (Option)x$17)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("single outer join: no null filters are generated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)FullOuter$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("multiple inner joins: filter out values on all sides on equi-join keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan t1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t1"));
            LogicalPlan t2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t2"));
            LogicalPlan t3 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t3"));
            LogicalPlan t4 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t4"));
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan x$19 = t2;
            Some x$20 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t1.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.b").attr()));
            JoinType x$21 = qual$7.join$default$2();
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(qual$7.join(x$19, x$21, (Option)x$20));
            LogicalPlan x$22 = t3;
            Some x$23 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t2.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t3.b").attr()));
            JoinType x$24 = qual$8.join$default$2();
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(qual$8.join(x$22, x$24, (Option)x$23));
            LogicalPlan x$25 = t4;
            Some x$26 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t3.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t4.b").attr()));
            JoinType x$27 = qual$9.join$default$2();
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(qual$9.join(x$25, x$27, (Option)x$26)).analyze();
            package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))));
            LogicalPlan x$28 = package.plans$.MODULE$.DslLogicalPlan(t2).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            Some x$29 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t1.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.b").attr()));
            JoinType x$30 = qual$10.join$default$2();
            package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(qual$10.join(x$28, x$30, (Option)x$29));
            LogicalPlan x$31 = package.plans$.MODULE$.DslLogicalPlan(t3).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            Some x$32 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t2.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t3.b").attr()));
            JoinType x$33 = qual$11.join$default$2();
            package.plans$.DslLogicalPlan qual$12 = package.plans$.MODULE$.DslLogicalPlan(qual$11.join(x$31, x$33, (Option)x$32));
            LogicalPlan x$34 = package.plans$.MODULE$.DslLogicalPlan(t4).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            Some x$35 = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t3.b").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t4.b").attr()));
            JoinType x$36 = qual$12.join$default$2();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(qual$12.join(x$34, x$36, (Option)x$35)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("inner join with filter: filter out values on all sides on equi-join keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).analyze();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))))).join(package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))), (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr())))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("inner join with alias: alias contains multiple attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan t1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t1"));
            LogicalPlan t2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t2"));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))).as((Symbol)SymbolLiteral.bootstrap("apply", "int_col"))}))).as("t")).join(t2, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.int_col").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr()))))).analyze();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))).as((Symbol)SymbolLiteral.bootstrap("apply", "int_col"))}))).as("t")).join(package.plans$.MODULE$.DslLogicalPlan(t2).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.int_col").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr()))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("inner join with alias: alias contains single attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan t1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t1"));
            LogicalPlan t2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t2"));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).as("t")).join(t2, (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr()))))).analyze();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).as("t")).join(package.plans$.MODULE$.DslLogicalPlan(t2).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), (JoinType)Inner$.MODULE$, (Option)new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr())).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("t.d").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("t2.a").attr()))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("generate correct filters for alias that don't produce recursive constraints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan t1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "t1"));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "y"))}))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "y")))))).analyze();
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(t1).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))))).$amp$amp((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "x")), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "y"))}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("No inferred filter when constraint propagation is disabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CONSTRAINT_PROPAGATION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }), new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("constraints should be inferred from aliased literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalLeft = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "left"))).as("left");
            LogicalPlan optimizedLeft = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "left"))).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(2))))).as("left");
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).as("two")})), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "right")))).as("right");
            Some condition = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("left.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("right.two").attr()));
            LogicalPlan original = package.plans$.MODULE$.DslLogicalPlan(originalLeft).join(right, (JoinType)Inner$.MODULE$, (Option)condition);
            LogicalPlan correct = package.plans$.MODULE$.DslLogicalPlan(optimizedLeft).join(right, (JoinType)Inner$.MODULE$, (Option)condition);
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(original).analyze()), package.plans$.MODULE$.DslLogicalPlan(correct).analyze(), this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("SPARK-23405: left-semi equal-join should filter out null join keys on both sides", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            this.testConstraintsAfterJoin(x, y, package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), (JoinType)LeftSemi$.MODULE$);
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("SPARK-21479: Outer join after-join filters push down to null-supplying side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            Some condition = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr()));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(y, (JoinType)LeftOuter$.MODULE$, (Option)condition)).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).analyze();
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)LeftOuter$.MODULE$, (Option)condition)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("SPARK-21479: Outer join pre-existing filters push down to null-supplying side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            Some condition = new Some((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("x.a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslString("y.a").attr()));
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(x).join(package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("y.a").attr()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))), (JoinType)RightOuter$.MODULE$, (Option)condition)).analyze();
            LogicalPlan left = package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan right = package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5))));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(left).join(right, (JoinType)RightOuter$.MODULE$, (Option)condition)).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("SPARK-21479: Outer join no filter push down to preserved side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            this.testConstraintsAfterJoin(x, package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslString("a").attr()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))), x, package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))), (JoinType)LeftOuter$.MODULE$);
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("SPARK-23564: left anti join should filter out null join keys on right side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            this.testConstraintsAfterJoin(x, y, x, package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), (JoinType)LeftAnti$.MODULE$);
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("SPARK-23564: left outer join should filter out null join keys on right side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            this.testConstraintsAfterJoin(x, y, x, package.plans$.MODULE$.DslLogicalPlan(y).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), (JoinType)LeftOuter$.MODULE$);
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("SPARK-23564: right outer join should filter out null join keys on left side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan x = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "x"));
            LogicalPlan y = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).subquery((Symbol)SymbolLiteral.bootstrap("apply", "y"));
            this.testConstraintsAfterJoin(x, y, package.plans$.MODULE$.DslLogicalPlan(x).where((Expression)new IsNotNull((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))), y, (JoinType)RightOuter$.MODULE$);
        }, new Position("InferFiltersFromConstraintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
    }
}

