/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.optimizer.LikeSimplificationSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G\u001d)a\u0005\u0001E\u0001O\u0019)\u0011\u0006\u0001E\u0001U!)!e\u0001C\u0001o!9\u0001h\u0001b\u0001\n\u0003I\u0004B\u0002%\u0004A\u0003%!\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0005]a\u0015n[3TS6\u0004H.\u001b4jG\u0006$\u0018n\u001c8Tk&$XM\u0003\u0002\f\u0019\u0005Iq\u000e\u001d;j[&TXM\u001d\u0006\u0003\u001b9\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0004\u0001aa\u0002CA\r\u001b\u001b\u0005\u0001\u0012BA\u000e\u0011\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004D\u0001\u0006a2\fgn]\u0005\u0003Cy\u0011\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003)\t\u0001b\u00149uS6L'0\u001a\t\u0003Q\ri\u0011\u0001\u0001\u0002\t\u001fB$\u0018.\\5{KN\u00111a\u000b\t\u0004Y=\nT\"A\u0017\u000b\u00059b\u0011!\u0002:vY\u0016\u001c\u0018B\u0001\u0019.\u00051\u0011V\u000f\\3Fq\u0016\u001cW\u000f^8s!\t\u0011T'D\u00014\u0015\t!d$A\u0004m_\u001eL7-\u00197\n\u0005Y\u001a$a\u0003'pO&\u001c\u0017\r\u001c)mC:$\u0012aJ\u0001\bE\u0006$8\r[3t+\u0005Q\u0004cA\u001eC\t6\tAH\u0003\u0002>}\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"=\u0005\u0011a\u0015n\u001d;\u0011\u0005\u00153U\"A\u0002\n\u0005\u001d{#!\u0002\"bi\u000eD\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u0019Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8\u0016\u0003-\u0003\"A\r'\n\u00055\u001b$!\u0004'pG\u0006d'+\u001a7bi&|g.A\u0007uKN$(+\u001a7bi&|g\u000e\t")
public class LikeSimplificationSuite
extends SparkFunSuite
implements PlanTest {
    private volatile LikeSimplificationSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public LikeSimplificationSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        LikeSimplificationSuite likeSimplificationSuite = this;
        synchronized (likeSimplificationSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new LikeSimplificationSuite$Optimize$(this);
            }
        }
    }

    public LikeSimplificationSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string()}));
        this.test("simplify Like into StartsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc%"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc\\%"))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc\\%"))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("simplify Like into EndsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%xyz")));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("xyz")))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("simplify Like into startsWith and EndsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc\\%def"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc%def"))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc\\%def"))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Length((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(6))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)new StartsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("abc"))).$amp$amp((Expression)new EndsWith((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("def"))))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("simplify Like into Contains", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%mn%"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%mn\\%"))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Contains((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package.expressions$.MODULE$.stringToLiteral("mn"))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("%mn\\%"))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("simplify Like into EqualTo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral(""))).$bar$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral(""))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("abc"))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("null pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)new Literal(null, (DataType)StringType$.MODULE$)))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            this.comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new Literal(null, (DataType)BooleanType$.MODULE$))).analyze(), this.comparePlans$default$3());
        }, new Position("LikeSimplificationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }
}

