/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.optimizer.RemoveRedundantSortsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G\u001d)a\u0005\u0001E\u0001O\u0019)\u0011\u0006\u0001E\u0001U!)!e\u0001C\u0001o!9\u0001h\u0001b\u0001\n\u0003I\u0004B\u0002%\u0004A\u0003%!\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0005e\u0011V-\\8wKJ+G-\u001e8eC:$8k\u001c:ugN+\u0018\u000e^3\u000b\u0005-a\u0011!C8qi&l\u0017N_3s\u0015\tia\"\u0001\u0005dCR\fG._:u\u0015\ty\u0001#A\u0002tc2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0004\b\t\u00033ii\u0011\u0001E\u0005\u00037A\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\r\u0003\u0015\u0001H.\u00198t\u0013\t\tcD\u0001\u0005QY\u0006tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!\"\u0001\u0005PaRLW.\u001b>f!\tA3!D\u0001\u0001\u0005!y\u0005\u000f^5nSj,7CA\u0002,!\ras&M\u0007\u0002[)\u0011a\u0006D\u0001\u0006eVdWm]\u0005\u0003a5\u0012ABU;mK\u0016CXmY;u_J\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0010\u0002\u000f1|w-[2bY&\u0011ag\r\u0002\f\u0019><\u0017nY1m!2\fg\u000eF\u0001(\u0003\u001d\u0011\u0017\r^2iKN,\u0012A\u000f\t\u0004w\t#U\"\u0001\u001f\u000b\u0005ur\u0014!C5n[V$\u0018M\u00197f\u0015\ty\u0004)\u0001\u0006d_2dWm\u0019;j_:T\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007r\u0012A\u0001T5tiB\u0011QIR\u0007\u0002\u0007%\u0011qi\f\u0002\u0006\u0005\u0006$8\r[\u0001\tE\u0006$8\r[3tA\u0005aA/Z:u%\u0016d\u0017\r^5p]V\t1\n\u0005\u00023\u0019&\u0011Qj\r\u0002\u000e\u0019>\u001c\u0017\r\u001c*fY\u0006$\u0018n\u001c8\u0002\u001bQ,7\u000f\u001e*fY\u0006$\u0018n\u001c8!\u0001")
public class RemoveRedundantSortsSuite
extends SparkFunSuite
implements PlanTest {
    private volatile RemoveRedundantSortsSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public RemoveRedundantSortsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        RemoveRedundantSortsSuite removeRedundantSortsSuite = this;
        synchronized (removeRedundantSortsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new RemoveRedundantSortsSuite$Optimize$(this);
            }
        }
    }

    public RemoveRedundantSortsSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
        this.test("remove redundant order by", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan unnecessaryReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(unnecessaryReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).analyze();
            this.comparePlans((LogicalPlan)this.Optimize().execute((TreeNode)optimized), correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("do not remove sort if the order is different", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc_nullsFirst()}));
            LogicalPlan reorderedDifferently = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("filters don't affect order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("limits don't affect order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("different sorts are not simplified if limit is in between", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("range is already sorted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range inputPlan = Range$.MODULE$.apply(1L, 1000L, 1L, 10);
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
            LogicalPlan reversedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).desc()}));
            LogicalPlan reversedOptimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze());
            LogicalPlan reversedCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze();
            this.comparePlans(reversedOptimized, reversedCorrectAnswer, this.comparePlans$default$3());
            Range negativeStepInputPlan = Range$.MODULE$.apply(10L, 1L, -1L, 10);
            LogicalPlan negativeStepOrderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)negativeStepInputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "id")).desc()}));
            LogicalPlan negativeStepOptimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(negativeStepOrderedPlan).analyze());
            LogicalPlan negativeStepCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)negativeStepInputPlan).analyze();
            this.comparePlans(negativeStepOptimized, negativeStepCorrectAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("sort should not be removed when there is a node which doesn't guarantee any order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan groupedAndResorted = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("remove two consecutive sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedTwice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwice).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("remove sorts separated by Filter/Project operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan orderedTwiceWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithProject = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithProject).analyze());
            LogicalPlan correctAnswerWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithProject, correctAnswerWithProject, this.comparePlans$default$3());
            LogicalPlan orderedTwiceWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithFilter = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithFilter).analyze());
            LogicalPlan correctAnswerWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithFilter, correctAnswerWithFilter, this.comparePlans$default$3());
            LogicalPlan orderedTwiceWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}));
            LogicalPlan optimizedWithBoth = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).analyze());
            LogicalPlan correctAnswerWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))).analyze();
            this.comparePlans(optimizedWithBoth, correctAnswerWithBoth, this.comparePlans$default$3());
            LogicalPlan orderedThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()}));
            LogicalPlan optimizedThrice = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedThrice).analyze());
            LogicalPlan correctAnswerThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()}))).analyze();
            this.comparePlans(optimizedThrice, correctAnswerThrice, this.comparePlans$default$3());
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }
}

