/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EmptyFunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.optimizer.RewriteDistinctAggregates$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4Aa\u0004\t\u0001;!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0003j\u0003B\u0002\u001b\u0001A\u0003%a\u0006C\u00046\u0001\t\u0007I\u0011\u0001\u001c\t\rq\u0002\u0001\u0015!\u00038\u0011\u001di\u0004A1A\u0005\u0002yBa!\u0012\u0001!\u0002\u0013y\u0004b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002%\t\u000f=\u0003!\u0019!C\u0001\u000f\"1\u0001\u000b\u0001Q\u0001\n!Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004Z\u0001\u0001\u0006Ia\u0015\u0005\u00065\u0002!Ia\u0017\u0002\u001f%\u0016<(/\u001b;f\t&\u001cH/\u001b8di\u0006;wM]3hCR,7oU;ji\u0016T!!\u0005\n\u0002\u0013=\u0004H/[7ju\u0016\u0014(BA\n\u0015\u0003!\u0019\u0017\r^1msN$(BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011c\u0001\u0001\u001fEA\u0011q\u0004I\u0007\u0002-%\u0011\u0011E\u0006\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0012\u0012!\u00029mC:\u001c\u0018BA\u0014%\u0005!\u0001F.\u00198UKN$\u0018A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u0011\u0003\u0011\u0019wN\u001c4\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u000b\u0002\u0011%tG/\u001a:oC2L!a\r\u0019\u0003\u000fM\u000bFjQ8oM\u0006)1m\u001c8gA\u000591-\u0019;bY><W#A\u001c\u0011\u0005aRT\"A\u001d\u000b\u0005U\u0012\u0012BA\u001e:\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001e\f\u0001bY1uC2|w\rI\u0001\tC:\fG.\u001f>feV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C%\u0005A\u0011M\\1msNL7/\u0003\u0002E\u0003\nA\u0011I\\1msj,'/A\u0005b]\u0006d\u0017P_3sA\u00059a.\u001e7m\u0013:$X#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-\u0013\u0012aC3yaJ,7o]5p]NL!!\u0014&\u0003\u000f1KG/\u001a:bY\u0006Aa.\u001e7m\u0013:$\b%\u0001\u0006ok2d7\u000b\u001e:j]\u001e\f1B\\;mYN#(/\u001b8hA\u0005aA/Z:u%\u0016d\u0017\r^5p]V\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002WI\u00059An\\4jG\u0006d\u0017B\u0001-V\u00055aunY1m%\u0016d\u0017\r^5p]\u0006iA/Z:u%\u0016d\u0017\r^5p]\u0002\nAb\u00195fG.\u0014Vm\u001e:ji\u0016$\"\u0001\u00182\u0011\u0005u\u0003W\"\u00010\u000b\u0003}\u000bQa]2bY\u0006L!!\u00190\u0003\tUs\u0017\u000e\u001e\u0005\u0006G:\u0001\r\u0001Z\u0001\be\u0016<(/\u001b;f!\t!V-\u0003\u0002g+\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0001")
public class RewriteDistinctAggregatesSuite
extends SparkFunSuite
implements PlanTest {
    private final SQLConf conf;
    private final SessionCatalog catalog;
    private final Analyzer analyzer;
    private final Literal nullInt;
    private final Literal nullString;
    private final LocalRelation testRelation;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public SQLConf conf() {
        return this.conf;
    }

    public SessionCatalog catalog() {
        return this.catalog;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public Literal nullInt() {
        return this.nullInt;
    }

    public Literal nullString() {
        return this.nullString;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private void checkRewrite(LogicalPlan rewrite) {
        Aggregate aggregate;
        Aggregate aggregate2;
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = rewrite;
        if (!(logicalPlan2 instanceof Aggregate && (logicalPlan = (aggregate2 = (Aggregate)logicalPlan2).child()) instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).child() instanceof Expand)) {
            throw this.fail(new StringBuilder(23).append("Plan is not rewritten:\n").append(rewrite).toString(), new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RewriteDistinctAggregatesSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.conf = new SQLConf().copy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE()), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.GROUP_BY_ORDINAL()), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        this.catalog = new SessionCatalog((ExternalCatalog)new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2()), (FunctionRegistry)EmptyFunctionRegistry$.MODULE$, this.conf());
        this.analyzer = new Analyzer(this.catalog(), this.conf());
        this.nullInt = new Literal(null, (DataType)IntegerType$.MODULE$);
        this.nullString = new Literal(null, (DataType)StringType$.MODULE$);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()}));
        this.test("single distinct group", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan input = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))}))).analyze();
            LogicalPlan rewrite = RewriteDistinctAggregates$.MODULE$.apply(input);
            this.comparePlans(input, rewrite, this.comparePlans$default$3());
        }, new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("single distinct group with partial aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan input = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "agg1")), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.max((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).as((Symbol)SymbolLiteral.bootstrap("apply", "agg2"))}))).analyze();
            LogicalPlan rewrite = RewriteDistinctAggregates$.MODULE$.apply(input);
            this.comparePlans(input, rewrite, this.comparePlans$default$3());
        }, new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("multiple distinct groups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan input = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))}))).analyze();
            this.checkRewrite(RewriteDistinctAggregates$.MODULE$.apply(input));
        }, new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("multiple distinct groups with partial aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan input = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))})), package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))}))).analyze();
            this.checkRewrite(RewriteDistinctAggregates$.MODULE$.apply(input));
        }, new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("multiple distinct groups with non-partial aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan input = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), package.expressions$.MODULE$.countDistinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))})), new CollectSet((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), CollectSet$.MODULE$.apply$default$2(), CollectSet$.MODULE$.apply$default$3()).toAggregateExpression()}))).analyze();
            this.checkRewrite(RewriteDistinctAggregates$.MODULE$.apply(input));
        }, new Position("RewriteDistinctAggregatesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
    }
}

