/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamePlaceholder$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedNamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.UnresolvedWindowExpression;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.WindowSpecReference;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)4A\u0001C\u0005\u0001-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u0004M\u0001E\u0005I\u0011A'\t\u000ba\u0003A\u0011A-\t\u000b\u0001\u0004A\u0011B1\u0003+\u0015C\bO]3tg&|g\u000eU1sg\u0016\u00148+^5uK*\u0011!bC\u0001\u0007a\u0006\u00148/\u001a:\u000b\u00051i\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u000192\u0004\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\u0006\u0002\u000bAd\u0017M\\:\n\u0005\u0001j\"\u0001\u0003)mC:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005I\u0011!\u00043fM\u0006,H\u000e\u001e)beN,'/F\u0001(\u001d\t!\u0003&\u0003\u0002*\u0013\u0005\t2)\u0019;bYf\u001cHoU9m!\u0006\u00148/\u001a:\u0002\u001d\u0011,g-Y;miB\u000b'o]3sA\u0005Y\u0011m]:feR,\u0015/^1m)\u0011i3\u0007\u0011%\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006i\u0011\u0001\r!N\u0001\u000bgFd7i\\7nC:$\u0007C\u0001\u001c>\u001d\t94\b\u0005\u00029_5\t\u0011H\u0003\u0002;+\u00051AH]8pizJ!\u0001P\u0018\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y=BQ!\u0011\u0003A\u0002\t\u000b\u0011!\u001a\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b.\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011q\t\u0012\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007b\u0002\u0006\u0005!\u0003\u0005\r!\u0013\t\u0003I)K!aS\u0005\u0003\u001fA\u000b'o]3s\u0013:$XM\u001d4bG\u0016\fQ#Y:tKJ$X)];bY\u0012\"WMZ1vYR$3'F\u0001OU\tIujK\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0005v]\u000eDWmY6fI*\u0011QkL\u0001\u000bC:tw\u000e^1uS>t\u0017BA,S\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nS:$XM]2faR$2!\f.\\\u0011\u0015!d\u00011\u00016\u0011\u0015af\u00011\u0001^\u0003!iWm]:bO\u0016\u001c\bc\u0001\u0018_k%\u0011ql\f\u0002\u000byI,\u0007/Z1uK\u0012t\u0014A\u00017w)\t\u0011W\r\u0005\u0002DG&\u0011A\r\u0012\u0002\u001e+:\u0014Xm]8mm\u0016$g*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\")am\u0002a\u0001O\u0006\t1\u000f\u0005\u0002/Q&\u0011\u0011n\f\u0002\u0007'fl'm\u001c7")
public class ExpressionParserSuite
extends SparkFunSuite
implements PlanTest {
    private final CatalystSqlParser$ defaultParser;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public CatalystSqlParser$ defaultParser() {
        return this.defaultParser;
    }

    public void assertEqual(String sqlCommand, Expression e, ParserInterface parser) {
        this.compareExpressions(parser.parseExpression(sqlCommand), e);
    }

    public ParserInterface assertEqual$default$3() {
        return this.defaultParser();
    }

    public void intercept(String sqlCommand, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.defaultParser().parseExpression(sqlCommand), ClassTag$.MODULE$.apply(ParseException.class), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = message;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        });
    }

    private UnresolvedNamedLambdaVariable lv(Symbol s) {
        return new UnresolvedNamedLambdaVariable((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s.name()})));
    }

    public static final /* synthetic */ String $anonfun$new$5(int x) {
        return new StringBuilder(4).append(x).append(" == ").append(x).toString();
    }

    private final void testVeryBinaryExpression$1(String op, Class clazz) {
        String sql = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)x -> ExpressionParserSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(op);
        Expression e = this.defaultParser().parseExpression(sql);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof EqualTo;
                return bl;
            }
        }).size()));
        int $org_scalatest_assert_macro_right = 1000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new scala.Serializable(null, clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.clazz$1.isInstance(A1) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = this.clazz$1.isInstance(expression);
                return bl;
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).size()));
        int $org_scalatest_assert_macro_right2 = 999;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    private static final Expression windowed$1(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$1) {
        return new WindowExpression((Expression)func$1, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final Seq windowed$default$2$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final WindowFrame windowed$default$3$1() {
        return UnspecifiedFrame$.MODULE$;
    }

    private static final Expression windowed$2(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$2) {
        return new WindowExpression((Expression)func$2, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final Seq windowed$default$2$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private static final WindowFrame windowed$default$3$2() {
        return UnspecifiedFrame$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$24(ExpressionParserSuite $this, String frameTypeSql$1, Product frameType$1, UnresolvedFunction func$2, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String boundarySql = (String)tuple3._1();
        Expression begin = (Expression)tuple3._2();
        Expression end = (Expression)tuple3._3();
        String query = new StringBuilder(41).append("foo(*) over (partition by a order by b ").append(frameTypeSql$1).append(" ").append(boundarySql).append(")").toString();
        Expression expr = ExpressionParserSuite.windowed$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), (WindowFrame)new SpecifiedWindowFrame((FrameType)frameType$1, begin, end), func$2);
        $this.assertEqual(query, expr, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$23(ExpressionParserSuite $this, Seq boundaries$1, UnresolvedFunction func$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String frameTypeSql = (String)tuple2._1();
        Product frameType = (Product)tuple2._2();
        boundaries$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExpressionParserSuite.$anonfun$new$24($this, frameTypeSql, frameType, func$2, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ byte $anonfun$new$33(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$new$34(int x$2) {
        return (byte)x$2;
    }

    private final void testDecimal$1(String value) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(value).underlying()), this.assertEqual$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$37(ExpressionParserSuite $this, boolean escape) {
        SQLConf conf = new SQLConf();
        conf.setConfString(SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)escape)).toString());
        CatalystSqlParser parser = new CatalystSqlParser(conf);
        $this.assertEqual("\"hello\"", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
        $this.assertEqual("'hello'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
        $this.assertEqual("\"hello\" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("helloworld"), (ParserInterface)parser);
        $this.assertEqual("'hello' \" \" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello world"), (ParserInterface)parser);
        $this.assertEqual("'pattern%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), (ParserInterface)parser);
        $this.assertEqual("'no-pattern\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("no-pattern\\%"), (ParserInterface)parser);
        if (escape) {
            $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
            $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\\\%"), (ParserInterface)parser);
            $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\0"), (ParserInterface)parser);
            ParseException e = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> parser.parseExpression("'''"), ClassTag$.MODULE$.apply(ParseException.class), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "extraneous input '''";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\\""), (ParserInterface)parser);
            $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\b"), (ParserInterface)parser);
            $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\n"), (ParserInterface)parser);
            $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\r"), (ParserInterface)parser);
            $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\t"), (ParserInterface)parser);
            $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\110\\145\\154\\154\\157\\041"), (ParserInterface)parser);
            $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029"), (ParserInterface)parser);
        } else {
            $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\%"), (ParserInterface)parser);
            $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
            $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u0000"), (ParserInterface)parser);
            $this.assertEqual("'\\''", (Expression)package.expressions$.MODULE$.stringToLiteral("'"), (ParserInterface)parser);
            $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\""), (ParserInterface)parser);
            $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\b"), (ParserInterface)parser);
            $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\n"), (ParserInterface)parser);
            $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\r"), (ParserInterface)parser);
            $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\t"), (ParserInterface)parser);
            $this.assertEqual("'\\Z'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u001a"), (ParserInterface)parser);
            $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("Hello!"), (ParserInterface)parser);
            $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("World :)"), (ParserInterface)parser);
        }
    }

    private static final Literal intervalLiteral$1(String u, String s) {
        return Literal$.MODULE$.apply((Object)CalendarInterval.fromSingleUnitString((String)u, (String)s));
    }

    public static final /* synthetic */ void $anonfun$new$42(ExpressionParserSuite $this, String unit$1, String form$1, String value) {
        Literal expected = ExpressionParserSuite.intervalLiteral$1(unit$1, value);
        $this.assertEqual(new StringBuilder(10).append("interval ").append(value).append(" ").append(unit$1).append(form$1).toString(), (Expression)expected, $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(12).append("interval '").append(value).append("' ").append(unit$1).append(form$1).toString(), (Expression)expected, $this.assertEqual$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$43(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)CalendarInterval.fromYearMonthString((String)value));
        $this.assertEqual(new StringBuilder(25).append("interval '").append(value).append("' year to month").toString(), (Expression)result, $this.assertEqual$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$44(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)CalendarInterval.fromDayTimeString((String)value));
        $this.assertEqual(new StringBuilder(25).append("interval '").append(value).append("' day to second").toString(), (Expression)result, $this.assertEqual$default$3());
    }

    public ExpressionParserSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.defaultParser = CatalystSqlParser$.MODULE$;
        this.test("star expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("*", (Expression)new UnresolvedStar((Option)None$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a.b.*", (Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("named expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallSite r0 = SymbolLiteral.bootstrap("apply", "a");
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)r0), this.assertEqual$default$3());
            NamedExpression r1 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("b");
            this.assertEqual("a as b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a as (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("a() (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).function((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("1SL", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1SL")), this.assertEqual$default$3());
            this.assertEqual("a.* b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))))).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a and b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a or b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a and b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))), this.assertEqual$default$3());
            this.assertEqual("a or b or c or d or e or f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
            this.assertEqual("a and b and c and d and e and f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("long binary logical expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testVeryBinaryExpression$1(" AND ", And.class);
            this.testVeryBinaryExpression$1(" OR ", Or.class);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("not expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("not a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("!a", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("not true > true", (Expression)new Not((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)package.expressions$.MODULE$.booleanToLiteral(true))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("exists expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("exists (select 1 from b where b.x = a.x)", (Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("b")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b.x")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a.x"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3()), this.assertEqual$default$3()), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("comparison expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a = b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a == b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <=> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a != b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$bang$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a < b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a <= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !> b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a > b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a >= b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a !< b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("between expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")))), this.assertEqual$default$3());
            this.assertEqual("a not between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("in expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (b, c, d)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))})), this.assertEqual$default$3());
            this.assertEqual("a not in (b, c, d)", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("in sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a in (select b from c)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a, b, c) in (select d, e, f from g)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("g")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "f"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a, b) in (select c from d)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("d")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
            this.assertEqual("(a) in (select b from c)", (Expression)new InSubquery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("like expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a like 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not like 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a rlike 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a regexp 'pattern%'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("like expressions with ESCAPED_STRING_LITERALS = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLConf conf = new SQLConf();
            conf.setConfString(SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key(), "true");
            CatalystSqlParser parser = new CatalystSqlParser(conf);
            this.assertEqual("a rlike '^\\x20[\\x20-\\x23]+$'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("^\\x20[\\x20-\\x23]+$")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\\\'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\t\\n'", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\t\\n")), (ParserInterface)parser);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("is null expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNull(), this.assertEqual$default$3());
            this.assertEqual("a is not null", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).isNotNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is not null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).isNotNull(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("is distinct expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a is distinct from b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a is not distinct from b", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less$eq$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("binary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a * b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a / b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a DIV b", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).cast((DataType)LongType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a % b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a + b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a - b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a & b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$amp((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a ^ b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$up((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a | b", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a * t | b ^ c & d - e + f % g DIV h / i * k", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t")))).$bar(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).$up(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).$amp(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$minus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$plus(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).$percent((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g")))).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "h")))).cast((DataType)LongType$.MODULE$)).$div((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "i")))).$times((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "k"))))))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("unary arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("+a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("-a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$minus(), this.assertEqual$default$3());
            this.assertEqual("~a", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde(), this.assertEqual$default$3());
            this.assertEqual("-+~~a", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).unary_$tilde()).unary_$tilde()).unary_$minus(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("cast expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("cast(a as int)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as timestamp)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as array<int>)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("cast(cast(a as int) as long)", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("foo()", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("foo.bar()", (Expression)new UnresolvedFunction(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), (Seq)Seq$.MODULE$.empty(), false), this.assertEqual$default$3());
            this.assertEqual("foo(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("count(*)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "count")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), this.assertEqual$default$3());
            this.assertEqual("foo(a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("foo(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("grouping(distinct a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "grouping")).distinctFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.assertEqual("`select`(all a, b)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "select")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), this.assertEqual$default$3());
            this.intercept("foo(a x)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extraneous input 'x'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("lambda functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("x -> x + 1", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
            this.assertEqual("(x, y) -> x + y", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x")), this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("foo(*) over w1", (Expression)new UnresolvedWindowExpression((Expression)func, new WindowSpecReference("w1")), this.assertEqual$default$3());
            this.assertEqual("foo(*) over ()", ExpressionParserSuite.windowed$1(ExpressionParserSuite.windowed$default$1$1(), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (cluster by a, b)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (order by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (sort by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).desc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b order by c)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b sort by c)", ExpressionParserSuite.windowed$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product) + (1)) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product / 2) + 1) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "product")).$div((Expression)package.expressions$.MODULE$.intToLiteral(2))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("range/rows window function expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Seq frameTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"rows", (Object)RowFrame$.MODULE$), new Tuple2((Object)"range", (Object)RangeFrame$.MODULE$)}));
            Seq boundaries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"unbounded preceding", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483648 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 following", (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483649 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded following", (Object)UnboundedFollowing$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and 5 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and 3 + 1 following", (Object)UnboundedPreceding$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))), new Tuple3((Object)"between unbounded preceding and 2147483649 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between unbounded preceding and current row", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 10 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 0 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and 0 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"between current row and 5 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between current row and 3 + 1 following", (Object)CurrentRow$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))), new Tuple3((Object)"between current row and 2147483649 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between current row and unbounded following", (Object)CurrentRow$.MODULE$, (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 0 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and 5 following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and unbounded following", (Object)UnboundedPreceding$.MODULE$, (Object)UnboundedFollowing$.MODULE$)}));
            frameTypes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExpressionParserSuite.$anonfun$new$23(this, boundaries, func, x0$1);
                return BoxedUnit.UNIT;
            });
            this.intercept("foo(*) over (partition by a order by b rows exp(b) preceding)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame bound value must be a literal."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("row constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a, b)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))), this.assertEqual$default$3());
            this.assertEqual("(a, b, c)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))), this.assertEqual$default$3());
            this.assertEqual("(a as b, b as c)", (Expression)CreateStruct$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(select max(val) from tbl) > current", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("tbl")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "val"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "current"))), this.assertEqual$default$3());
            this.assertEqual("a = (select b from s)", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("s")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.test("case when", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("case a when 1 then b when 2 then c else d end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.intToLiteral(2), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))), this.assertEqual$default$3());
            this.assertEqual("case (a or b) when true then c when false then d else e end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$bar$bar((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c")), package.expressions$.MODULE$.booleanToLiteral(false), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))), this.assertEqual$default$3());
            this.assertEqual("case 'a'='a' when true then 1 end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslString("a").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.intToLiteral(1)}))), this.assertEqual$default$3());
            this.assertEqual("case when a = 1 then b when a = 2 then c else d end", (Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).expr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr())})), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d"))), this.assertEqual$default$3());
            this.assertEqual("case when (1) + case when a > b then c else d end then f else g end", (Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)CaseWhen$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).expr())})), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).expr())), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).expr())})), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("dereference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a.b", (Expression)UnresolvedAttribute$.MODULE$.apply("a.b"), this.assertEqual$default$3());
            this.assertEqual("`select`.b", (Expression)UnresolvedAttribute$.MODULE$.apply("select.b"), this.assertEqual$default$3());
            this.assertEqual("(a + b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))).getField("b"), this.assertEqual$default$3());
            this.assertEqual("struct(a, b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.namedStruct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{NamePlaceholder$.MODULE$, package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), NamePlaceholder$.MODULE$, package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).getField("b"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("1a", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "1a")), this.assertEqual$default$3());
            this.assertEqual("`select`", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "select")), this.assertEqual$default$3());
            this.assertEqual("columns", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "columns")), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        this.test("subscript", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("a[b]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
            this.assertEqual("a[1 + 1]", (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).getItem(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))), this.assertEqual$default$3());
            this.assertEqual("`c`.a[b]", (Expression)package.expressions$.MODULE$.DslExpression((Expression)UnresolvedAttribute$.MODULE$.apply("c.a")).getItem((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("(a)", (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.assertEqual$default$3());
            this.assertEqual("r * (a + b)", package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "r")).$times(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("type constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("dAte '2016-03-11'", (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-11")), this.assertEqual$default$3());
            this.intercept("DAtE 'mar 11 2016'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
            this.intercept("timestamP '2016-33-11 20:54:00.000'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("X'A'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{10})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$33(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.assertEqual("x'A10C'", (Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{161, 12})).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$34(BoxesRunTime.unboxToInt((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), this.assertEqual$default$3());
            this.intercept("x'A1OC'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.intercept("GEO '(10,-6)'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Literals of type 'GEO' are currently not supported."}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("null", (Expression)Literal$.MODULE$.apply(null), this.assertEqual$default$3());
            this.assertEqual("trUe", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.assertEqual$default$3());
            this.assertEqual("False", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.assertEqual$default$3());
            this.assertEqual("787324", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)787324)), this.assertEqual$default$3());
            this.assertEqual("7873247234798249234", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)7873247234798249234L)), this.assertEqual$default$3());
            this.testDecimal$1("78732472347982492793712334");
            this.testDecimal$1("7873247234798249279371.2334");
            this.testDecimal$1("9.0e1");
            this.testDecimal$1(".9e+2");
            this.testDecimal$1("0.9e+2");
            this.testDecimal$1("900e-1");
            this.testDecimal$1("900.0E-1");
            this.testDecimal$1("9.e+1");
            this.intercept(".e3", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("10Y", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)10))), this.assertEqual$default$3());
            this.intercept("-1000Y", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(-128).append(", ").append(127).append("]").toString()}));
            this.assertEqual("10S", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)10))), this.assertEqual$default$3());
            this.intercept("40000S", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Short.MIN_VALUE).append(", ").append(Short.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10L", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), this.assertEqual$default$3());
            this.intercept("78732472347982492793712334L", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("does not fit in range [").append(Long.MIN_VALUE).append(", ").append(Long.MAX_VALUE).append("]").toString()}));
            this.assertEqual("10.0D", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)), this.assertEqual$default$3());
            this.intercept("-1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.intercept("1.8E308D", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not fit in range"}));
            this.assertEqual("90912830918230182310293801923652346786BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("90912830918230182310293801923652346786").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.0E-28BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.0E-28").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.08BD", (Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("123.08").underlying()), this.assertEqual$default$3());
            this.intercept("1.20E-38BD", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal can only support precision up to 38"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("strings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)escape -> {
            ExpressionParserSuite.$anonfun$new$37(this, BoxesRunTime.unboxToBoolean((Object)escape));
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.test("intervals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("interval", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"at least one time unit should be given for interval literal"}));
            Seq units = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month", "week", "day", "hour", "minute", "second", "millisecond", "microsecond"}));
            Seq forms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"}));
            Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "-7", "21"}));
            units.foreach((Function1 & Serializable & scala.Serializable)unit -> {
                forms.foreach((Function1 & Serializable & scala.Serializable)form -> {
                    values$1.foreach((Function1 & Serializable & scala.Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$42($this, unit$1, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.assertEqual("interval 13.123456789 seconds", (Expression)ExpressionParserSuite.intervalLiteral$1("second", "13.123456789"), this.assertEqual$default$3());
            this.assertEqual("interval -13.123456789 second", (Expression)ExpressionParserSuite.intervalLiteral$1("second", "-13.123456789"), this.assertEqual$default$3());
            this.intercept("interval 10 nanoseconds", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No interval can be constructed"}));
            Seq yearMonthValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"123-10", "496-0", "-2-3", "-123-0"}));
            yearMonthValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                ExpressionParserSuite.$anonfun$new$43(this, value);
                return BoxedUnit.UNIT;
            });
            Seq datTimeValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"99 11:22:33.123456789", "-99 11:22:33.123456789", "10 9:8:7.123456789", "1 0:0:0", "-1 0:0:0", "1 0:0:1"}));
            datTimeValues.foreach((Function1 & Serializable & scala.Serializable)value -> {
                ExpressionParserSuite.$anonfun$new$44(this, value);
                return BoxedUnit.UNIT;
            });
            this.intercept("interval 10 month to second", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals FROM month TO second are not supported."}));
            this.assertEqual("interval 3 months 22 seconds 1 millisecond", (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(3, 22001000L)), this.assertEqual$default$3());
            this.assertEqual("interval 3 years '-1-10' year to month 3 weeks '1 0:0:2' day to second", (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(14, 1900802000000L)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("composed expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("1 + r.r As q", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)UnresolvedAttribute$.MODULE$.apply("r.r"))).as("q"), this.assertEqual$default$3());
            this.assertEqual("1 - f('o', o(bar))", package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$minus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("o"), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "o")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "bar"))}))}))), this.assertEqual$default$3());
            this.intercept("1 - f('o', o(bar)) hello * world", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input '*'"}));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
        this.test("SPARK-17364, fully qualified column name which starts with number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("123_", (Expression)UnresolvedAttribute$.MODULE$.apply("123_"), this.assertEqual$default$3());
            this.assertEqual("1a.123_", (Expression)UnresolvedAttribute$.MODULE$.apply("1a.123_"), this.assertEqual$default$3());
            this.assertEqual("a.123A", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123A"), this.assertEqual$default$3());
            this.assertEqual("a.123E3_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123E3_column"), this.assertEqual$default$3());
            this.assertEqual("a.123D_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123D_column"), this.assertEqual$default$3());
            this.assertEqual("a.123BD_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123BD_column"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("SPARK-17832 function identifier contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FunctionIdentifier complexName = new FunctionIdentifier("`ba`r", (Option)new Some((Object)"`fo`o"));
            this.assertEqual(complexName.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("`fo`o.`ba`r"), this.assertEqual$default$3());
            this.intercept(complexName.unquotedString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input"}));
            FunctionIdentifier complexName2 = new FunctionIdentifier("ba``r", (Option)new Some((Object)"fo``o"));
            this.assertEqual(complexName2.quotedString(), (Expression)UnresolvedAttribute$.MODULE$.apply("fo``o.ba``r"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        this.test("SPARK-19526 Support ignore nulls keywords for first and last", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("first(a ignore nulls)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("first(a)", (Expression)new First((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a ignore nulls)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a)", (Expression)new Last((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))).toAggregateExpression(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
    }
}

